/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import jrobots.simulation.simulationObjects.JRobot2011;
import jrobots.utils.Angle;
import jrobots.utils.LinearPredictor;
import jrobots.utils.Scan;
import jrobots.utils.Vector;

public class EnsignDuck
extends JRobot2011 {
    private ScanState scanState = ScanState.DUMB;
    private Angle scanAperture = EnsignDuck.getMaxScanAperture();
    private int scanHemisphere = 0;
    private Scan scan1st = null;
    private Scan scan2nd = null;

    private void collect() {
        if (this.isScanFromNow()) {
            Scan scan = this.getLastScan();
            switch (this.scanState) {
                case DUMB: {
                    if (scan.isTargetLocated()) {
                        if (scan.distanceToTarget > 15.0) {
                            this.scan1st = scan;
                            this.scan2nd = null;
                            this.scanState = ScanState.TARGETTING;
                            this.scanAperture = EnsignDuck.getMaxScanAperture().mult(0.5);
                            this.scanHemisphere = 0;
                            break;
                        }
                        this.scan2nd = this.scan1st;
                        this.scan1st = scan;
                        ++this.scanHemisphere;
                        break;
                    }
                    ++this.scanHemisphere;
                    break;
                }
                case TARGETTING: {
                    if (scan.isTargetLocated()) {
                        this.scan2nd = this.scan1st;
                        this.scan1st = scan;
                        this.scanAperture = this.scanAperture.mult(0.5);
                        this.scanHemisphere = 0;
                        break;
                    }
                    if (this.scanHemisphere == 0) {
                        ++this.scanHemisphere;
                        break;
                    }
                    if (this.scanHemisphere == 1) {
                        ++this.scanHemisphere;
                        break;
                    }
                    if (this.scanAperture.getValueAsDegrees() <= EnsignDuck.getMaxScanAperture().getValueAsDegrees() * 0.6) {
                        this.scanAperture = this.scanAperture.mult(2.0);
                        this.scanHemisphere = 0;
                        break;
                    }
                    this.scanAperture = EnsignDuck.getMaxScanAperture();
                    this.scanState = ScanState.DUMB;
                    this.scan1st = null;
                    this.scan2nd = null;
                    this.scanHemisphere = 0;
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected scan state.");
                }
            }
        }
    }

    private void scan() {
        this.setScanAperture(this.scanAperture);
        switch (this.scanState) {
            case DUMB: {
                this.scanHemisphere = (int)((double)this.scanHemisphere % Math.ceil(360.0 / this.scanAperture.getValueAsDegrees()));
                this.setScanDirection(this.scanAperture.mult(this.scanHemisphere));
                break;
            }
            case TARGETTING: {
                Angle targetAngle = this.scan2nd != null ? this.scan1st.estimatedTargetPosition().sub(this.getPosition()).getAngle() : this.scan1st.estimatedTargetPosition().sub(this.getPosition()).getAngle();
                if (this.scanHemisphere == 0) {
                    this.setScanDirection(targetAngle.sub(this.scanAperture.mult(0.5)));
                    break;
                }
                if (this.scanHemisphere == 1) {
                    this.setScanDirection(targetAngle.add(this.scanAperture.mult(0.5)));
                    break;
                }
                this.setScanDirection(this.scan1st.scanDirection);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected scan state.");
            }
        }
    }

    private void shoot() {
        if (this.scan1st != null) {
            if (this.scan2nd != null) {
                Vector extrapolatedTargetPos = LinearPredictor.predict(this.scan1st, this.scan2nd, this.getTime());
                Vector extrapolatedProjectileTargetPos = LinearPredictor.predict(this.scan1st, this.scan2nd, this.getTime() + extrapolatedTargetPos.sub(this.getPosition()).getLength() / EnsignDuck.getProjectileSpeed());
                this.addDebugArrow(this.scan1st.estimatedTargetPosition(), extrapolatedTargetPos);
                this.addDebugArrow(this.scan1st.estimatedTargetPosition(), extrapolatedProjectileTargetPos);
                this.setLaunchProjectileCommand(extrapolatedProjectileTargetPos.sub(this.getPosition()).getAngle());
                this.setAutopilot(extrapolatedTargetPos.sub(this.getPosition()).getAngle(), 0.015);
            } else {
                this.addDebugCrosshair(this.scan1st.estimatedTargetPosition());
                this.setLaunchProjectileCommand(this.scan1st.estimatedTargetPosition().sub(this.getPosition()).getAngle());
            }
        }
    }

    private void drive() {
    }

    @Override
    protected void actions() {
        this.collect();
        this.scan();
        this.shoot();
        this.drive();
    }

    @Override
    protected void init() {
        this.setBodyColor(Color.GREEN);
        this.setTurretColor(Color.LIGHT_GRAY);
        this.setNameColor(Color.green);
        this.scanState = ScanState.DUMB;
        this.scanAperture = EnsignDuck.getMaxScanAperture();
        this.scanHemisphere = 0;
        this.scan1st = null;
        this.scan2nd = null;
    }

    private static enum ScanState {
        DUMB,
        TARGETTING;

    }
}

