/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.util.Arrays;
import jrobots.simulation.simulationObjects.JRobot2012;
import jrobots.utils.Angle;
import jrobots.utils.LinearPredictor;
import jrobots.utils.Scan;
import jrobots.utils.Vector;

public class RuchetarioMk3
extends JRobot2012 {
    private static final long serialVersionUID = 1L;
    private static double DRIVE_DISTANCE_FACTOR = 0.7;
    private static double DRIVE_ALTERATION_PERIOD = 9.0;
    private static Vector DRIVE_ALTERATION_AMPLITUDE = new Vector(10.0, 60.0);
    private ScanState scanState = ScanState.DUMB;
    private Angle scanAperture = RuchetarioMk3.getMaxScanAperture();
    private int scanHemisphere = 0;
    private Scan scan1st = null;
    private Scan scan2nd = null;
    private Angle rocketDir = null;
    private Vector[] oldRocketPos = new Vector[0];
    private float rocketStartTime = 0.0f;

    private void collect() {
        if (this.isScanFromNow()) {
            Scan scan = this.getLastScan();
            switch (this.scanState) {
                case DUMB: {
                    if (scan.isTargetLocated()) {
                        if (scan.distanceToTarget > 15.0) {
                            this.scan1st = scan;
                            this.scan2nd = null;
                            this.scanState = ScanState.TARGETTING;
                            this.scanAperture = RuchetarioMk3.getMaxScanAperture().mult(0.5);
                            this.scanHemisphere = 0;
                            break;
                        }
                        this.scan2nd = this.scan1st;
                        this.scan1st = scan;
                        ++this.scanHemisphere;
                        break;
                    }
                    ++this.scanHemisphere;
                    break;
                }
                case TARGETTING: {
                    if (scan.isTargetLocated()) {
                        this.scan2nd = this.scan1st;
                        this.scan1st = scan;
                        this.scanAperture = this.scanAperture.mult(0.5);
                        this.scanHemisphere = 0;
                        break;
                    }
                    if (this.scanHemisphere == 0) {
                        ++this.scanHemisphere;
                        break;
                    }
                    if (this.scanHemisphere == 1) {
                        ++this.scanHemisphere;
                        break;
                    }
                    if (this.scanAperture.getValueAsDegrees() <= RuchetarioMk3.getMaxScanAperture().getValueAsDegrees() * 0.6) {
                        this.scanAperture = this.scanAperture.mult(2.0);
                        this.scanHemisphere = 0;
                        break;
                    }
                    this.scanAperture = RuchetarioMk3.getMaxScanAperture();
                    this.scanState = ScanState.DUMB;
                    this.scan1st = null;
                    this.scan2nd = null;
                    this.scanHemisphere = 0;
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected scan state.");
                }
            }
        }
    }

    private void scan() {
        this.setScanAperture(this.scanAperture);
        switch (this.scanState) {
            case DUMB: {
                this.scanHemisphere = (int)((double)this.scanHemisphere % Math.ceil(360.0 / this.scanAperture.getValueAsDegrees()));
                this.setScanDirection(this.scanAperture.mult(this.scanHemisphere));
                break;
            }
            case TARGETTING: {
                Angle targetAngle = this.scan2nd != null ? this.scan1st.estimatedTargetPosition().sub(this.getPosition()).getAngle() : this.scan1st.estimatedTargetPosition().sub(this.getPosition()).getAngle();
                if (this.scanHemisphere == 0) {
                    this.setScanDirection(targetAngle.sub(this.scanAperture.mult(0.5)));
                    break;
                }
                if (this.scanHemisphere == 1) {
                    this.setScanDirection(targetAngle.add(this.scanAperture.mult(0.5)));
                    break;
                }
                this.setScanDirection(this.scan1st.scanDirection);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected scan state.");
            }
        }
    }

    private void shoot() {
        Vector[] rocketPos = this.getDirectablePositions();
        this.oldRocketPos = Arrays.copyOf(this.oldRocketPos, rocketPos.length);
        if (this.scan1st != null) {
            if (this.scan2nd != null) {
                int rocketIdx = 0;
                while (rocketIdx < rocketPos.length) {
                    double rocketSpeed = 0.33 * RuchetarioMk3.getMaxVelocityRocket();
                    if (this.oldRocketPos[rocketIdx] != null) {
                        rocketSpeed = 0.67 * rocketPos[rocketIdx].sub(this.oldRocketPos[rocketIdx]).getLength() * (double)RuchetarioMk3.getFramesPerSecond() + 0.33 * RuchetarioMk3.getMaxVelocityRocket();
                    }
                    Vector extrapolatedTargetPos = LinearPredictor.predict(this.scan1st, this.scan2nd, this.getTime());
                    this.addDebugArrow(this.scan1st.estimatedTargetPosition(), extrapolatedTargetPos);
                    if (rocketPos.length == 0) {
                        this.rocketDir = extrapolatedTargetPos.sub(this.getPosition()).getAngle();
                        this.setLaunchRocket(this.rocketDir);
                        this.rocketStartTime = (float)this.getTime();
                    } else if (this.rocketDir == null) {
                        this.rocketDir = extrapolatedTargetPos.sub(rocketPos[rocketIdx]).getAngle();
                        this.setRocketHeading(rocketIdx, this.rocketDir);
                    } else {
                        Vector extrapolatedHittingPos = LinearPredictor.predict(this.scan1st, this.scan2nd, this.getTime() + rocketPos[rocketIdx].distanceTo(extrapolatedTargetPos) / rocketSpeed);
                        this.addDebugCrosshair(extrapolatedHittingPos);
                        double missDistance = Math.abs(extrapolatedHittingPos.sub(rocketPos[rocketIdx]).projection(this.rocketDir.getNextQuadrant()));
                        if (Math.abs(extrapolatedHittingPos.sub((Vector)rocketPos[rocketIdx]).getAngle().angularDistance((Angle)this.rocketDir).angle) > 1.8849555921538759) {
                            missDistance = Double.MAX_VALUE;
                        }
                        if (this.oldRocketPos[rocketIdx] != null && this.getEnergy() >= RuchetarioMk3.getEnergyConsumptionRocketRedirection() && missDistance > 3.0 + 0.6 * rocketPos[rocketIdx].distanceTo(extrapolatedTargetPos)) {
                            Vector rocketSpeedVector = rocketPos[rocketIdx].sub(this.oldRocketPos[rocketIdx]).mult(RuchetarioMk3.getFramesPerSecond());
                            Vector enemyVelo = extrapolatedHittingPos.sub(extrapolatedTargetPos);
                            double enemyVeloScalar = enemyVelo.getLength();
                            double parallelityOfMovement = rocketSpeedVector.projection(enemyVelo.getAngle()) / rocketSpeedVector.getLength();
                            if (Double.isNaN(parallelityOfMovement)) {
                                parallelityOfMovement = 1.0;
                            }
                            Vector veloMod = rocketSpeedVector.mult(rocketPos[rocketIdx].distanceTo(extrapolatedTargetPos) / rocketSpeed * (enemyVeloScalar / rocketSpeed) * (1.0 - parallelityOfMovement) * ((this.getTime() - (double)this.rocketStartTime) / 8.0));
                            Vector rocketTargetPos = extrapolatedHittingPos.sub(veloMod);
                            this.rocketDir = rocketTargetPos.sub(rocketPos[rocketIdx]).getAngle();
                            this.setRocketHeading(rocketIdx, this.rocketDir);
                            this.addDebugLine(extrapolatedTargetPos, extrapolatedHittingPos);
                            this.addDebugLine(extrapolatedHittingPos, rocketTargetPos);
                            this.addDebugArrow(rocketPos[rocketIdx], rocketTargetPos);
                        }
                        if (this.getEnergy() >= RuchetarioMk3.getEnergyConsumptionRocketRedirection() + RuchetarioMk3.getEnergyConsumptionRocket()) {
                            Vector extrapolatedProjHittingPos = LinearPredictor.predict(this.scan1st, this.scan2nd, this.getTime() + this.getPosition().distanceTo(extrapolatedTargetPos) / RuchetarioMk3.getMaxVelocityRocket());
                            this.setLaunchRocket(extrapolatedProjHittingPos.sub(this.getPosition()).getAngle());
                        }
                    }
                    this.oldRocketPos[rocketIdx] = rocketPos[rocketIdx];
                    ++rocketIdx;
                }
            } else {
                this.addDebugCrosshair(this.scan1st.estimatedTargetPosition());
                if (rocketPos.length == 0) {
                    this.rocketDir = this.scan1st.estimatedTargetPosition().sub(this.getPosition()).getAngle();
                    this.setLaunchRocket(this.rocketDir);
                } else if (this.rocketDir == null) {
                    this.rocketDir = this.scan1st.estimatedTargetPosition().sub(this.getPosition()).getAngle();
                }
            }
        }
        if (this.getEnergy() > 3.0 * RuchetarioMk3.getEnergyConsumptionRocket()) {
            this.setLaunchRocket(this.getOrientation());
        }
    }

    private void drive() {
        if (this.scan1st != null) {
            Vector target = this.scan2nd != null ? LinearPredictor.predict(this.scan1st, this.scan2nd, this.getTime()) : this.scan1st.estimatedTargetPosition();
            Vector safetyArea = target.add(this.getPosition().sub(target).getNormal().mult(RuchetarioMk3.getMaxArenaDiameter() * DRIVE_DISTANCE_FACTOR));
            Vector safetyTarget = safetyArea.add(new Vector(DRIVE_ALTERATION_AMPLITUDE.getX() * Math.sin(this.getTime() * (Math.PI * 2 / DRIVE_ALTERATION_PERIOD)), DRIVE_ALTERATION_AMPLITUDE.getY() * Math.cos(this.getTime() * (Math.PI * 2 / DRIVE_ALTERATION_PERIOD))).rotate(target.sub(this.getPosition()).getAngle()));
            this.setAutopilot(safetyTarget.sub(this.getPosition()).getAngle(), 1.0);
        } else {
            this.setAutopilot(this.getOrientation().add(new Angle(10.0, "d")), 1.0);
        }
    }

    @Override
    protected void actions() {
        this.collect();
        this.scan();
        this.shoot();
        this.drive();
    }

    @Override
    protected void init() {
        this.setBodyColor(Color.RED);
        this.setTurretColor(Color.RED);
        this.setNameColor(Color.RED);
        this.scanState = ScanState.DUMB;
        this.scanAperture = RuchetarioMk3.getMaxScanAperture();
        this.scanHemisphere = 0;
        this.scan1st = null;
        this.scan2nd = null;
    }

    private static enum ScanState {
        DUMB,
        TARGETTING;

    }
}

