/*
 * Decompiled with CFR 0.152.
 */
import java.util.LinkedList;
import java.util.Random;
import jrobots.simulation.simulationObjects.JRobot2015;
import jrobots.utils.Angle;
import jrobots.utils.LinearPredictor;
import jrobots.utils.SonarTrace;
import jrobots.utils.Vector;

public class SonarShooterBot
extends JRobot2015 {
    private static final long serialVersionUID = 1L;
    private Random random = new Random();
    private LinkedList<SonarTrace> traces = new LinkedList();
    State state = State.TRACE1;
    private static final float EXTRAPOLATION = 1.0f;

    @Override
    protected void actions() {
        SonarTrace trace = this.getLastSonarTrace();
        if (trace != null && trace.timestamp == this.getTime()) {
            this.traces.addFirst(trace);
            this.addDebugCrosshair(this.traces.get((int)0).location);
        }
        if (this.traces.size() > 2) {
            this.traces.removeLast();
            this.addDebugLine(this.traces.get((int)0).location, this.traces.get((int)1).location);
        }
        if (this.state == State.SHOOT && this.getEnergy() > SonarShooterBot.getEnergyConsumptionGrenade()) {
            Vector targetVector = this.traces.getFirst().location.sub(this.getPosition());
            Vector targetPosition = LinearPredictor.predict(this.traces.get(1), this.traces.get(0), this.getTime() + targetVector.getLength() / SonarShooterBot.getGrenadeSpeed() + 1.0);
            targetVector = targetPosition.sub(this.getPosition());
            this.setLaunchProjectileCommand(targetVector.getAngle(), targetVector.getLength());
            this.addDebugArrow(this.traces.get((int)0).location, targetPosition);
            this.state = State.TRACE1;
        }
        if (this.state == State.TRACE1 && this.getEnergy() > SonarShooterBot.getEnergyConsumptionSonarForMeterStdDev()) {
            this.setSonarEnergy(this.getEnergy());
            this.state = State.values()[this.state.ordinal() + 1];
        }
        if (this.state == State.TRACE2 && this.getEnergy() > 0.5 * SonarShooterBot.getEnergyConsumptionSonarForMeterStdDev() + SonarShooterBot.getEnergyConsumptionGrenade()) {
            this.setSonarEnergy(SonarShooterBot.getEnergyConsumptionSonarForMeterStdDev());
            this.state = State.values()[this.state.ordinal() + 1];
        }
        if (this.random.nextFloat() < 0.2f / (float)SonarShooterBot.getFramesPerSecond()) {
            this.setAutopilot(new Angle((double)(this.random.nextFloat() * 2.0f) * Math.PI, "r"), 1.0);
        }
    }

    static enum State {
        TRACE1,
        TRACE2,
        SHOOT;

    }
}

