/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import jrobots.simulation.simulationObjects.JRobot2007;
import jrobots.utils.Angle;

public class TurnaboutBore
extends JRobot2007 {
    private Angle scanAperture;
    private Angle scanDirection;
    private Angle latestSuccessfulScan;
    private Angle latestSuccessfulScanOrienation;
    private int scanState;
    private int scan_ROUNDABOUT_COUNT;
    private static final Angle rotateOffset = new Angle(40.0, "d");

    private void collect() {
        if (this.isScanFromNow() && this.getLastScanResult() != 0.0) {
            this.latestSuccessfulScan = this.scanDirection;
            this.latestSuccessfulScanOrienation = this.getOrientation();
        }
    }

    private void scan() {
        if (this.isScanFromNow()) {
            ++this.scanState;
            this.scanState %= this.scan_ROUNDABOUT_COUNT;
            this.scanAperture = TurnaboutBore.getMaxScanAperture();
            this.scanDirection = new Angle(360.0, "Degrees").mult((double)this.scanState / (double)this.scan_ROUNDABOUT_COUNT);
            this.setScanAperture(this.scanAperture);
            this.setScanDirection(this.scanDirection);
        } else {
            this.setScanAperture(this.scanAperture);
            this.setScanDirection(this.scanDirection);
        }
    }

    private void shoot() {
        this.setLaunchProjectileCommand(this.latestSuccessfulScan.add(this.getOrientation().sub(this.latestSuccessfulScanOrienation)));
    }

    private void drive() {
        this.setAutopilot(this.latestSuccessfulScan.add(rotateOffset), 1.0);
    }

    @Override
    protected void actions() {
        this.calibrate();
        this.collect();
        this.scan();
        this.shoot();
        this.drive();
    }

    @Override
    protected void init() {
        this.setNameColor(new Color(0.0f, 0.0f, 0.0f));
        this.setAutopilot(this.getOrientation(), 1.0);
        this.scanAperture = TurnaboutBore.getMaxScanAperture();
        this.scanDirection = this.getOrientation();
        this.setScanAperture(this.scanAperture);
        this.setScanDirection(this.scanDirection);
        this.latestSuccessfulScan = RIGHT;
        this.latestSuccessfulScanOrienation = RIGHT;
    }

    private void calibrate() {
        this.scan_ROUNDABOUT_COUNT = Math.max(4, (int)Math.ceil(360.0 / TurnaboutBore.getMaxScanAperture().getValueAsDegrees()));
    }
}

