/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import jrobots.simulation.simulationObjects.JRobot2009;
import jrobots.utils.Angle;
import jrobots.utils.Scan;
import jrobots.utils.Vector;

public class YellowBelly
extends JRobot2009 {
    private static final long serialVersionUID = -5364826721693293591L;
    private double SCANVALUE_MAX_AGE_SCAN;
    private double SCANVALUE_MAX_AGE_SHOOT;
    private double SCANVALUE_MAX_AGE_DRIVE;
    private int SCAN_ROUNDABOUT_COUNT;
    private int SCAN_DIRECTIONAL_COUNT;
    private int scanState;
    private Angle scanAperture;
    private Angle scanDirection;
    private Scan latestSuccessfulScan;
    private Vector minePos;

    private void collect() {
        if (this.getLastScan().distanceToTarget > 0.0) {
            this.latestSuccessfulScan = this.getLastScan();
        }
    }

    private void scan() {
        if (this.isScanFromNow()) {
            if (this.getTime() - this.latestSuccessfulScan.timeOfScan > this.SCANVALUE_MAX_AGE_SCAN) {
                this.scanState %= this.SCAN_ROUNDABOUT_COUNT;
                this.scanAperture = new Angle(360.0, "d").mult(1.0 / (double)this.SCAN_ROUNDABOUT_COUNT);
                this.scanDirection = this.scanAperture.mult(this.scanState).normalize();
                this.setScanAperture(this.scanAperture);
                this.setScanDirection(this.scanDirection);
                ++this.scanState;
            } else {
                this.scanState %= this.SCAN_DIRECTIONAL_COUNT;
                this.scanAperture = LEFT.mult(1.0 / (double)this.SCAN_DIRECTIONAL_COUNT);
                this.scanDirection = this.getOrientation().sub(DOWN).add(this.scanAperture.mult(this.scanState)).normalize();
                this.setScanAperture(this.scanAperture);
                this.setScanDirection(this.scanDirection);
                ++this.scanState;
            }
        } else {
            this.setScanAperture(this.scanAperture);
            this.setScanDirection(this.scanDirection);
        }
    }

    private void shoot() {
        if (this.getTime() - this.latestSuccessfulScan.timeOfScan <= this.SCANVALUE_MAX_AGE_SHOOT) {
            Angle shootDir = this.latestSuccessfulScan.scanDirection;
            Angle random = this.scanAperture.mult(Math.random() - 0.5);
            shootDir = shootDir.add(random);
            this.setLaunchProjectileCommand(shootDir);
        }
        if (this.getTime() >= this.getTimeOfDropperReloaded()) {
            this.setDropTankTrapCommand(true);
            this.minePos = this.getPosition();
            Vector[] lines = new Vector[]{this.getPosition(), this.minePos};
            this.setDebugLines(lines);
        }
    }

    private void drive() {
        if (this.getTime() - this.latestSuccessfulScan.timeOfScan > this.SCANVALUE_MAX_AGE_DRIVE) {
            this.setAutopilot(this.getOrientation(), 1.0);
        } else {
            this.setAutopilot(this.latestSuccessfulScan.scanDirection, -1.0);
        }
    }

    @Override
    protected void actions() {
        this.calibrate();
        this.collect();
        this.scan();
        this.shoot();
        this.drive();
    }

    private void calibrate() {
        this.SCAN_ROUNDABOUT_COUNT = Math.max(6, (int)Math.ceil(360.0 / YellowBelly.getMaxScanAperture().getValueAsDegrees()));
        this.SCAN_DIRECTIONAL_COUNT = (int)(1.0 + YellowBelly.getProjectileReloadTime() / YellowBelly.getScanInterval());
        this.SCANVALUE_MAX_AGE_SHOOT = 0.1 * YellowBelly.getProjectileReloadTime();
        this.SCANVALUE_MAX_AGE_SCAN = 1.5 * YellowBelly.getProjectileReloadTime();
        this.SCANVALUE_MAX_AGE_DRIVE = 2.8 * YellowBelly.getProjectileReloadTime();
    }

    @Override
    protected void init() {
        this.setNameColor(new Color(1.0f, 1.0f, 0.0f));
        this.setAutopilot(this.getOrientation(), 1.0);
        this.scanDirection = UP;
        this.scanAperture = YellowBelly.getMaxScanAperture();
        this.setScanAperture(this.scanAperture);
        this.setScanDirection(this.scanDirection);
        this.latestSuccessfulScan = new Scan(this.scanDirection, this.scanAperture, 0.0, this.getPosition(), -1.7976931348623157E308);
    }
}

