/*
 * Decompiled with CFR 0.152.
 */
package jrobots;

import java.io.File;
import java.lang.reflect.Field;

public class NativeLibLoader {
    public static void detectLibraryPath() {
        String workingDir = System.getProperty("user.dir");
        String libraryDir = String.valueOf(workingDir) + File.separator + "lib" + File.separator + NativeLibLoader.getOSString() + File.separator + NativeLibLoader.getArchString() + File.separator;
        if (new File(libraryDir).exists()) {
            try {
                NativeLibLoader.addDirToLibPaths(libraryDir);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            System.err.println("Error: Unexpected OS (" + NativeLibLoader.getOSString() + ") and/or architecture (" + NativeLibLoader.getArchString() + ")");
            System.err.println("Modify the platform recognition code in NativeLibLoader.java and/or add the missing JOGL binaries to the lib folder to get past this point!");
            System.exit(1);
        }
    }

    private static String getOSString() {
        String os = System.getProperty("os.name").toLowerCase();
        if (os.indexOf("win") >= 0) {
            return "windows";
        }
        if (os.indexOf("mac") >= 0) {
            return "macos";
        }
        if (os.indexOf("nix") >= 0 || os.indexOf("nux") >= 0) {
            return "linux";
        }
        throw new RuntimeException("Unexpected Operating System: " + os + ". You have to modify the platform recognition code " + "in NativeLibLoader.java to get past this point!");
    }

    private static String getArchString() {
        String arch = System.getProperty("os.arch");
        if (arch.equals("x86") || arch.equals("i386")) {
            return "x86";
        }
        if (arch.equals("amd64") || arch.equals("x86_64")) {
            return "amd64";
        }
        throw new RuntimeException("Unexpected architecture: " + arch + ". You have to modify the platform recognition code " + "in NativeLibLoader.java to get past this point!");
    }

    private static void addDirToLibPaths(String s) throws Exception {
        Field field = ClassLoader.class.getDeclaredField("usr_paths");
        field.setAccessible(true);
        String[] paths = (String[])field.get(null);
        int i = 0;
        while (i < paths.length) {
            if (s.equals(paths[i])) {
                return;
            }
            ++i;
        }
        String[] tmp = new String[paths.length + 1];
        System.arraycopy(paths, 0, tmp, 0, paths.length);
        tmp[paths.length] = s;
        field.set(null, tmp);
    }
}

