/*
 * Decompiled with CFR 0.152.
 */
package jrobots;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import java.util.TreeMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import jrobots.pilotlist.LoadedBotClass;
import jrobots.pilotlist.PilotManager;
import jrobots.simulation.SimulationController;
import jrobots.simulation.SimulationRun;
import jrobots.simulation.SimulationState;
import jrobots.simulation.simulationObjects.Panzer;

public abstract class Tournament {
    static NumberFormat numberFormatter = NumberFormat.getInstance(Locale.US);
    private static BufferedWriter log;

    /*
     * Unable to fully structure code
     */
    static void tournamentMode(String[] tournamentArgs) {
        block18: {
            try {
                try {
                    if (tournamentArgs.length < 5) {
                        System.err.println("Tournament mode expects parameters '-tournament <botPath> <rounds> <roundsFinal> <maxTime> [<saveReplays>] [<classRestriction>]'");
                        return;
                    }
                    tournamentPath = tournamentArgs[1];
                    rounds = Integer.valueOf(tournamentArgs[2]);
                    roundsFinal = Integer.valueOf(tournamentArgs[3]);
                    maxTime = Double.valueOf(tournamentArgs[4]);
                    saveReplays = tournamentArgs.length < 6 ? false : Boolean.parseBoolean(tournamentArgs[5]);
                    addCheaters = false;
                    restrictionClass = null;
                    if (tournamentArgs.length > 6) {
                        restrictionClass = PilotManager.checkClassRestriction(tournamentArgs[6]);
                    }
                    Tournament.createLog();
                    Tournament.log("JRobots tournament mode.");
                    Tournament.log("Base dir : " + System.getProperty("user.dir"));
                    Tournament.log("Tournament path '" + tournamentPath + "'");
                    Tournament.log("Number of instances for each encounter: " + rounds);
                    Tournament.log("Number of instances for each finals encounter: " + roundsFinal);
                    Tournament.log("Maximum time for each encounter instance: " + maxTime + " seconds");
                    Tournament.log(saveReplays != false ? "Replays will be recorded." : "No replays will be recorded.");
                    Tournament.log(addCheaters != false ? "Cheaters are welcome." : "Cheaters are not allowed.");
                    Tournament.log(restrictionClass == null ? "All bot classes allowed" : "Bot class restriction: " + restrictionClass.getSimpleName());
                    Tournament.log("");
                    preFolders = new File(tournamentPath).listFiles(new FileFilter(){

                        @Override
                        public boolean accept(File pathname) {
                            return pathname.isDirectory();
                        }
                    });
                    Tournament.log("Number of tournament folders: " + preFolders.length);
                    currentPath = new String[1];
                    finalists = new TreeMap<String, LoadedBotClass>();
                    folderNumber = 0;
                    while (folderNumber < preFolders.length) {
                        block17: {
                            try {
                                numberOfBotClasses = 0;
                                currentPath[0] = preFolders[folderNumber].getAbsolutePath();
                                PilotManager.pilots.clear();
                                Tournament.log("\nTournament preliminary: folder '" + preFolders[folderNumber].getName() + "' - " + (numberOfBotClasses += PilotManager.addBotsFromDirectory(currentPath, addCheaters, restrictionClass)) + " Bots participating");
                                finalist = Tournament.performTournament(rounds, maxTime, saveReplays != false ? preFolders[folderNumber].getName() : "");
                                if (finalist == null) break block17;
                                finalist = finalists.put(finalist.pilotClass.getName(), finalist);
                                reinsertionCursor = 0;
                                while (finalist != null) {
                                    ++reinsertionCursor;
                                    elusion = finalist.pilotClass.getName();
                                    i = 0;
                                    while (i < reinsertionCursor) {
                                        elusion = String.valueOf(elusion) + "'";
                                        ++i;
                                    }
                                    System.err.println("Bot class name clash: '" + finalist.pilotClass.getSimpleName() + "' was overwritten! Reinserting as " + elusion);
                                    finalist = finalists.put(String.valueOf(finalist.pilotClass.getSimpleName()) + "'", finalist);
                                }
                                Tournament.log("Preliminary number " + (folderNumber + 1) + " completed.\nOverall progress: " + Math.round((double)(folderNumber + 1) / (double)preFolders.length * 100.0) + "% of preliminaries");
                                break block17;
                            }
                            catch (Exception e) {
                                System.err.println("Tournament preliminary number " + (folderNumber + 1) + " '/" + preFolders[folderNumber].getName() + "' is aborted. Reason follows:");
                                e.printStackTrace();
                                cause = e.getCause();
                                ** while (cause != null)
                            }
lbl-1000:
                            // 1 sources

                            {
                                cause.printStackTrace();
                                cause = cause.getCause();
                                continue;
                            }
                        }
                        ++folderNumber;
                    }
                    PilotManager.pilots.clear();
                    numberOfBotClasses = finalists.size();
                    PilotManager.pilots.putAll(finalists);
                    currentPath[0] = tournamentPath;
                    Tournament.log("\nPERFORMING TOURNAMENT\nNumber of Bots in tournament: " + (numberOfBotClasses += PilotManager.addBotsFromDirectory(currentPath, addCheaters, restrictionClass)));
                    winner = Tournament.performTournament(roundsFinal, maxTime, saveReplays != false ? "FINALS " : "");
                    if (winner != null) {
                        Tournament.log("\nOVERALL WINNER IS " + winner.pilotClass.getSimpleName());
                    } else {
                        Tournament.log("\nNO OVERALL WINNER");
                    }
                    break block18;
                }
                finally {
                    Tournament.flushLog();
                }
            }
            catch (Exception e) {
                System.err.println("TOURNAMENT ABORTED. Reason follows:");
                e.printStackTrace();
                cause = e.getCause();
                ** while (cause != null)
            }
lbl-1000:
            // 1 sources

            {
                cause.printStackTrace();
                cause = cause.getCause();
                continue;
            }
        }
    }

    private static LoadedBotClass performTournament(int rounds, double timeLimit, String replayFilePrefix) throws IOException {
        try {
            int[] points = new int[PilotManager.pilots.size()];
            if (points.length == 0) {
                return null;
            }
            int numberOfEncounters = points.length * (points.length + 1) / 2;
            int doneEncounters = 0;
            int doneInstances = 0;
            LoadedBotClass[] bots = new LoadedBotClass[PilotManager.pilots.size()];
            Iterator<LoadedBotClass> botsIt = PilotManager.pilots.values().iterator();
            int i = 0;
            while (i < bots.length) {
                bots[i] = botsIt.next();
                ++i;
            }
            Tournament.log("Performing tournament: " + numberOfEncounters + " encounters, " + numberOfEncounters * rounds + " instances");
            long tournamentStartTime = System.nanoTime();
            int bot1Number = 0;
            while (bot1Number < bots.length) {
                LoadedBotClass bot1 = bots[bot1Number];
                int bot2Number = bot1Number + 1;
                while (bot2Number < bots.length) {
                    LoadedBotClass bot2 = bots[bot2Number];
                    Tournament.log("Encounter " + (doneEncounters + 1) + " of " + numberOfEncounters + ": " + bot1.pilotClass.getName() + " vs " + bot2.pilotClass.getName());
                    int winsBot1 = 0;
                    int winsBot2 = 0;
                    int instanceNumber = 0;
                    while (instanceNumber < rounds || winsBot1 == winsBot2) {
                        System.out.print("  Round " + (instanceNumber + 1) + ": ");
                        boolean bot1Win = Tournament.performEncounterInstance(bot1, bot2, timeLimit);
                        if (!replayFilePrefix.isEmpty()) {
                            Tournament.log("  Saving replay.");
                            Tournament.saveReplay(String.valueOf(replayFilePrefix) + " E" + (doneEncounters + 1) + " R" + (instanceNumber + 1));
                            Tournament.log("  Replay saved.");
                        }
                        if (bot1Win) {
                            ++winsBot1;
                        } else {
                            ++winsBot2;
                        }
                        ++instanceNumber;
                    }
                    int n = bot1Number;
                    points[n] = points[n] + winsBot1;
                    int n2 = bot2Number;
                    points[n2] = points[n2] + winsBot2;
                    Tournament.log("Encounter result " + winsBot1 + ":" + winsBot2 + "  -  " + (winsBot1 >= winsBot2 ? "winner" : "loser") + ": " + bots[bot1Number].pilotClass.getSimpleName() + "  -  " + (winsBot2 >= winsBot1 ? "winner" : "loser") + ": " + bots[bot2Number].pilotClass.getSimpleName());
                    ++doneEncounters;
                    doneInstances += instanceNumber;
                    Tournament.flushLog();
                    ++bot2Number;
                }
                ++bot1Number;
            }
            int i2 = 0;
            while (i2 < points.length) {
                int j = 0;
                while (j < points.length - 1) {
                    if (points[j] < points[j + 1]) {
                        int tmpPoints = points[j];
                        points[j] = points[j + 1];
                        points[j + 1] = tmpPoints;
                        LoadedBotClass tmpBot = bots[j];
                        bots[j] = bots[j + 1];
                        bots[j + 1] = tmpBot;
                    }
                    ++j;
                }
                ++i2;
            }
            int bestBotNumber = -1;
            int bestBotScore = -1;
            Tournament.log("\nTournament results:");
            Tournament.log("Place\tpoints\tname");
            int i3 = 0;
            while (i3 < bots.length) {
                if (points[i3] > bestBotScore) {
                    bestBotNumber = i3;
                    bestBotScore = points[i3];
                }
                Tournament.log(String.valueOf(i3 + 1) + "\t" + points[i3] + "\t" + bots[i3].pilotClass.getSimpleName());
                ++i3;
            }
            Tournament.log(HtmlOutput.htmlOutput(bots, points, doneEncounters, doneInstances));
            double tournamentDuration = System.nanoTime() - tournamentStartTime;
            Tournament.log("Tournament rendering took " + tournamentDuration / 1.0E9 + " seconds.");
            Tournament.log("Encounters done: " + doneEncounters);
            Tournament.log("Instances done: " + doneInstances);
            if (bestBotNumber >= 0) {
                Tournament.log("WINNER IS " + bots[bestBotNumber].pilotClass.getSimpleName());
                LoadedBotClass loadedBotClass = bots[bestBotNumber];
                return loadedBotClass;
            }
            return null;
        }
        finally {
            Tournament.flushLog();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean performEncounterInstance(LoadedBotClass bot1, LoadedBotClass bot2, double timeLimit) throws IOException {
        try {
            try {
                SimulationRun simRun = SimulationRun.simulationRun;
                simRun.cropAfter(0);
                List<Panzer> panzers = simRun.getSimulationState(0).getPanzers();
                panzers.clear();
                PilotManager.updateVisibleInstances(panzers);
                SimulationRun simulationRun = SimulationRun.simulationRun;
                synchronized (simulationRun) {
                    SimulationState state = simRun.getSimulationState(0);
                    state.createNewPanzer(bot1.pilotClass);
                    state.createNewPanzer(bot2.pilotClass);
                    PilotManager.updateVisibleInstances(state.getPanzers());
                }
                SimulationController.setRunning(true, timeLimit);
                SimulationController.controller.join();
            }
            catch (Exception e) {
                System.err.println("Exception during running encounter instance - concluding instance.Message was: " + e.getMessage());
                e.printStackTrace();
                SimulationController.setRunning(false, timeLimit);
            }
            Panzer panzer1 = null;
            Panzer panzer2 = null;
            Class<SimulationController> clazz = SimulationController.class;
            synchronized (SimulationController.class) {
                double timeElapsed;
                SimulationRun simRun = SimulationRun.simulationRun;
                SimulationState state = simRun.getSimulationState(simRun.getStateCount() - 1);
                if (state == null) {
                    timeElapsed = 0.0;
                    Tournament.log("Error - no simulation was done.");
                } else {
                    timeElapsed = state.timestamp;
                    for (Panzer panzer : state.getPanzers()) {
                        if (panzer.getPilot().getClass().getSimpleName().equals(bot1.pilotClass.getSimpleName())) {
                            panzer1 = panzer;
                        }
                        if (!panzer.getPilot().getClass().getSimpleName().equals(bot2.pilotClass.getSimpleName())) continue;
                        panzer2 = panzer;
                    }
                }
                // ** MonitorExit[var8_9] (shouldn't be in output)
                double bot1intg = panzer1 == null ? -1.0 : panzer1.getHealth();
                int bot1bytes = bot1.visibleInstance == null ? Integer.MAX_VALUE : bot1.visibleInstance.memoryConsumption;
                double bot2intg = panzer2 == null ? -1.0 : panzer2.getHealth();
                int bot2bytes = bot2.visibleInstance == null ? Integer.MAX_VALUE : bot2.visibleInstance.memoryConsumption;
                Tournament.log(String.valueOf(numberFormatter.format(timeElapsed)) + "s  " + bot1.pilotClass.getName() + ":" + (bot1intg < 0.0 ? "DESTROYED" : Long.valueOf(Math.round(bot1intg * 100.0))) + "%:" + (bot1bytes == Integer.MAX_VALUE ? "DEAD" : Integer.valueOf(bot1bytes)) + "  " + bot2.pilotClass.getName() + ":" + (bot2intg < 0.0 ? "DESTROYED" : Long.valueOf(Math.round(bot2intg * 100.0))) + "%:" + (bot2bytes == Integer.MAX_VALUE ? "DEAD" : Integer.valueOf(bot2bytes)));
                if (bot1intg < 0.0 && bot2intg < 0.0 || bot1intg == bot2intg) {
                    if (bot1bytes == bot2bytes) {
                        boolean bl = new Random().nextBoolean();
                        return bl;
                    }
                    boolean bl = bot1bytes < bot2bytes;
                    return bl;
                }
                boolean bl = bot1intg > bot2intg;
                return bl;
            }
        }
        finally {
            Tournament.flushLog();
        }
    }

    private static void log(String msg) throws IOException {
        log.append(msg);
        log.newLine();
        System.out.println(msg);
    }

    private static void flushLog() {
        try {
            log.flush();
        }
        catch (Exception e) {
            System.err.println("Error while flushing tournament log:");
            e.printStackTrace();
        }
    }

    private static void createLog() {
        try {
            BufferedWriter logOutput;
            File logFile = new File("tournament.log");
            if (logFile.exists()) {
                logFile.delete();
            }
            logFile.createNewFile();
            FileWriter fileStream = new FileWriter(logFile);
            log = logOutput = new BufferedWriter(fileStream);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void saveReplay(String prefix) {
        try {
            String prefix1 = " " + prefix.replaceAll("/", "");
            SimulationRun simulationRun = SimulationRun.simulationRun;
            synchronized (simulationRun) {
                Calendar cal = Calendar.getInstance();
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH.mm.ss");
                String fileName = String.valueOf(sdf.format(cal.getTime())) + prefix1;
                for (Panzer panzer : SimulationRun.simulationRun.getSimulationState(0).getPanzers()) {
                    fileName = String.valueOf(fileName) + " " + panzer.getPilot().getClass().getSimpleName();
                }
                FileOutputStream fos = new FileOutputStream(String.valueOf(fileName) + ".zip");
                ZipOutputStream zos = new ZipOutputStream(fos);
                zos.setLevel(9);
                ZipEntry ze = new ZipEntry(fileName);
                zos.putNextEntry(ze);
                ObjectOutputStream oos = new ObjectOutputStream(zos);
                SimulationRun zombieRun = SimulationRun.simulationRun.anonymizedClone();
                oos.writeObject(zombieRun);
                oos.flush();
                zos.flush();
                zos.closeEntry();
                zos.close();
                fos.close();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private static class HtmlOutput {
        static final String html1 = "<table style=\"width: 481px; height: 317px;\" border=\"0\" rules=\"none\" cellspacing=\"1\">\n<tbody>";
        static final String html_row1 = "<tr>\n<td>";
        static final String html_row1Cup1 = "<img src=\"http://jrobots.de/wp-content/uploads/2013/10/cup";
        static final String html_row1Cup3 = ".png\" border=\"0\" alt=\"";
        static final String html_row1Cup5 = "\" width=\"32\" height=\"32\" />";
        static final String html_row2 = "</td>\n<td><span style=\"font-size: ";
        static final String html_row4 = ";\"><strong>";
        static final String html_row6 = ".</strong></span></td>\n<td>\n<pre><span style=\"font-size: ";
        static final String html_row8 = "\"><strong>";
        static final String html_row10 = "</strong></span></pre>\n</td>\n<td>\n<pre><span style=\"font-size: ";
        static final String html_row12 = ";\"><strong>";
        static final String html_row14 = "</strong></span></pre>\n</td>\n</tr>\n";
        static final String html3 = "</tbody>\n</table>\n<p><span style=\"font-size: x-small;\">";
        static final String html5 = " encounters, ";
        static final String html7 = " <span style=\"font-size: x-small;\">battle instances</span></span>. <span style=\"font-size: x-small;\">More detailed information is available on request.</span><br /></p><p>Online ranking will be updated with (yet) undetermined frequency.</p>\n<p>Ranked online are all bots uploaded by users.</p>";

        private HtmlOutput() {
        }

        static final String html_row1Cup2(int idx) {
            switch (idx) {
                case 0: {
                    return "gold";
                }
                case 1: {
                    return "silver";
                }
                case 2: {
                    return "bronze";
                }
            }
            return "";
        }

        static final String html_row1Cup4(int idx) {
            return HtmlOutput.html_row1Cup2(idx);
        }

        static final String html_row3(int idx) {
            if (idx <= 0) {
                return "xx-large";
            }
            if (idx <= 2) {
                return "x-large";
            }
            if (idx <= 5) {
                return "large";
            }
            if (idx <= 9) {
                return "medium";
            }
            return "small";
        }

        static final String html_row5(int idx) {
            return Integer.toString(idx + 1);
        }

        static final String html_row7(int idx) {
            return HtmlOutput.html_row3(idx);
        }

        static final String html_row9(String name) {
            return name;
        }

        static final String html_row11(int idx) {
            return HtmlOutput.html_row3(idx);
        }

        static final String html_row13(int pts) {
            return Integer.toString(pts);
        }

        static final String html4(int noEncounters) {
            return Integer.toString(noEncounters);
        }

        static final String html6(int noInstances) {
            return Integer.toString(noInstances);
        }

        static String htmlOutput(LoadedBotClass[] names, int[] pts, int noEncounters, int noInstances) {
            StringBuilder str = new StringBuilder();
            str.append("\nhtml output:\n\n");
            str.append(html1);
            int idx = 0;
            while (idx < names.length) {
                str.append(html_row1);
                if (idx <= 2) {
                    str.append(html_row1Cup1);
                    str.append(HtmlOutput.html_row1Cup2(idx));
                    str.append(html_row1Cup3);
                    str.append(HtmlOutput.html_row1Cup4(idx));
                    str.append(html_row1Cup5);
                }
                str.append(html_row2);
                str.append(HtmlOutput.html_row3(idx));
                str.append(";\"><strong>");
                str.append(HtmlOutput.html_row5(idx));
                str.append(html_row6);
                str.append(HtmlOutput.html_row7(idx));
                str.append(html_row8);
                str.append(HtmlOutput.html_row9(names[idx].getBotNameForUI()));
                str.append(html_row10);
                str.append(HtmlOutput.html_row11(idx));
                str.append(";\"><strong>");
                str.append(HtmlOutput.html_row13(pts[idx]));
                str.append(html_row14);
                ++idx;
            }
            str.append(html3);
            str.append(HtmlOutput.html4(noEncounters));
            str.append(html5);
            str.append(HtmlOutput.html6(noInstances));
            str.append(html7);
            str.append('\n');
            return str.toString();
        }
    }
}

