/*
 * Decompiled with CFR 0.152.
 */
package jrobots.graphics;

import com.sun.opengl.util.BufferUtil;
import com.sun.opengl.util.j2d.TextRenderer;
import com.sun.opengl.util.texture.Texture;
import com.sun.opengl.util.texture.TextureIO;
import java.awt.Color;
import java.awt.Font;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.net.URL;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.Collection;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.TreeMap;
import javax.imageio.ImageIO;
import javax.media.opengl.GL;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLEventListener;
import javax.media.opengl.glu.GLU;
import jrobots.graphics.ExplosionManager;
import jrobots.graphics.GUI;
import jrobots.graphics.Shader;
import jrobots.graphics.SmokeManager;
import jrobots.simulation.SimulationRun;
import jrobots.simulation.SimulationState;
import jrobots.simulation.simulationObjects.Panzer;
import jrobots.simulation.simulationObjects.ScanFan;
import jrobots.simulation.simulationObjects.droppables.Droppable;
import jrobots.simulation.simulationObjects.droppables.TankTrap;
import jrobots.simulation.simulationObjects.launchables.Launchable;
import jrobots.utils.Angle;
import jrobots.utils.SonarTrace;

public class ArenaController
implements GLEventListener {
    private TextRenderer textRenderer;
    private BufferedImage imageTrack;
    private Texture textureTrack;
    private static final int TEXTURE_TRACK_CENTER_X = 68;
    private static double TEXTURE_TRACK_CENTER_Y = 64.0;
    private BufferedImage imagePanzer;
    private Texture texturePanzer;
    private static final int TEXTURE_PANZER_CENTER_X = 64;
    private static final int TEXTURE_PANZER_CENTER_Y = 84;
    private BufferedImage imageTurret;
    private Texture textureTurret;
    private BufferedImage imageMine;
    private Texture textureMine;
    private BufferedImage imageMineRed;
    private Texture textureMineRed;
    private BufferedImage imageTrap0;
    private Texture textureTrap0;
    private BufferedImage imageTrap;
    private Texture textureTrap;
    private static final int TEXTURE_TURRET_CENTER_X = 44;
    private static final int TEXTURE_TURRET_CENTER_Y = 44;
    private BufferedImage imageProjectile;
    private Texture textureProjectile;
    private BufferedImage imageBullet;
    private Texture textureBullet;
    private BufferedImage imageMissile;
    private Texture textureMissile;
    private BufferedImage imageGrenade;
    private Texture textureGrenade;
    private static final int TEXTURE_PROJECTILE_CENTER_X = 50;
    private static final int TEXTURE_PROJECTILE_CENTER_Y = 18;
    private BufferedImage imageBackground;
    private Texture textureBackground;
    private BufferedImage imageNoise;
    private Texture textureNoise;
    private Shader backgroundShader;
    private Font botNameFont;
    double pixelPerMeter = 1.0;
    double DEAD_TRANSPARENCY = 0.4;
    private static FloatBuffer buffer2DLines = BufferUtil.newFloatBuffer(4);
    private GLU glu;

    ArenaController(GLAutoDrawable glAutoDrawable) {
        glAutoDrawable.addGLEventListener(this);
    }

    @Override
    public void init(GLAutoDrawable drawable) {
        GL gl = drawable.getGL();
        this.glu = new GLU();
        gl.glDisable(2929);
        gl.glEnable(3042);
        gl.glBlendFunc(770, 771);
        gl.glEnable(2848);
        gl.glTexEnvf(8960, 8704, 7681.0f);
        URL url = null;
        try {
            this.backgroundShader = new Shader(gl, this.getClass().getResource("/shader/backgroundTiles.vert.glsl"), this.getClass().getResource("/shader/backgroundTiles.frag.glsl"));
            url = this.getClass().getResource("/fonts/President.ttf");
            this.botNameFont = Font.createFont(0, url.openStream());
            this.botNameFont = this.botNameFont.deriveFont(1, 25.0f);
            this.textRenderer = new TextRenderer(this.botNameFont, true, true);
            url = this.getClass().getResource("/images/panzer_tractor.png");
            this.imageTrack = ImageIO.read(url);
            this.textureTrack = TextureIO.newTexture(this.imageTrack, false);
            this.textureTrack.setTexParameteri(10242, 10497);
            this.textureTrack.setTexParameteri(10243, 10497);
            this.textureTrack.setTexParameteri(10241, 9728);
            this.textureTrack.setTexParameteri(10240, 9728);
            url = this.getClass().getResource("/images/panzer_body.png");
            this.imagePanzer = ImageIO.read(url);
            this.texturePanzer = TextureIO.newTexture(this.imagePanzer, false);
            this.texturePanzer.setTexParameteri(10241, 9728);
            this.texturePanzer.setTexParameteri(10240, 9728);
            url = this.getClass().getResource("/images/panzer_turret.png");
            this.imageTurret = ImageIO.read(url);
            this.textureTurret = TextureIO.newTexture(this.imageTurret, false);
            this.textureTurret.setTexParameteri(10241, 9728);
            this.textureTurret.setTexParameteri(10240, 9728);
            url = this.getClass().getResource("/images/mine.png");
            this.imageMine = ImageIO.read(url);
            this.textureMine = TextureIO.newTexture(this.imageMine, false);
            this.textureMine.setTexParameteri(10241, 9728);
            this.textureMine.setTexParameteri(10240, 9728);
            url = this.getClass().getResource("/images/minered.png");
            this.imageMineRed = ImageIO.read(url);
            this.textureMineRed = TextureIO.newTexture(this.imageMineRed, false);
            this.textureMineRed.setTexParameteri(10241, 9728);
            this.textureMineRed.setTexParameteri(10240, 9728);
            url = this.getClass().getResource("/images/trap0.png");
            this.imageTrap0 = ImageIO.read(url);
            this.textureTrap0 = TextureIO.newTexture(this.imageTrap0, false);
            this.textureTrap0.setTexParameteri(10241, 9728);
            this.textureTrap0.setTexParameteri(10240, 9728);
            url = this.getClass().getResource("/images/trap.png");
            this.imageTrap = ImageIO.read(url);
            this.textureTrap = TextureIO.newTexture(this.imageTrap, false);
            this.textureTrap.setTexParameteri(10241, 9728);
            this.textureTrap.setTexParameteri(10240, 9728);
            url = this.getClass().getResource("/images/projectile.png");
            this.imageProjectile = ImageIO.read(url);
            this.textureProjectile = TextureIO.newTexture(this.imageProjectile, false);
            this.textureProjectile.setTexParameteri(10241, 9728);
            this.textureProjectile.setTexParameteri(10240, 9728);
            url = this.getClass().getResource("/images/bullet.png");
            this.imageBullet = ImageIO.read(url);
            this.textureBullet = TextureIO.newTexture(this.imageBullet, false);
            this.textureBullet.setTexParameteri(10241, 9728);
            this.textureBullet.setTexParameteri(10240, 9728);
            url = this.getClass().getResource("/images/grenade.png");
            this.imageGrenade = ImageIO.read(url);
            this.textureGrenade = TextureIO.newTexture(this.imageGrenade, false);
            this.textureGrenade.setTexParameteri(10241, 9728);
            this.textureGrenade.setTexParameteri(10240, 9728);
            url = this.getClass().getResource("/images/missile.png");
            this.imageMissile = ImageIO.read(url);
            this.textureMissile = TextureIO.newTexture(this.imageMissile, false);
            this.textureMissile.setTexParameteri(10241, 9728);
            this.textureMissile.setTexParameteri(10240, 9728);
            url = this.getClass().getResource("/images/arena_background.png");
            this.imageBackground = ImageIO.read(url);
            this.textureBackground = TextureIO.newTexture(this.imageBackground, false);
            this.textureBackground.setTexParameteri(10242, 33071);
            this.textureBackground.setTexParameteri(10243, 33071);
            this.textureBackground.setTexParameteri(10241, 9728);
            this.textureBackground.setTexParameteri(10240, 9728);
            url = this.getClass().getResource("/images/noise.png");
            this.imageNoise = ImageIO.read(url);
            this.textureNoise = TextureIO.newTexture(this.imageNoise, false);
            this.textureNoise.setTexParameteri(10242, 10497);
            this.textureNoise.setTexParameteri(10243, 10497);
            this.textureNoise.setTexParameteri(10241, 9728);
            this.textureNoise.setTexParameteri(10240, 9728);
        }
        catch (Exception e) {
            System.err.println("URL was " + url);
            e.printStackTrace();
            System.exit(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void display(GLAutoDrawable drawable) {
        GL gl = drawable.getGL();
        gl.glMatrixMode(5888);
        gl.glLoadIdentity();
        SimulationRun simulationRun = SimulationRun.simulationRun;
        synchronized (simulationRun) {
            int currentSimulationStateIndex = GUI.gui.timelineSlider.getValue();
            SimulationState state = SimulationRun.simulationRun.getSimulationState(currentSimulationStateIndex);
            Rectangle2D.Double visibleArea = this.calculateVisibleArea(gl, drawable, state);
            this.setVisibleArea(gl, visibleArea);
            this.drawGround(gl, visibleArea);
            this.drawScanFans(gl, state);
            this.drawSonarTraces(gl, state);
            this.drawDroppables(gl, state);
            this.drawDeadTracks(gl, state);
            this.drawDeadPanzers(gl, state);
            this.drawDeadTurrets(gl, state);
            this.drawTracks(gl, state);
            this.drawPanzers(gl, state);
            this.drawTurrets(gl, state);
            ExplosionManager.drawClouds(gl, state.timestamp, state.getExplosionParticles());
            SmokeManager.drawClouds(gl, state.timestamp, state.getSmokeParticles());
            this.drawLaunchables(gl, state);
            this.drawDebugLines(gl, state);
            this.drawPanzerOverlays(drawable, gl, state);
            this.textRenderer.beginRendering(drawable.getWidth(), drawable.getHeight());
            this.textRenderer.setColor(1.0f, 0.2f, 0.2f, 0.8f);
            this.textRenderer.draw("" + currentSimulationStateIndex, 5, 5);
            this.textRenderer.endRendering();
            gl.glColor4f(1.0f, 0.0f, 0.0f, 1.0f);
        }
    }

    private void drawLaunchables(GL gl, SimulationState state) {
        List<Launchable> projectiles = state.getProjectiles();
        if (projectiles.size() == 0) {
            return;
        }
        gl.glTexEnvf(8960, 8704, 7681.0f);
        for (Launchable projectile : projectiles) {
            projectile.draw(gl, this);
        }
    }

    public void drawBullet(GL gl, Launchable proj) {
        this.textureBullet.enable();
        this.textureBullet.bind();
        gl.glPushMatrix();
        gl.glTranslated(proj.getPos().getX(), proj.getPos().getY(), 0.0);
        gl.glRotated(proj.getOrientation().getValueAsDegrees(), 0.0, 0.0, 1.0);
        gl.glScaled(6.0 / (double)this.imagePanzer.getHeight(), 6.0 / (double)this.imagePanzer.getHeight(), 1.0);
        gl.glTranslated(-25.0, -18.0, 0.0);
        gl.glBegin(7);
        gl.glTexCoord2d(0.0, 0.0);
        gl.glVertex2d(0.0, 0.0);
        gl.glTexCoord2d(1.0, 0.0);
        gl.glVertex2d(this.imageBullet.getWidth(), 0.0);
        gl.glTexCoord2d(1.0, 1.0);
        gl.glVertex2d(this.imageBullet.getWidth(), this.imageBullet.getHeight());
        gl.glTexCoord2d(0.0, 1.0);
        gl.glVertex2d(0.0, this.imageBullet.getHeight());
        gl.glEnd();
        gl.glPopMatrix();
    }

    public void drawProjectile(GL gl, Launchable proj) {
        this.textureProjectile.enable();
        this.textureProjectile.bind();
        gl.glPushMatrix();
        gl.glTranslated(proj.getPos().getX(), proj.getPos().getY(), 0.0);
        gl.glRotated(proj.getOrientation().getValueAsDegrees(), 0.0, 0.0, 1.0);
        gl.glScaled(6.0 / (double)this.imagePanzer.getHeight(), 6.0 / (double)this.imagePanzer.getHeight(), 1.0);
        gl.glTranslated(-50.0, -18.0, 0.0);
        gl.glBegin(7);
        gl.glTexCoord2d(0.0, 0.0);
        gl.glVertex2d(0.0, 0.0);
        gl.glTexCoord2d(1.0, 0.0);
        gl.glVertex2d((double)this.imageProjectile.getWidth() * 1.2, 0.0);
        gl.glTexCoord2d(1.0, 1.0);
        gl.glVertex2d((double)this.imageProjectile.getWidth() * 1.2, (double)this.imageProjectile.getHeight() * 1.2);
        gl.glTexCoord2d(0.0, 1.0);
        gl.glVertex2d(0.0, (double)this.imageProjectile.getHeight() * 1.2);
        gl.glEnd();
        gl.glPopMatrix();
    }

    public void drawMissile(GL gl, Launchable proj) {
        this.textureMissile.enable();
        this.textureMissile.bind();
        gl.glPushMatrix();
        gl.glTranslated(proj.getPos().getX(), proj.getPos().getY(), 0.0);
        gl.glRotated(proj.getOrientation().getValueAsDegrees(), 0.0, 0.0, 1.0);
        gl.glScaled(6.0 / (double)this.imagePanzer.getHeight(), 6.0 / (double)this.imagePanzer.getHeight(), 1.0);
        gl.glTranslated(-50.0, -18.0, 0.0);
        gl.glBegin(7);
        gl.glTexCoord2d(0.0, 0.0);
        gl.glVertex2d(0.0, 0.0);
        gl.glTexCoord2d(1.0, 0.0);
        gl.glVertex2d((double)this.imageProjectile.getWidth() * 1.4, 0.0);
        gl.glTexCoord2d(1.0, 1.0);
        gl.glVertex2d((double)this.imageProjectile.getWidth() * 1.4, (double)this.imageProjectile.getHeight() * 1.4);
        gl.glTexCoord2d(0.0, 1.0);
        gl.glVertex2d(0.0, (double)this.imageProjectile.getHeight() * 1.4);
        gl.glEnd();
        gl.glPopMatrix();
    }

    public void drawMiniMissile(GL gl, Launchable proj) {
        this.textureMissile.enable();
        this.textureMissile.bind();
        gl.glPushMatrix();
        gl.glTranslated(proj.getPos().getX(), proj.getPos().getY(), 0.0);
        gl.glRotated(proj.getOrientation().getValueAsDegrees(), 0.0, 0.0, 1.0);
        gl.glScaled(6.0 / (double)this.imagePanzer.getHeight(), 6.0 / (double)this.imagePanzer.getHeight(), 1.0);
        gl.glTranslated(-50.0, -18.0, 0.0);
        gl.glBegin(7);
        gl.glTexCoord2d(0.0, 0.0);
        gl.glVertex2d(0.0, 0.0);
        gl.glTexCoord2d(1.0, 0.0);
        gl.glVertex2d(this.imageProjectile.getWidth() * 1, 0.0);
        gl.glTexCoord2d(1.0, 1.0);
        gl.glVertex2d(this.imageProjectile.getWidth() * 1, this.imageProjectile.getHeight() * 1);
        gl.glTexCoord2d(0.0, 1.0);
        gl.glVertex2d(0.0, this.imageProjectile.getHeight() * 1);
        gl.glEnd();
        gl.glPopMatrix();
    }

    public void drawRocket(GL gl, Launchable proj) {
        this.textureMissile.enable();
        this.textureMissile.bind();
        gl.glPushMatrix();
        gl.glTranslated(proj.getPos().getX(), proj.getPos().getY(), 0.0);
        gl.glRotated(proj.getOrientation().getValueAsDegrees(), 0.0, 0.0, 1.0);
        gl.glScaled(6.0 / (double)this.imagePanzer.getHeight(), 6.0 / (double)this.imagePanzer.getHeight(), 1.0);
        gl.glTranslated(-50.0, -18.0, 0.0);
        gl.glBegin(7);
        gl.glTexCoord2d(0.0, 0.0);
        gl.glVertex2d(0.0, 0.0);
        gl.glTexCoord2d(1.0, 0.0);
        gl.glVertex2d((double)this.imageProjectile.getWidth() * 1.4, 0.0);
        gl.glTexCoord2d(1.0, 1.0);
        gl.glVertex2d((double)this.imageProjectile.getWidth() * 1.4, (double)this.imageProjectile.getHeight() * 1.4);
        gl.glTexCoord2d(0.0, 1.0);
        gl.glVertex2d(0.0, (double)this.imageProjectile.getHeight() * 1.4);
        gl.glEnd();
        gl.glPopMatrix();
    }

    public void drawGrenade(GL gl, Launchable proj) {
        this.textureGrenade.enable();
        this.textureGrenade.bind();
        gl.glPushMatrix();
        gl.glTranslated(proj.getPos().getX(), proj.getPos().getY(), 0.0);
        gl.glRotated(proj.getOrientation().getValueAsDegrees(), 0.0, 0.0, 1.0);
        gl.glScaled(6.0 / (double)this.imagePanzer.getHeight(), 6.0 / (double)this.imagePanzer.getHeight(), 1.0);
        gl.glTranslated(-25.0, -18.0, 0.0);
        gl.glBegin(7);
        gl.glTexCoord2d(0.0, 0.0);
        gl.glVertex2d(0.0, 0.0);
        gl.glTexCoord2d(1.0, 0.0);
        gl.glVertex2d(this.imageGrenade.getWidth(), 0.0);
        gl.glTexCoord2d(1.0, 1.0);
        gl.glVertex2d(this.imageGrenade.getWidth(), this.imageGrenade.getHeight());
        gl.glTexCoord2d(0.0, 1.0);
        gl.glVertex2d(0.0, this.imageGrenade.getHeight());
        gl.glEnd();
        gl.glPopMatrix();
    }

    private void drawScanFans(GL gl, SimulationState state) {
        gl.glDisable(3553);
        for (ScanFan scanFan : state.getScanFans().values()) {
            double ratio = state.timestamp - scanFan.timeOfCreation;
            this.drawScanFan(gl, scanFan, ratio /= 0.5);
        }
        gl.glColor4d(0.0, 0.0, 0.0, 1.0);
    }

    private void drawSonarTraces(GL gl, SimulationState state) {
        gl.glDisable(3553);
        for (SonarTrace sonarTrace : state.getSonarTraces().values()) {
            double ratio = state.timestamp - sonarTrace.timestamp;
            this.drawSonarTrace(gl, sonarTrace, ratio /= 1.5);
        }
        gl.glColor4d(0.0, 0.0, 0.0, 1.0);
    }

    private void drawSonarTrace(GL gl, SonarTrace sonarTrace, double ratio) {
        ratio = Math.min(1.0, 1.5 - ratio * 1.5);
        gl.glPushMatrix();
        gl.glTranslated(sonarTrace.location.getX(), sonarTrace.location.getY(), 0.0);
        double radius = sonarTrace.standardDeviation * 2.0;
        gl.glScaled(radius * (ratio *= Math.exp(-sonarTrace.standardDeviation / 30.0)), radius * ratio, 1.0);
        gl.glBegin(6);
        gl.glColor4d(1.0, 0.0, 0.0, ratio);
        gl.glVertex2d(0.0, 0.0);
        gl.glColor4d(0.5, 0.0, 0.0, 0.0);
        double angle = 0.0;
        while (angle <= 360.0) {
            gl.glVertex2d(Math.cos(angle / 180.0 * Math.PI), Math.sin(angle / 180.0 * Math.PI));
            angle += 10.0;
        }
        gl.glEnd();
        gl.glPopMatrix();
    }

    private void drawPanzerOverlays(GLAutoDrawable drawable, GL gl, SimulationState state) {
        gl.glTexEnvf(8960, 8704, 7681.0f);
        gl.glColor4f(0.0f, 0.0f, 0.0f, 1.0f);
        DoubleBuffer modelviewMatrix = DoubleBuffer.allocate(16);
        gl.glGetDoublev(2982, modelviewMatrix);
        DoubleBuffer projectionMatrix = DoubleBuffer.allocate(16);
        gl.glGetDoublev(2983, projectionMatrix);
        IntBuffer viewport = IntBuffer.allocate(4);
        gl.glGetIntegerv(2978, viewport);
        DoubleBuffer winPos = DoubleBuffer.allocate(3);
        this.textRenderer.beginRendering(drawable.getWidth(), drawable.getHeight());
        for (Panzer panzer : state.getPanzers()) {
            this.glu.gluProject(panzer.getPos().getX(), panzer.getPos().getY(), 0.0, modelviewMatrix, projectionMatrix, viewport, winPos);
            String name = panzer.getPilot().getName();
            Rectangle2D boundsName = this.textRenderer.getBounds(name);
            String stats = "(H:" + (double)Math.round(panzer.getHealth() * 1000.0) / 10.0 + "%," + " E:" + (double)Math.round(panzer.getEnergy() * 100.0) / 100.0 + ")";
            Rectangle2D boundsStats = this.textRenderer.getBounds(stats);
            double winPosX = winPos.get();
            double winPosY = winPos.get();
            winPos.clear();
            int nameX = (int)(winPosX - boundsName.getWidth() / 2.0);
            int nameY = (int)(winPosY + 30.0 + boundsStats.getHeight());
            int statsX = (int)(winPosX - boundsStats.getWidth() / 2.0);
            int statsY = (int)(winPosY + 30.0);
            this.textRenderer.setColor(Color.BLACK);
            this.textRenderer.draw(name, nameX + 1, nameY + 1);
            this.textRenderer.draw(name, nameX - 1, nameY + 1);
            this.textRenderer.draw(name, nameX + 1, nameY - 1);
            this.textRenderer.draw(name, nameX - 1, nameY - 1);
            this.textRenderer.draw(stats, statsX + 1, statsY + 1);
            this.textRenderer.draw(stats, statsX - 1, statsY + 1);
            this.textRenderer.draw(stats, statsX + 1, statsY - 1);
            this.textRenderer.draw(stats, statsX - 1, statsY - 1);
            this.textRenderer.setColor(panzer.getPilot().getNameColor());
            this.textRenderer.draw(name, nameX, nameY);
            this.textRenderer.draw(stats, statsX, statsY);
        }
        this.textRenderer.endRendering();
        gl.glColor4f(0.0f, 0.0f, 0.0f, 1.0f);
    }

    private void drawGround(GL gl, Rectangle2D.Double rect) {
        this.backgroundShader.bind();
        gl.glActiveTexture(33985);
        this.textureNoise.enable();
        this.textureNoise.bind();
        gl.glActiveTexture(33984);
        this.textureBackground.enable();
        this.textureBackground.bind();
        gl.glUniform1i(this.backgroundShader.glGetUniformLocation("tex_Color"), 0);
        gl.glUniform1i(this.backgroundShader.glGetUniformLocation("tex_Noise"), 1);
        gl.glPushMatrix();
        gl.glLoadIdentity();
        rect.x /= 5.0;
        rect.y /= 5.0;
        rect.width /= 5.0;
        rect.height /= 5.0;
        gl.glBegin(7);
        gl.glTexCoord2d(rect.x, rect.y);
        gl.glVertex2d(-1.0, 1.0);
        gl.glTexCoord2d(rect.x + rect.width, rect.y);
        gl.glVertex2d(1.0, 1.0);
        gl.glTexCoord2d(rect.x + rect.width, rect.y + rect.height);
        gl.glVertex2d(1.0, -1.0);
        gl.glTexCoord2d(rect.x, rect.y + rect.height);
        gl.glVertex2d(-1.0, -1.0);
        gl.glEnd();
        gl.glPopMatrix();
        this.backgroundShader.unbind();
    }

    private Rectangle2D.Double calculateVisibleArea(GL gl, GLAutoDrawable drawable, SimulationState state) {
        double maxY;
        double minY;
        double maxX;
        double minX;
        if (state.getPanzers().size() == 0) {
            minX = 0.0;
            maxX = 0.0;
            minY = 0.0;
            maxY = 0.0;
        } else {
            maxX = minX = state.getPanzers().get(0).getPos().getX();
            maxY = minY = state.getPanzers().get(0).getPos().getY();
            for (Panzer panzer : state.getPanzers()) {
                minX = Math.min(panzer.getPos().getX(), minX);
                maxX = Math.max(panzer.getPos().getX(), maxX);
                minY = Math.min(panzer.getPos().getY(), minY);
                maxY = Math.max(panzer.getPos().getY(), maxY);
            }
            for (Panzer panzer : state.getWastedump().values()) {
                minX = Math.min(panzer.getPos().getX(), minX);
                maxX = Math.max(panzer.getPos().getX(), maxX);
                minY = Math.min(panzer.getPos().getY(), minY);
                maxY = Math.max(panzer.getPos().getY(), maxY);
            }
        }
        double viewportAR = (double)drawable.getWidth() / (double)drawable.getHeight();
        double cameraAR = ((maxX += 20.0) - (minX -= 20.0)) / ((maxY += 20.0) - (minY -= 20.0));
        if (cameraAR < viewportAR) {
            double deltaX = viewportAR * (maxY - minY) - (maxX - minX);
            minX -= deltaX / 2.0;
            maxX += deltaX / 2.0;
        } else {
            double deltaY = (maxX - minX) / viewportAR - (maxY - minY);
            minY -= deltaY / 2.0;
            maxY += deltaY / 2.0;
        }
        Rectangle2D.Double result = new Rectangle2D.Double();
        result.setFrameFromDiagonal(minX, minY, maxX, maxY);
        this.pixelPerMeter = (double)drawable.getWidth() / result.getWidth();
        return result;
    }

    private void setVisibleArea(GL gl, Rectangle2D.Double rect) {
        gl.glOrtho(rect.x, rect.x + rect.width, rect.y + rect.height, rect.y, -1.0, 1.0);
    }

    private void drawDebugLines(GL gl, SimulationState state) {
        if (!GUI.gui.checkBoxDebugLines.isSelected()) {
            return;
        }
        List<Panzer> panzers = state.getPanzers();
        if (panzers.size() == 0) {
            return;
        }
        gl.glDisable(3553);
        for (Panzer panzer : panzers) {
            Color c = panzer.getPilot().getNameColor();
            gl.glColor4d((double)c.getRed() / 255.0, (double)c.getGreen() / 255.0, (double)c.getBlue() / 255.0, (double)c.getAlpha() / 255.0);
            float[] lines = panzer.getDebugLines();
            this.draw2DLines(gl, lines);
        }
    }

    private void draw2DLines(GL gl, float[] lines) {
        if (lines.length > buffer2DLines.capacity()) {
            buffer2DLines = BufferUtil.newFloatBuffer(lines.length);
        }
        buffer2DLines.clear();
        buffer2DLines.put(lines);
        buffer2DLines.clear();
        gl.glEnableClientState(32884);
        gl.glVertexPointer(2, 5126, 0, buffer2DLines);
        gl.glDrawArrays(1, 0, lines.length);
        gl.glDisableClientState(32884);
    }

    private void drawPanzers(GL gl, SimulationState state) {
        List<Panzer> panzers = state.getPanzers();
        if (panzers.size() == 0) {
            return;
        }
        this.texturePanzer.enable();
        this.texturePanzer.bind();
        gl.glTexEnvf(8960, 8704, 8448.0f);
        for (Panzer panzer : panzers) {
            Color c = panzer.getPilot().getBodyColor();
            gl.glColor4d((double)c.getRed() / 255.0, (double)c.getGreen() / 255.0, (double)c.getBlue() / 255.0, 1.0);
            this.drawPanzer(gl, panzer);
        }
    }

    private void drawDeadTracks(GL gl, SimulationState state) {
        Collection<Panzer> panzers = state.getWastedump().values();
        if (panzers.size() == 0) {
            return;
        }
        this.textureTrack.enable();
        this.textureTrack.bind();
        gl.glTexEnvf(8960, 8704, 8448.0f);
        gl.glColor4d(1.0, 1.0, 1.0, this.DEAD_TRANSPARENCY);
        for (Panzer panzer : panzers) {
            this.drawTrack(gl, panzer, panzer.getMileageLeft(), TEXTURE_TRACK_CENTER_Y);
            this.drawTrack(gl, panzer, panzer.getMileageRight(), (double)this.imageTrack.getHeight() - TEXTURE_TRACK_CENTER_Y);
        }
    }

    private void drawDeadPanzers(GL gl, SimulationState state) {
        Collection<Panzer> panzers = state.getWastedump().values();
        if (panzers.size() == 0) {
            return;
        }
        this.texturePanzer.enable();
        this.texturePanzer.bind();
        gl.glTexEnvf(8960, 8704, 8448.0f);
        for (Panzer panzer : panzers) {
            Color c = panzer.getPilot().getBodyColor();
            gl.glColor4d((double)c.getRed() / 255.0, (double)c.getGreen() / 255.0, (double)c.getBlue() / 255.0, this.DEAD_TRANSPARENCY);
            this.drawPanzer(gl, panzer);
        }
    }

    private void drawDeadTurrets(GL gl, SimulationState state) {
        Collection<Panzer> panzers = state.getWastedump().values();
        if (panzers.size() == 0) {
            return;
        }
        this.textureTurret.enable();
        this.textureTurret.bind();
        gl.glTexEnvf(8960, 8704, 8448.0f);
        for (Panzer panzer : panzers) {
            Color c = panzer.getPilot().getTurretColor();
            gl.glColor4d((double)c.getRed() / 255.0, (double)c.getGreen() / 255.0, (double)c.getBlue() / 255.0, this.DEAD_TRANSPARENCY);
            this.drawTurret(gl, panzer, state.timestamp);
        }
    }

    private void drawTracks(GL gl, SimulationState state) {
        List<Panzer> panzers = state.getPanzers();
        if (panzers.size() == 0) {
            return;
        }
        this.textureTrack.enable();
        this.textureTrack.bind();
        gl.glTexEnvf(8960, 8704, 7681.0f);
        gl.glColor4d(1.0, 1.0, 1.0, 1.0);
        for (Panzer panzer : panzers) {
            this.drawTrack(gl, panzer, panzer.getMileageLeft(), TEXTURE_TRACK_CENTER_Y);
            this.drawTrack(gl, panzer, panzer.getMileageRight(), (double)this.imageTrack.getHeight() - TEXTURE_TRACK_CENTER_Y);
        }
    }

    private void drawTurrets(GL gl, SimulationState state) {
        List<Panzer> panzers = state.getPanzers();
        if (panzers.size() == 0) {
            return;
        }
        this.textureTurret.enable();
        this.textureTurret.bind();
        gl.glTexEnvf(8960, 8704, 8448.0f);
        for (Panzer panzer : panzers) {
            Color c = panzer.getPilot().getTurretColor();
            gl.glColor4d((double)c.getRed() / 255.0, (double)c.getGreen() / 255.0, (double)c.getBlue() / 255.0, 1.0);
            this.drawTurret(gl, panzer, state.timestamp);
        }
    }

    private void drawDroppables(GL gl, SimulationState state) {
        List<Droppable> mines = state.getMines();
        if (mines.size() == 0) {
            return;
        }
        gl.glTexEnvf(8960, 8704, 8448.0f);
        for (Droppable mine : mines) {
            mine.draw(gl, this, state.timestamp);
        }
    }

    private void drawPanzer(GL gl, Panzer panzer) {
        gl.glPushMatrix();
        gl.glTranslated(panzer.getPos().getX(), panzer.getPos().getY(), 0.0);
        gl.glRotated(panzer.getOrientation().getValueAsDegrees(), 0.0, 0.0, 1.0);
        gl.glScaled(6.0 / (double)this.imagePanzer.getHeight(), 6.0 / (double)this.imagePanzer.getHeight(), 1.0);
        gl.glTranslated(-64.0, -84.0, 0.0);
        gl.glBegin(7);
        gl.glTexCoord2d(0.0, 0.0);
        gl.glVertex2d(0.0, 0.0);
        gl.glTexCoord2d(1.0, 0.0);
        gl.glVertex2d(this.imagePanzer.getWidth(), 0.0);
        gl.glTexCoord2d(1.0, 1.0);
        gl.glVertex2d(this.imagePanzer.getWidth(), this.imagePanzer.getHeight());
        gl.glTexCoord2d(0.0, 1.0);
        gl.glVertex2d(0.0, this.imagePanzer.getHeight());
        gl.glEnd();
        gl.glPopMatrix();
    }

    private void drawTrack(GL gl, Panzer panzer, double mileage, double texture_track_center_y) {
        gl.glPushMatrix();
        gl.glTranslated(panzer.getPos().getX(), panzer.getPos().getY(), 0.0);
        gl.glRotated(panzer.getOrientation().getValueAsDegrees(), 0.0, 0.0, 1.0);
        gl.glScaled(6.0 / (double)this.imagePanzer.getHeight(), 6.0 / (double)this.imagePanzer.getHeight(), 1.0);
        gl.glTranslated(-68.0, -texture_track_center_y, 0.0);
        gl.glMatrixMode(5890);
        gl.glPushMatrix();
        gl.glTranslated(-mileage / 8.0, 1.0, 1.0);
        gl.glBegin(8);
        gl.glTexCoord2d(0.0, 0.0);
        gl.glVertex2d(0.0, 0.0);
        gl.glTexCoord2d(0.0, 1.0);
        gl.glVertex2d(0.0, this.imageTrack.getHeight());
        gl.glTexCoord2d(0.1, 0.0);
        gl.glVertex2d(0.05 * (double)this.imageTrack.getWidth(), 0.0);
        gl.glTexCoord2d(0.1, 1.0);
        gl.glVertex2d(0.05 * (double)this.imageTrack.getWidth(), this.imageTrack.getHeight());
        gl.glTexCoord2d(0.2, 0.0);
        gl.glVertex2d(0.12 * (double)this.imageTrack.getWidth(), 0.0);
        gl.glTexCoord2d(0.2, 1.0);
        gl.glVertex2d(0.12 * (double)this.imageTrack.getWidth(), this.imageTrack.getHeight());
        gl.glTexCoord2d(0.8, 0.0);
        gl.glVertex2d(0.88 * (double)this.imageTrack.getWidth(), 0.0);
        gl.glTexCoord2d(0.8, 1.0);
        gl.glVertex2d(0.88 * (double)this.imageTrack.getWidth(), this.imageTrack.getHeight());
        gl.glTexCoord2d(0.9, 0.0);
        gl.glVertex2d(0.95 * (double)this.imageTrack.getWidth(), 0.0);
        gl.glTexCoord2d(0.9, 1.0);
        gl.glVertex2d(0.95 * (double)this.imageTrack.getWidth(), this.imageTrack.getHeight());
        gl.glTexCoord2d(1.0, 0.0);
        gl.glVertex2d(this.imageTrack.getWidth(), 0.0);
        gl.glTexCoord2d(1.0, 1.0);
        gl.glVertex2d(this.imageTrack.getWidth(), this.imageTrack.getHeight());
        gl.glEnd();
        gl.glMatrixMode(5890);
        gl.glPopMatrix();
        gl.glMatrixMode(5888);
        gl.glPopMatrix();
    }

    private void drawTurret(GL gl, Panzer panzer, double time) {
        double endTime;
        TreeMap<Double, Angle> turret = SimulationRun.simulationRun.getTurret(panzer.turretIndex);
        double startTime = (Double)turret.subMap(0.0, true, time, true).lastKey();
        try {
            endTime = turret.tailMap(time).firstKey();
        }
        catch (NoSuchElementException e) {
            endTime = startTime;
        }
        double startAngle = turret.get(startTime).normalize().getValueAsDegrees();
        double endAngle = turret.get(endTime).normalize().getValueAsDegrees();
        if (endAngle - startAngle > 180.0) {
            startAngle += 360.0;
        } else if (startAngle - endAngle > 180.0) {
            endAngle += 360.0;
        }
        double angle = startAngle;
        if (startTime != endTime) {
            double deltaT = (time - startTime) / (endTime - startTime);
            deltaT = (Math.sin((deltaT - 0.5) * Math.PI) + 1.0) / 2.0;
            angle += (endAngle - startAngle) * deltaT;
        }
        gl.glPushMatrix();
        gl.glTranslated(panzer.getPos().getX(), panzer.getPos().getY(), 0.0);
        gl.glRotated(angle, 0.0, 0.0, 1.0);
        gl.glScaled(6.0 / (double)this.imagePanzer.getHeight(), 6.0 / (double)this.imagePanzer.getHeight(), 1.0);
        gl.glTranslated(-44.0, -44.0, 0.0);
        gl.glBegin(7);
        gl.glTexCoord2d(0.0, 0.0);
        gl.glVertex2d(0.0, 0.0);
        gl.glTexCoord2d(1.0, 0.0);
        gl.glVertex2d(this.imageTurret.getWidth(), 0.0);
        gl.glTexCoord2d(1.0, 1.0);
        gl.glVertex2d(this.imageTurret.getWidth(), this.imageTurret.getHeight());
        gl.glTexCoord2d(0.0, 1.0);
        gl.glVertex2d(0.0, this.imageTurret.getHeight());
        gl.glEnd();
        gl.glPopMatrix();
    }

    public void drawMine(GL gl, Droppable mine, double time, boolean armed) {
        if (armed) {
            this.textureMineRed.enable();
            this.textureMineRed.bind();
        } else {
            this.textureMine.enable();
            this.textureMine.bind();
        }
        Color c = mine.getColor();
        double DURATION = 1.0;
        double blend = 0.0;
        if (mine.getAge() + 1.0 >= mine.getMaxAge()) {
            blend = 1.0 - (mine.getMaxAge() - mine.getAge()) / 1.0;
        }
        double red = (double)c.getRed() / 255.0 * (1.0 - blend) + 0.2980392156862745 * blend;
        double green = (double)c.getGreen() / 255.0 * (1.0 - blend) + 0.30196078431372547 * blend;
        double blue = (double)c.getBlue() / 255.0 * (1.0 - blend) + 0.07450980392156863 * blend;
        gl.glColor4d(red, green, blue, 1.0 - blend);
        gl.glPushMatrix();
        gl.glTranslated(mine.getPos().getX(), mine.getPos().getY(), 0.0);
        gl.glScaled(6.0 / (double)this.imagePanzer.getHeight(), 6.0 / (double)this.imagePanzer.getHeight(), 1.0);
        gl.glTranslated(-this.imageMine.getWidth() / 2, -this.imageMine.getHeight() / 2, 0.0);
        gl.glBegin(7);
        gl.glTexCoord2d(0.0, 0.0);
        gl.glVertex2d(0.0, 0.0);
        gl.glTexCoord2d(1.0, 0.0);
        gl.glVertex2d(this.imageMine.getWidth(), 0.0);
        gl.glTexCoord2d(1.0, 1.0);
        gl.glVertex2d(this.imageMine.getWidth(), this.imageMine.getHeight());
        gl.glTexCoord2d(0.0, 1.0);
        gl.glVertex2d(0.0, this.imageMine.getHeight());
        gl.glEnd();
        gl.glPopMatrix();
    }

    public void drawTankTrap(GL gl, TankTrap mine, double time, boolean armed) {
        if (armed) {
            this.textureTrap.enable();
            this.textureTrap.bind();
        } else {
            this.textureTrap0.enable();
            this.textureTrap0.bind();
        }
        Color c = mine.getColor();
        double DURATION = 1.0;
        double blend = 0.0;
        if (mine.getAge() + 1.0 >= mine.getMaxAge()) {
            blend = 1.0 - (mine.getMaxAge() - mine.getAge()) / 1.0;
        }
        double red = (double)c.getRed() / 255.0 * (1.0 - blend) + 0.2980392156862745 * blend;
        double green = (double)c.getGreen() / 255.0 * (1.0 - blend) + 0.30196078431372547 * blend;
        double blue = (double)c.getBlue() / 255.0 * (1.0 - blend) + 0.07450980392156863 * blend;
        gl.glColor4d(red, green, blue, 1.0 - blend);
        gl.glPushMatrix();
        gl.glTranslated(mine.getPos().getX(), mine.getPos().getY(), 0.0);
        gl.glScaled(6.0 / (double)this.imagePanzer.getHeight(), 6.0 / (double)this.imagePanzer.getHeight(), 1.0);
        gl.glTranslated(-this.imageTrap.getWidth() / 2, -this.imageTrap.getHeight() / 2, 0.0);
        gl.glBegin(7);
        gl.glTexCoord2d(0.0, 0.0);
        gl.glVertex2d(0.0, 0.0);
        gl.glTexCoord2d(1.0, 0.0);
        gl.glVertex2d(this.imageTrap.getWidth(), 0.0);
        gl.glTexCoord2d(1.0, 1.0);
        gl.glVertex2d(this.imageTrap.getWidth(), this.imageTrap.getHeight());
        gl.glTexCoord2d(0.0, 1.0);
        gl.glVertex2d(0.0, this.imageTrap.getHeight());
        gl.glEnd();
        gl.glPopMatrix();
    }

    private void drawScanFan(GL gl, ScanFan scanFan, double ratio) {
        boolean scanHit;
        gl.glPushMatrix();
        gl.glTranslated(scanFan.x, scanFan.y, 0.0);
        boolean bl = scanHit = scanFan.range >= 0.0;
        if (scanHit) {
            gl.glScaled(scanFan.range, scanFan.range, 1.0);
        } else {
            gl.glScaled(200.0, 200.0, 1.0);
        }
        gl.glBegin(6);
        ratio = 1.0 - ratio;
        gl.glColor4d(0.2, 0.2, 0.6, 0.4 * (scanHit ? 1.0 : 0.25) * ratio * ratio);
        gl.glVertex2d(0.0, 0.0);
        gl.glColor4d(0.0, 0.0, 0.5, 0.1 * (scanHit ? 1.0 : 0.005) * ratio);
        double angle = scanFan.startAngle > scanFan.endAngle ? scanFan.startAngle - 360.0 : scanFan.startAngle;
        while (angle < scanFan.endAngle) {
            gl.glVertex2d(Math.cos(angle / 180.0 * Math.PI), Math.sin(angle / 180.0 * Math.PI));
            angle += 1.0;
        }
        gl.glVertex2d(Math.cos(scanFan.endAngle / 180.0 * Math.PI), Math.sin(scanFan.endAngle / 180.0 * Math.PI));
        gl.glEnd();
        gl.glPopMatrix();
    }

    @Override
    public void reshape(GLAutoDrawable drawable, int x, int y, int width, int height) {
    }

    @Override
    public void displayChanged(GLAutoDrawable drawable, boolean modeChanged, boolean deviceChanged) {
    }
}

