/*
 * Decompiled with CFR 0.152.
 */
package jrobots.graphics;

import com.sun.opengl.util.BufferUtil;
import java.awt.Color;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.media.opengl.GL;
import jrobots.graphics.Particle;
import jrobots.utils.Vector;

public class ExplosionManager
implements Serializable {
    private static final long serialVersionUID = 7744966047788939715L;
    public static final double TIME_TO_LIVE = 0.8;
    static final double speedLossPerSecond = 0.9;
    private static int TRIANGLES_PER_CLOUD = 6;
    private static TreeMap<Float, Color> centerColor;
    private static TreeMap<Float, Color> borderColor;
    private static int currentBatchSize;
    private static final int BYTES_PER_VERTEX = 12;
    private static ByteBuffer buffer;

    static {
        currentBatchSize = 0;
        centerColor = new TreeMap();
        centerColor.put(Float.valueOf(0.0f), new Color(255, 255, 255, 255));
        centerColor.put(Float.valueOf(0.1f), new Color(255, 255, 255, 255));
        centerColor.put(Float.valueOf(0.3f), new Color(255, 128, 64, 192));
        centerColor.put(Float.valueOf(0.5f), new Color(128, 64, 0, 128));
        centerColor.put(Float.valueOf(0.7f), new Color(128, 128, 64, 64));
        centerColor.put(Float.valueOf(1.0f), new Color(128, 128, 128, 0));
        borderColor = new TreeMap();
        borderColor.put(Float.valueOf(0.0f), new Color(255, 255, 255, 64));
        borderColor.put(Float.valueOf(0.1f), new Color(255, 255, 0, 64));
        borderColor.put(Float.valueOf(0.2f), new Color(128, 64, 0, 32));
        borderColor.put(Float.valueOf(0.4f), new Color(0, 0, 0, 0));
        borderColor.put(Float.valueOf(0.7f), new Color(128, 128, 128, 0));
        borderColor.put(Float.valueOf(1.0f), new Color(128, 128, 128, 0));
        ExplosionManager.changeBatchSize(1);
    }

    private static void changeBatchSize(int newBatchSize) {
        currentBatchSize = newBatchSize;
        buffer = BufferUtil.newByteBuffer(currentBatchSize * (TRIANGLES_PER_CLOUD * 3) * 12);
    }

    static Color calculateCenterColor(double age) {
        float floorAge = centerColor.floorKey(Float.valueOf((float)age)).floatValue();
        float ceilingAge = centerColor.ceilingKey(Float.valueOf((float)age)).floatValue();
        float delta1 = ((float)age - floorAge) / (ceilingAge - floorAge);
        float delta2 = (ceilingAge - (float)age) / (ceilingAge - floorAge);
        Color cf = centerColor.get(Float.valueOf(floorAge));
        Color cc = centerColor.get(Float.valueOf(ceilingAge));
        return new Color((int)((float)cf.getRed() * delta2 + (float)cc.getRed() * delta1), (int)((float)cf.getGreen() * delta2 + (float)cc.getGreen() * delta1), (int)((float)cf.getBlue() * delta2 + (float)cc.getBlue() * delta1), (int)((float)cf.getAlpha() * delta2 + (float)cc.getAlpha() * delta1));
    }

    static Color calculateBorderColor(double age) {
        float floorAge = borderColor.floorKey(Float.valueOf((float)age)).floatValue();
        float ceilingAge = borderColor.ceilingKey(Float.valueOf((float)age)).floatValue();
        float delta1 = ((float)age - floorAge) / (ceilingAge - floorAge);
        float delta2 = (ceilingAge - (float)age) / (ceilingAge - floorAge);
        Color cf = borderColor.get(Float.valueOf(floorAge));
        Color cc = borderColor.get(Float.valueOf(ceilingAge));
        return new Color((int)((float)cf.getRed() * delta2 + (float)cc.getRed() * delta1), (int)((float)cf.getGreen() * delta2 + (float)cc.getGreen() * delta1), (int)((float)cf.getBlue() * delta2 + (float)cc.getBlue() * delta1), (int)((float)cf.getAlpha() * delta2 + (float)cc.getAlpha() * delta1));
    }

    static double calculateRadius(double age) {
        return 0.5 + Math.pow(age, 0.7) * 5.0;
    }

    static void drawClouds(GL gl, double time, SortedMap<Double, Particle> particles) {
        gl.glDisable(3553);
        if (currentBatchSize < particles.size()) {
            ExplosionManager.changeBatchSize(particles.size());
        }
        buffer.clear();
        for (Particle p : particles.values()) {
            double age = time - p.creationTime;
            Vector center = p.position.add(p.speed.mult((1.0 - Math.pow(0.9, age)) / 0.09999999999999998));
            double radius = ExplosionManager.calculateRadius(age /= 0.8);
            Color centerColor = ExplosionManager.calculateCenterColor(age);
            Color borderColor = ExplosionManager.calculateBorderColor(age);
            double angle = 0.0;
            int i = 0;
            while (i < TRIANGLES_PER_CLOUD) {
                buffer.put((byte)centerColor.getRed());
                buffer.put((byte)centerColor.getGreen());
                buffer.put((byte)centerColor.getBlue());
                buffer.put((byte)centerColor.getAlpha());
                buffer.putFloat((float)center.getX());
                buffer.putFloat((float)center.getY());
                buffer.put((byte)borderColor.getRed());
                buffer.put((byte)borderColor.getGreen());
                buffer.put((byte)borderColor.getBlue());
                buffer.put((byte)borderColor.getAlpha());
                buffer.putFloat((float)(center.getX() + radius * Math.cos(angle)));
                buffer.putFloat((float)(center.getY() + radius * Math.sin(angle)));
                angle += Math.PI * 2 / (double)TRIANGLES_PER_CLOUD;
                buffer.put((byte)borderColor.getRed());
                buffer.put((byte)borderColor.getGreen());
                buffer.put((byte)borderColor.getBlue());
                buffer.put((byte)borderColor.getAlpha());
                buffer.putFloat((float)(center.getX() + radius * Math.cos(angle)));
                buffer.putFloat((float)(center.getY() + radius * Math.sin(angle)));
                ++i;
            }
        }
        buffer.clear();
        gl.glInterleavedArrays(10786, 0, buffer);
        gl.glDrawArrays(4, 0, particles.size() * TRIANGLES_PER_CLOUD * 3);
        gl.glDisableClientState(32884);
        gl.glDisableClientState(32886);
    }
}

