/*
 * Decompiled with CFR 0.152.
 */
package jrobots.graphics;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.TreeMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.media.opengl.GLCanvas;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import jrobots.graphics.ArenaController;
import jrobots.graphics.PlayButton;
import jrobots.graphics.PlaybackController;
import jrobots.graphics.SimulateButton;
import jrobots.graphics.TimelineSlider;
import jrobots.pilotlist.LoadedBotClass;
import jrobots.pilotlist.PilotListCellRenderer;
import jrobots.pilotlist.PilotListModel;
import jrobots.pilotlist.PilotManager;
import jrobots.simulation.SimulationRun;
import jrobots.simulation.SimulationState;
import jrobots.simulation.simulationObjects.Panzer;
import jrobots.simulation.simulationObjects.Pilot;

public class GUI
implements ActionListener,
ChangeListener,
MouseListener {
    public static GUI gui = null;
    private JFrame mainFrame;
    public PlayButton buttonPlayPause;
    public SimulateButton buttonSimulate;
    private JButton buttonCrop;
    public JSlider timelineSlider;
    public GLCanvas arena;
    private JList botList;
    JCheckBox checkBoxDebugLines;
    private JButton buttonSaveFully;
    private JButton buttonSaveLossy;
    private JButton buttonLoad;
    private JButton buttonAbout;
    private int currentSimulationStateIndex = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GUI() {
        SimulationRun simulationRun = SimulationRun.simulationRun;
        synchronized (simulationRun) {
            this.mainFrame = new JFrame("JRobots");
            this.mainFrame.getContentPane().setLayout(new BorderLayout(10, 0));
            this.mainFrame.setMinimumSize(new Dimension(800, 600));
            this.mainFrame.setDefaultCloseOperation(2);
            this.buttonPlayPause = new PlayButton("Play");
            this.buttonPlayPause.setToolTipText("Toggle between PLAY and PAUSE mode.");
            this.buttonSimulate = new SimulateButton("Simulate");
            this.buttonSimulate.setToolTipText("Starts (/ continues) or stops the simulation of the current bot fight.");
            this.buttonCrop = new JButton("Crop");
            this.buttonCrop.setToolTipText("Crops the simulation recording at the current position.");
            this.checkBoxDebugLines = new JCheckBox("DebugLines", false);
            this.checkBoxDebugLines.setToolTipText("Controls the display of the debuglines of all bots.");
            this.buttonSaveFully = new JButton("Save state!");
            this.buttonSaveLossy = new JButton("Save replay!");
            this.buttonLoad = new JButton("Load state/replay...");
            this.buttonAbout = new JButton("About");
            JPanel buttonPanel = new JPanel(new FlowLayout(0, 10, 10));
            buttonPanel.add(this.buttonSimulate);
            buttonPanel.add(this.buttonPlayPause);
            buttonPanel.add(this.buttonCrop);
            buttonPanel.add(this.checkBoxDebugLines);
            buttonPanel.add(this.buttonSaveFully);
            buttonPanel.add(this.buttonSaveLossy);
            buttonPanel.add(this.buttonLoad);
            buttonPanel.add(this.buttonAbout);
            this.buttonCrop.addActionListener(this);
            this.checkBoxDebugLines.addActionListener(this);
            this.buttonSaveFully.addActionListener(this);
            this.buttonSaveLossy.addActionListener(this);
            this.buttonLoad.addActionListener(this);
            this.buttonAbout.addActionListener(this);
            this.timelineSlider = new TimelineSlider(0, SimulationRun.simulationRun.getStateCount() - 1, 0);
            this.timelineSlider.setBorder(new EmptyBorder(0, 10, 10, 10));
            this.timelineSlider.addChangeListener(this);
            Box controlArea = Box.createVerticalBox();
            controlArea.add(buttonPanel);
            controlArea.add(this.timelineSlider);
            this.mainFrame.getContentPane().add((Component)controlArea, "North");
            this.botList = new JList(new PilotListModel());
            this.botList.setCellRenderer(new PilotListCellRenderer());
            JScrollPane botListScrollPane = new JScrollPane(this.botList);
            this.mainFrame.getContentPane().add((Component)botListScrollPane, "West");
            this.botList.addMouseListener(this);
            this.arena = new GLCanvas();
            new ArenaController(this.arena);
            this.mainFrame.getContentPane().add((Component)this.arena, "Center");
            this.setCurrentSimulationStateIndex(0);
            this.mainFrame.setVisible(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCurrentSimulationStateIndex(int index) {
        SimulationRun simulationRun = SimulationRun.simulationRun;
        synchronized (simulationRun) {
            this.currentSimulationStateIndex = index;
            this.timelineSlider.setValue(this.currentSimulationStateIndex);
            this.arena.repaint();
            SimulationState state = SimulationRun.simulationRun.getSimulationState(this.currentSimulationStateIndex);
            PilotManager.updateVisibleInstances(state.getPanzers());
            this.botList.repaint();
            PlaybackController.setIndex(this.currentSimulationStateIndex);
        }
    }

    public void clickPlayPauseButton() {
        this.buttonPlayPause.doClick();
    }

    public int getCurrentSimulationStateIndex() {
        return this.currentSimulationStateIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonCrop) {
            SimulationRun.simulationRun.cropAfter(this.currentSimulationStateIndex);
            this.timelineSlider.repaint();
            this.buttonSimulate.repaint();
        } else if (e.getSource() == this.checkBoxDebugLines) {
            this.arena.repaint();
        } else if (e.getSource() == this.buttonSaveFully) {
            try {
                SimulationRun simulationRun = SimulationRun.simulationRun;
                synchronized (simulationRun) {
                    Calendar cal = Calendar.getInstance();
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH.mm.ss");
                    String fileName = sdf.format(cal.getTime());
                    for (Panzer panzer : SimulationRun.simulationRun.getSimulationState(0).getPanzers()) {
                        fileName = String.valueOf(fileName) + " " + panzer.getPilot().getName();
                    }
                    FileOutputStream fos = new FileOutputStream(String.valueOf(fileName) + ".zip");
                    ZipOutputStream zos = new ZipOutputStream(fos);
                    zos.setLevel(9);
                    ZipEntry ze = new ZipEntry(fileName);
                    zos.putNextEntry(ze);
                    ObjectOutputStream oos = new ObjectOutputStream(zos);
                    oos.writeObject(SimulationRun.simulationRun);
                    oos.flush();
                    zos.flush();
                    zos.closeEntry();
                    zos.close();
                    fos.close();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        } else if (e.getSource() == this.buttonSaveLossy) {
            try {
                SimulationRun ex = SimulationRun.simulationRun;
                synchronized (ex) {
                    Calendar cal = Calendar.getInstance();
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH.mm.ss");
                    String fileName = "Replay " + sdf.format(cal.getTime());
                    for (Panzer panzer : SimulationRun.simulationRun.getSimulationState(0).getPanzers()) {
                        fileName = String.valueOf(fileName) + " " + panzer.getPilot().getClass().getSimpleName();
                    }
                    FileOutputStream fos = new FileOutputStream(String.valueOf(fileName) + ".zip");
                    ZipOutputStream zos = new ZipOutputStream(fos);
                    zos.setLevel(9);
                    ZipEntry ze = new ZipEntry(fileName);
                    zos.putNextEntry(ze);
                    ObjectOutputStream oos = new ObjectOutputStream(zos);
                    SimulationRun zombieRun = SimulationRun.simulationRun.anonymizedClone();
                    oos.writeObject(zombieRun);
                    oos.flush();
                    zos.flush();
                    zos.closeEntry();
                    zos.close();
                    fos.close();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        } else if (e.getSource() == this.buttonLoad) {
            JFileChooser fc = new JFileChooser();
            fc.setCurrentDirectory(new File(System.getProperty("user.dir")));
            int returnVal = fc.showOpenDialog(this.mainFrame);
            if (returnVal == 0) {
                try {
                    File file = fc.getSelectedFile();
                    FileInputStream fis = new FileInputStream(file);
                    ZipInputStream zis = new ZipInputStream(fis);
                    zis.getNextEntry();
                    ObjectInputStream ois = new ObjectInputStream(zis);
                    SimulationRun sr = (SimulationRun)ois.readObject();
                    SimulationRun simulationRun = SimulationRun.simulationRun;
                    synchronized (simulationRun) {
                        SimulationRun.simulationRun = sr;
                        this.setCurrentSimulationStateIndex(0);
                    }
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        } else if (e.getSource() == this.buttonAbout) {
            try {
                JEditorPane pane = new JEditorPane("text/html", "<html>Java programming contest<br>(c) 2005-2014<br>Please also visit <a href=\"www.jrobots.de\">www.jrobots.de</a></html>");
                pane.setEditable(false);
                pane.setBackground(this.mainFrame.getBackground());
                pane.setFont(this.mainFrame.getFont());
                pane.addHyperlinkListener(new HyperlinkListener(){

                    @Override
                    public void hyperlinkUpdate(HyperlinkEvent evt) {
                        if (evt.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                            Desktop desktop;
                            JEditorPane pane = (JEditorPane)evt.getSource();
                            Desktop desktop2 = desktop = Desktop.isDesktopSupported() ? Desktop.getDesktop() : null;
                            if (desktop != null && desktop.isSupported(Desktop.Action.BROWSE)) {
                                try {
                                    desktop.browse(new URI(evt.getDescription()));
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                }
                            }
                        }
                    }
                });
                JOptionPane.showMessageDialog(this.mainFrame, pane, "About JRobots...", 1);
            }
            catch (HeadlessException e1) {
                e1.printStackTrace();
            }
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        int newIndex = ((TimelineSlider)e.getSource()).getValue();
        if (this.currentSimulationStateIndex != newIndex) {
            this.setCurrentSimulationStateIndex(newIndex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeBot(Class<? extends Pilot> pilotClass) {
        SimulationRun simulationRun = SimulationRun.simulationRun;
        synchronized (simulationRun) {
            SimulationState state = SimulationRun.simulationRun.getSimulationState(this.currentSimulationStateIndex);
            state.removePilots(pilotClass);
            PilotManager.updateVisibleInstances(state.getPanzers());
        }
        SimulationRun.simulationRun.cropAfter(this.currentSimulationStateIndex);
        this.timelineSlider.repaint();
        this.botList.repaint();
        this.arena.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addBot(Class<? extends Pilot> pilotClass) {
        SimulationRun simulationRun = SimulationRun.simulationRun;
        synchronized (simulationRun) {
            SimulationState state = SimulationRun.simulationRun.getSimulationState(this.currentSimulationStateIndex);
            try {
                state.createNewPanzer(pilotClass);
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            PilotManager.updateVisibleInstances(state.getPanzers());
        }
        SimulationRun.simulationRun.cropAfter(this.currentSimulationStateIndex);
        this.timelineSlider.repaint();
        this.botList.repaint();
        this.arena.repaint();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mouseReleased(MouseEvent e) {
        if (e.getButton() != 1) {
            return;
        }
        TreeMap<String, LoadedBotClass> treeMap = PilotManager.pilots;
        synchronized (treeMap) {
            Object[] lbcs = PilotManager.pilots.values().toArray();
            int index = 0;
            while (index < this.botList.getModel().getSize()) {
                if (this.botList.getCellBounds(index, index).contains(e.getPoint())) {
                    LoadedBotClass lbc = (LoadedBotClass)lbcs[index];
                    if (lbc.visibleInstance == null) {
                        this.addBot(lbc.pilotClass);
                    } else {
                        this.removeBot(lbc.pilotClass);
                    }
                }
                ++index;
            }
        }
    }
}

