/*
 * Decompiled with CFR 0.152.
 */
package jrobots.graphics;

import jrobots.graphics.GUI;
import jrobots.simulation.SimulationRun;

public class PlaybackController
extends Thread {
    public static int FPS = 25;
    public static double speed = 1.0;
    static PlaybackController playbackController = null;
    private static boolean isRunning = false;
    private boolean dieNow = false;
    private double currentTime;
    private int currentIndex;
    private int displayedFPS = 0;
    private double displayedSpeed = 0.0;

    public static synchronized boolean isRunning() {
        return isRunning;
    }

    public static synchronized void setRunning(boolean running) {
        if (running == isRunning) {
            return;
        }
        isRunning = running;
        if (running) {
            playbackController = new PlaybackController();
            playbackController.start();
        } else {
            PlaybackController.playbackController.dieNow = true;
            playbackController = null;
        }
        GUI.gui.buttonPlayPause.repaint();
    }

    public PlaybackController() {
        this.setDaemon(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.currentIndex = GUI.gui.timelineSlider.getValue();
        this.currentTime = SimulationRun.simulationRun.getSimulationState((int)this.currentIndex).timestamp;
        long lastFrame = System.nanoTime();
        while (!this.dieNow) {
            this.updateName();
            double elapsed = (double)(System.nanoTime() - lastFrame) / 1.0E9;
            double frameDelay = 1.0 / (double)FPS;
            this.currentTime += frameDelay * speed;
            frameDelay -= elapsed;
            try {
                Thread.sleep(Math.round(Math.max(1.0, frameDelay * 1000.0)));
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            lastFrame = System.nanoTime();
            SimulationRun simulationRun = SimulationRun.simulationRun;
            synchronized (simulationRun) {
                this.currentIndex = SimulationRun.simulationRun.getLastStateBefore(this.currentTime);
                GUI.gui.setCurrentSimulationStateIndex(this.currentIndex);
                if (SimulationRun.simulationRun.getStateCount() - 1 == this.currentIndex) {
                    this.currentTime = SimulationRun.simulationRun.getSimulationState((int)this.currentIndex).timestamp;
                    PlaybackController.setRunning(false);
                }
            }
        }
    }

    private void updateName() {
        if (this.displayedFPS != FPS || this.displayedSpeed != speed) {
            this.setName("PlaybackController(FPS=" + FPS + ",speed=" + Math.round(speed * 100.0) / 100L + ")");
            this.displayedFPS = FPS;
            this.displayedSpeed = speed;
        }
    }

    public static void setIndex(int newIndex) {
        if (playbackController == null) {
            return;
        }
        if (newIndex == PlaybackController.playbackController.currentIndex) {
            return;
        }
        PlaybackController.playbackController.currentIndex = newIndex;
        PlaybackController.playbackController.currentTime = SimulationRun.simulationRun.getSimulationState((int)newIndex).timestamp;
    }
}

