/*
 * Decompiled with CFR 0.152.
 */
package jrobots.graphics;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import javax.media.opengl.GL;

public class Shader {
    private GL gl;
    private final int programObject;

    private Shader() {
        this.gl = null;
        this.programObject = 0;
    }

    public Shader(GL gl, URL vertexShaderFilename, URL fragmentShaderFilename) throws FileNotFoundException, IOException {
        this(gl, new URL[]{vertexShaderFilename}, new URL[]{fragmentShaderFilename});
    }

    public Shader(GL gl, URL[] vertexShaderFilenames, URL[] fragmentShaderFilenames) throws FileNotFoundException, IOException {
        this.gl = gl;
        this.programObject = gl.glCreateProgram();
        int i = 0;
        while (i < vertexShaderFilenames.length) {
            this.loadAndAttachShaderfile(this.programObject, 35633, vertexShaderFilenames[i]);
            ++i;
        }
        i = 0;
        while (i < fragmentShaderFilenames.length) {
            this.loadAndAttachShaderfile(this.programObject, 35632, fragmentShaderFilenames[i]);
            ++i;
        }
        gl.glLinkProgram(this.programObject);
        this.checkInfoLog(this.programObject);
        System.out.println("Shader loaded.");
    }

    public void setGL(GL gl) {
        this.gl = gl;
    }

    private void loadAndAttachShaderfile(int programObject, int shaderType, URL filename) throws FileNotFoundException, IOException {
        System.out.println("Loading shader sourcefile " + filename);
        int shaderObject = this.gl.glCreateShader(shaderType);
        this.loadShaderSource(shaderObject, filename);
        this.checkInfoLog(shaderObject);
        this.gl.glCompileShader(shaderObject);
        this.checkInfoLog(shaderObject);
        this.gl.glAttachShader(programObject, shaderObject);
        this.checkInfoLog(programObject);
        this.gl.glDeleteShader(shaderObject);
    }

    private void loadShaderSource(int shaderObject, URL filename) throws FileNotFoundException, IOException {
        String lines = this.loadFile(filename);
        this.gl.glShaderSource(shaderObject, 1, new String[]{lines}, new int[]{lines.length()}, 0);
    }

    private String loadFile(String filename) throws FileNotFoundException, IOException {
        FileReader fileReader = new FileReader(filename);
        StringBuffer buf = new StringBuffer();
        char[] read_buf = new char[1024];
        int num_read = 0;
        while ((num_read = fileReader.read(read_buf, 0, 1024)) != -1) {
            buf.append(read_buf, 0, num_read);
        }
        fileReader.close();
        byte[] bytes = buf.toString().getBytes();
        int i = 0;
        while (i < bytes.length) {
            if (bytes[i] < 0 || bytes[i] > 127) {
                bytes[i] = 32;
            }
            ++i;
        }
        return new String(bytes);
    }

    private String loadFile(URL url) throws IOException {
        String inputLine;
        StringBuffer buf = new StringBuffer();
        InputStream is = url.openStream();
        BufferedReader in = new BufferedReader(new InputStreamReader(is));
        while ((inputLine = in.readLine()) != null) {
            buf.append(String.valueOf(inputLine) + "\n");
        }
        in.close();
        return buf.toString();
    }

    public void bind() {
        this.gl.glUseProgram(this.programObject);
    }

    private void checkInfoLog(int object) {
        String infoLog = this.getInfoLog(object);
        if (!infoLog.equals("")) {
            System.err.println(infoLog);
        }
    }

    private String getInfoLog(int object) {
        int[] infoLogLength = new int[1];
        this.gl.glGetObjectParameterivARB(object, 35716, infoLogLength, 0);
        byte[] infolog = new byte[infoLogLength[0] + 1];
        int[] length = new int[1];
        this.gl.glGetInfoLogARB(object, infolog.length, length, 0, infolog, 0);
        return new String(infolog, 0, length[0]);
    }

    public void unbind() {
        this.gl.glUseProgramObjectARB(0);
    }

    public int glGetUniformLocation(String variableName) {
        return this.gl.glGetUniformLocation(this.programObject, variableName);
    }

    public void destroy() {
        if (this.programObject != 0) {
            this.gl.glDeleteProgram(this.programObject);
        }
    }
}

