/*
 * Decompiled with CFR 0.152.
 */
package jrobots.graphics;

import java.io.Serializable;
import java.util.Random;
import jrobots.simulation.SimulationRun;
import jrobots.utils.Vector;

public class SmokeGenerator
implements Serializable {
    private static final long serialVersionUID = -1750061692560595228L;
    private double cloudsPerSecond;
    private double positionScatterRadius;
    private double speedScatterRadius;
    private Random random;

    public SmokeGenerator(double cloudsPerSecond, double positionScatterRadius, double speedScatterRadius) {
        this.cloudsPerSecond = cloudsPerSecond;
        this.positionScatterRadius = positionScatterRadius;
        this.speedScatterRadius = speedScatterRadius;
        this.random = new Random();
    }

    public void generateSmoke(Vector startPos, Vector endPos, double startTime, double endTime, Vector initialSpeed) {
        double newCloudCount = Math.round((endTime - startTime) * this.cloudsPerSecond);
        int i = 0;
        while ((double)i < newCloudCount) {
            double frac = (double)i / newCloudCount;
            Vector posScatter = new Vector(this.random.nextGaussian() * this.positionScatterRadius, this.random.nextGaussian() * this.positionScatterRadius);
            Vector speedScatter = new Vector(this.random.nextGaussian() * this.speedScatterRadius, this.random.nextGaussian() * this.speedScatterRadius);
            Vector pos = startPos.mult(1.0 - frac).add(endPos.mult(frac));
            double time = startTime * (1.0 - frac) + endTime * frac;
            SimulationRun.simulationRun.addSmokeParticle(pos.add(posScatter), initialSpeed.add(speedScatter), time);
            ++i;
        }
    }
}

