/*
 * Decompiled with CFR 0.152.
 */
package jrobots.graphics;

import com.sun.opengl.util.BufferUtil;
import java.awt.Color;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.SortedMap;
import javax.media.opengl.GL;
import jrobots.graphics.Particle;
import jrobots.utils.Vector;

public class SmokeManager
implements Serializable {
    private static final long serialVersionUID = -5602812971415065317L;
    public static final double TIME_TO_LIVE = 2.0;
    static final double speedLossPerSecond = 0.5;
    private static int TRIANGLES_PER_CLOUD = 6;
    private static int currentBatchSize = 0;
    private static final int BYTES_PER_VERTEX = 12;
    private static ByteBuffer buffer;

    static {
        SmokeManager.changeBatchSize(1);
    }

    private static void changeBatchSize(int newBatchSize) {
        currentBatchSize = newBatchSize;
        buffer = BufferUtil.newByteBuffer(currentBatchSize * (TRIANGLES_PER_CLOUD * 3) * 12);
    }

    static Color calculateCenterColor(double age) {
        return new Color((float)(0.3 + age * 0.7), (float)(0.3 + age * 0.7), (float)(0.3 + age * 0.7), (float)Math.pow(1.0 - age, 2.0));
    }

    static Color calculateBorderColor(double age) {
        return new Color((float)(0.5 + age * 0.4), (float)(0.5 + age * 0.4), (float)(0.5 + age * 0.4), 0.0f);
    }

    static double calculateRadius(double age) {
        return 0.5 + Math.pow(age, 2.0) * 10.0;
    }

    static void drawClouds(GL gl, double time, SortedMap<Double, Particle> particles) {
        gl.glDisable(3553);
        if (currentBatchSize < particles.size()) {
            SmokeManager.changeBatchSize(particles.size());
        }
        buffer.clear();
        for (Particle p : particles.values()) {
            double age = time - p.creationTime;
            Vector center = p.position.add(p.speed.mult((1.0 - Math.pow(0.5, age)) / 0.5));
            double radius = SmokeManager.calculateRadius(age /= 2.0);
            Color centerColor = SmokeManager.calculateCenterColor(age);
            Color borderColor = SmokeManager.calculateBorderColor(age);
            double angle = 0.0;
            int i = 0;
            while (i < TRIANGLES_PER_CLOUD) {
                buffer.putInt(centerColor.getRGB());
                buffer.putFloat((float)center.getX());
                buffer.putFloat((float)center.getY());
                buffer.putInt(borderColor.getRGB());
                buffer.putFloat((float)(center.getX() + radius * Math.cos(angle)));
                buffer.putFloat((float)(center.getY() + radius * Math.sin(angle)));
                buffer.putInt(borderColor.getRGB());
                buffer.putFloat((float)(center.getX() + radius * Math.cos(angle += Math.PI * 2 / (double)TRIANGLES_PER_CLOUD)));
                buffer.putFloat((float)(center.getY() + radius * Math.sin(angle)));
                ++i;
            }
        }
        buffer.clear();
        gl.glInterleavedArrays(10786, 0, buffer);
        gl.glDrawArrays(4, 0, particles.size() * TRIANGLES_PER_CLOUD * 3);
        gl.glDisableClientState(32884);
        gl.glDisableClientState(32886);
    }
}

