/*
 * Decompiled with CFR 0.152.
 */
package jrobots.graphics;

import java.awt.Graphics;
import java.util.Hashtable;
import javax.swing.JLabel;
import javax.swing.JSlider;
import jrobots.simulation.SimulationRun;

class TimelineSlider
extends JSlider {
    private static final long serialVersionUID = -6815301379204482268L;
    private static final int LABEL_COUNT = 20;

    public TimelineSlider(int min, int max, int value) {
        super(min, max, value);
        this.updateLabels();
        this.setPaintLabels(true);
        this.setPaintTicks(true);
        this.setMinorTickSpacing(10);
        this.setMajorTickSpacing(100);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateLabels() {
        Hashtable<Integer, JLabel> labels = new Hashtable<Integer, JLabel>();
        SimulationRun simulationRun = SimulationRun.simulationRun;
        synchronized (simulationRun) {
            SimulationRun sr = SimulationRun.simulationRun;
            int stateCount = sr.getStateCount();
            double timeStart = sr.getSimulationState((int)0).timestamp;
            double timeEnd = sr.getSimulationState((int)(stateCount - 1)).timestamp;
            double time = timeStart;
            double increment = (timeEnd - timeStart) / 19.0;
            increment = Math.ceil(increment / 10.0) * 10.0;
            while (time < timeEnd - increment * 0.6) {
                labels.put(sr.getLastStateBefore(time), new JLabel(String.valueOf((int)time) + "s"));
                time += increment;
            }
            labels.put(sr.getLastStateBefore(timeEnd), new JLabel(String.valueOf((int)timeEnd) + "s"));
        }
        this.setLabelTable(labels);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paint(Graphics g) {
        SimulationRun simulationRun = SimulationRun.simulationRun;
        synchronized (simulationRun) {
            int max = SimulationRun.simulationRun.getStateCount() - 1;
            if (max != this.getMaximum()) {
                this.setMaximum(max);
                this.updateLabels();
            }
            super.paint(g);
        }
    }
}

