/*
 * Decompiled with CFR 0.152.
 */
package jrobots.pilotlist;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.TreeMap;
import jrobots.graphics.GUI;
import jrobots.pilotlist.LoadedBotClass;
import jrobots.pilotlist.PilotManager;
import jrobots.simulation.SimulationState;
import jrobots.simulation.simulationObjects.AbstractPilot;
import jrobots.simulation.simulationObjects.JRobot;
import jrobots.simulation.simulationObjects.JRobot2007;
import jrobots.simulation.simulationObjects.JRobot2008;
import jrobots.simulation.simulationObjects.JRobot2009;
import jrobots.simulation.simulationObjects.Pilot;
import org.apache.bcel.classfile.ClassParser;
import org.apache.bcel.classfile.Constant;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.JavaClass;

class BotLoader {
    private static String[] badStrings = new String[]{SimulationState.class.getPackage().getName(), Member.class.getPackage().getName(), GUI.class.getPackage().getName()};
    private static String[] goodStrings = new String[]{JRobot.class.getName(), JRobot2007.class.getName(), JRobot2008.class.getName(), JRobot2009.class.getName()};

    static {
        int i = 0;
        while (i < badStrings.length) {
            BotLoader.badStrings[i] = badStrings[i].replace('.', '/');
            ++i;
        }
        i = 0;
        while (i < goodStrings.length) {
            BotLoader.goodStrings[i] = goodStrings[i].replace('.', '/');
            ++i;
        }
    }

    BotLoader() {
    }

    static int loadBots(String botPath, boolean addCheaters, Class<Pilot> optionalClassRestriction) {
        File[] botFiles;
        int numberOfBotClasses = 0;
        File[] fileArray = botFiles = new File(botPath).listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".class");
            }
        });
        int n = botFiles.length;
        int n2 = 0;
        while (n2 < n) {
            File botFile = fileArray[n2];
            try {
                URL url = botFile.getAbsoluteFile().getParentFile().toURI().toURL();
                BotLoader.addURL(url);
                String className = botFile.getName().replace(".class", "");
                if (BotLoader.maybeAddBotClass(className, addCheaters, optionalClassRestriction)) {
                    ++numberOfBotClasses;
                }
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
            ++n2;
        }
        return numberOfBotClasses;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean maybeAddBotClass(String className, boolean addCheaters, Class<Pilot> optionalClassRestriction) {
        if (PilotManager.pilots.get(className) != null) {
            return false;
        }
        LoadedBotClass lbc = new LoadedBotClass();
        try {
            lbc.pilotClass = ClassLoader.getSystemClassLoader().loadClass(className);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            return false;
        }
        if (!Pilot.class.isAssignableFrom(lbc.pilotClass)) {
            return false;
        }
        if (optionalClassRestriction != null && !optionalClassRestriction.isAssignableFrom(lbc.pilotClass)) {
            return false;
        }
        if (Modifier.isAbstract(lbc.pilotClass.getModifiers())) {
            return false;
        }
        try {
            boolean bl = lbc.isCheater = !BotLoader.validateClass(lbc.pilotClass);
            if (!addCheaters && lbc.isCheater) {
                System.err.println("Cheater " + lbc.pilotClass.getName() + " is banned.");
                return false;
            }
        }
        catch (IOException e) {
            System.err.println("Error while reading class file " + lbc.pilotClass.getName() + ":");
            e.printStackTrace();
            return false;
        }
        try {
            Pilot instance = lbc.pilotClass.newInstance();
            ((AbstractPilot)instance).clone();
            if (!BotLoader.testSerializability(instance)) {
                System.out.println(String.valueOf(lbc.pilotClass.getName()) + " does not support serializing");
                return false;
            }
        }
        catch (Exception ex) {
            System.err.println("Error while instantiating/cloning " + lbc.pilotClass.getName() + ":");
            ex.printStackTrace();
            return false;
        }
        TreeMap<String, LoadedBotClass> treeMap = PilotManager.pilots;
        synchronized (treeMap) {
            LoadedBotClass previous = PilotManager.pilots.put(lbc.pilotClass.getName(), lbc);
            int reinsertionCursor = 0;
            while (previous != null) {
                ++reinsertionCursor;
                String elusion = previous.pilotClass.getName();
                int i = 0;
                while (i < reinsertionCursor) {
                    elusion = String.valueOf(elusion) + "'";
                    ++i;
                }
                System.err.println("Bot class name clash: '" + previous.toString() + "' was overwritten! Reinserting as " + elusion);
                previous = PilotManager.pilots.put(String.valueOf(previous.pilotClass.getName()) + "'", previous);
            }
        }
        return true;
    }

    static void addURL(URL url) {
        URLClassLoader sysloader = (URLClassLoader)ClassLoader.getSystemClassLoader();
        try {
            Method method = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
            method.setAccessible(true);
            method.invoke((Object)sysloader, url);
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new RuntimeException("Error, could not add URL to system classloader");
        }
    }

    private static boolean validateClass(Class<?> cls) throws IOException {
        String fileName = String.valueOf(cls.getName().replace(".", System.getProperty("file.separator"))) + ".class";
        InputStream is = ClassLoader.getSystemResourceAsStream(fileName);
        if (is == null) {
            throw new IOException("Could not load the class file \"" + fileName);
        }
        ClassParser cp = new ClassParser(is, fileName);
        JavaClass javaClass = cp.parse();
        ConstantPool constantPool = javaClass.getConstantPool();
        boolean result = true;
        Constant[] constantArray = constantPool.getConstantPool();
        int n = constantArray.length;
        int n2 = 0;
        while (n2 < n) {
            Constant constant = constantArray[n2];
            if (constant != null) {
                String content = constantPool.constantToString(constant);
                boolean isGood = false;
                String[] stringArray = goodStrings;
                int n3 = goodStrings.length;
                int n4 = 0;
                while (n4 < n3) {
                    String good = stringArray[n4];
                    if (constant.toString().contains(good)) {
                        isGood = true;
                    }
                    ++n4;
                }
                if (!isGood) {
                    stringArray = badStrings;
                    n3 = badStrings.length;
                    n4 = 0;
                    while (n4 < n3) {
                        String bad = stringArray[n4];
                        if (constant.toString().contains(bad)) {
                            System.out.println("Cheater: found " + content + " in " + cls.getName());
                            result = false;
                        }
                        ++n4;
                    }
                }
            }
            ++n2;
        }
        return result;
    }

    private static boolean testSerializability(Object candidate) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(candidate);
            byte[] data = baos.toByteArray();
            ByteArrayInputStream bais = new ByteArrayInputStream(data);
            ObjectInputStream ois = new ObjectInputStream(bais);
            ois.readObject();
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            return false;
        }
    }
}

