/*
 * Decompiled with CFR 0.152.
 */
package jrobots.pilotlist;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.List;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import jrobots.pilotlist.BotLoader;
import jrobots.pilotlist.LoadedBotClass;
import jrobots.simulation.simulationObjects.Panzer;
import jrobots.simulation.simulationObjects.Pilot;

public class PilotManager {
    public static final TreeMap<String, LoadedBotClass> pilots = new TreeMap();

    public static void loadBots(String[] botPaths, String restrictionClassName) {
        Class<Pilot> classRestriction;
        try {
            classRestriction = PilotManager.checkClassRestriction(restrictionClassName);
            System.out.println("Bot class restriction: " + restrictionClassName);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("*** given restriction class not found - terminating ***");
        }
        int numberOfBotClasses = 0;
        numberOfBotClasses += PilotManager.addBotsFromDirectory(botPaths, true, classRestriction);
        System.out.println("Number of Bots loaded: " + (numberOfBotClasses += PilotManager.addBotsFromClasspath(true, classRestriction)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int addBotsFromClasspath(boolean addCheaters, Class<Pilot> classRestriction) {
        int numberOfBotClasses = 0;
        TreeMap<String, LoadedBotClass> treeMap = pilots;
        synchronized (treeMap) {
            StringTokenizer stk = new StringTokenizer(System.getProperty("java.class.path"), System.getProperty("path.separator"));
            while (stk.hasMoreTokens()) {
                String botPath = stk.nextToken();
                if (new File(botPath).isDirectory()) {
                    numberOfBotClasses += BotLoader.loadBots(botPath, addCheaters, classRestriction);
                    continue;
                }
                try {
                    ZipFile zipFile = new ZipFile(botPath);
                    Enumeration<? extends ZipEntry> entries = zipFile.entries();
                    while (entries.hasMoreElements()) {
                        ZipEntry zipEntry = entries.nextElement();
                        if (zipEntry.isDirectory() || zipEntry.getName().contains("/") || !zipEntry.getName().endsWith(".class")) continue;
                        String className = zipEntry.getName();
                        if (!BotLoader.maybeAddBotClass(className = className.replace(".class", ""), addCheaters, classRestriction)) continue;
                        ++numberOfBotClasses;
                    }
                }
                catch (IOException e) {
                    System.err.println("Error while trying to load bots from the location " + botPath + ":");
                    e.printStackTrace();
                }
            }
        }
        return numberOfBotClasses;
    }

    public static Class<Pilot> checkClassRestriction(String className) throws ClassNotFoundException {
        if (className == null) {
            return null;
        }
        String pilotPackageName = Pilot.class.getName();
        Class<Pilot> pilotClass = Class.forName(String.valueOf(pilotPackageName = pilotPackageName.substring(0, pilotPackageName.lastIndexOf(Pilot.class.getSimpleName(), pilotPackageName.length()))) + className);
        if (!Pilot.class.isAssignableFrom(pilotClass)) {
            throw new ClassNotFoundException("Pilot restriction class " + className + " is not of correct type.");
        }
        return pilotClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int addBotsFromDirectory(String[] botPaths, boolean addCheaters, Class<Pilot> classRestriction) {
        int numberOfBotClasses = 0;
        TreeMap<String, LoadedBotClass> treeMap = pilots;
        synchronized (treeMap) {
            String[] stringArray = botPaths;
            int n = botPaths.length;
            int n2 = 0;
            while (n2 < n) {
                String botPath = stringArray[n2];
                if (botPath == null || !new File(botPath).isDirectory()) {
                    throw new IllegalStateException("\"" + botPath + "\" is not a valid directory!");
                }
                numberOfBotClasses += BotLoader.loadBots(botPath, addCheaters, classRestriction);
                ++n2;
            }
        }
        return numberOfBotClasses;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateVisibleInstances(List<Panzer> panzers) {
        TreeMap<String, LoadedBotClass> treeMap = pilots;
        synchronized (treeMap) {
            for (LoadedBotClass lbc : pilots.values()) {
                lbc.visibleInstance = null;
            }
            for (Panzer panzer : panzers) {
                Class<?> pilotClass = panzer.getPilot().getClass();
                for (LoadedBotClass lbc : pilots.values()) {
                    if (!pilotClass.equals(lbc.pilotClass)) continue;
                    lbc.visibleInstance = panzer.getPilot();
                }
            }
        }
    }
}

