/*
 * Decompiled with CFR 0.152.
 */
package jrobots.simulation;

import java.util.ArrayList;
import java.util.ListIterator;
import java.util.Random;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import jrobots.simulation.SimulationRun;
import jrobots.simulation.SimulationState;
import jrobots.simulation.simulationObjects.AbstractPilot;
import jrobots.simulation.simulationObjects.Collision;
import jrobots.simulation.simulationObjects.MotionTargetLaunchable;
import jrobots.simulation.simulationObjects.MotionTargetPanzer;
import jrobots.simulation.simulationObjects.Panzer;
import jrobots.simulation.simulationObjects.PilotCommandProcessor;
import jrobots.simulation.simulationObjects.ScanFan;
import jrobots.simulation.simulationObjects.droppables.Droppable;
import jrobots.simulation.simulationObjects.launchables.Launchable;
import jrobots.utils.Angle;
import jrobots.utils.ProximityScan;
import jrobots.utils.Scan;
import jrobots.utils.SonarTrace;
import jrobots.utils.Vector;

public final class Simulation {
    static PilotCommandProcessor pilotCommandProcessor;
    public static final Random random;

    static {
        random = new Random();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void progress(SimulationState state, double elapsedTime) {
        SimulationRun simulationRun = SimulationRun.simulationRun;
        synchronized (simulationRun) {
            for (Panzer panzer : state.panzers) {
                panzer.chargeEnergy(0.3 * elapsedTime);
            }
            for (Panzer panzer : state.panzers) {
                double sonarEnergy;
                panzer.setProximityScanLaunchable(Simulation.performProximityScanLaunchable(state, panzer));
                panzer.setProximityScanDroppable(Simulation.performProximityScanDroppable(state, panzer));
                Angle scanCommand = panzer.getScanDirection();
                if (scanCommand != null && panzer.depleteEnergyBulky(0.00384)) {
                    Angle scanAperture = panzer.getScanAperture().mult(0.5);
                    SortedMap<Double, Panzer> scanResult = Simulation.performScan(state, panzer, scanCommand.sub(scanAperture).normalize(), scanCommand.add(scanAperture).normalize());
                    double distanceToTarget = scanResult.size() > 0 ? scanResult.firstKey() : 0.0;
                    Scan lastScan = new Scan(scanCommand, scanAperture.mult(2.0), distanceToTarget, panzer.getPos(), state.timestamp);
                    panzer.setLastScan(lastScan);
                }
                if (!((sonarEnergy = panzer.getSonarEnergy()) > 0.0)) continue;
                sonarEnergy = panzer.depleteEnergyFlexibly(sonarEnergy);
                Panzer nearestTarget = null;
                double nearestDistance = Double.MAX_VALUE;
                for (Panzer target : state.panzers) {
                    double distance;
                    if (panzer.getID() == target.getID() || !((distance = panzer.getPos().distanceTo(target.getPos())) < nearestDistance)) continue;
                    nearestTarget = target;
                    nearestDistance = distance;
                }
                double stdDev = 0.15 / sonarEnergy;
                if (nearestTarget == null) continue;
                Vector targetPos = nearestTarget.getPos();
                SonarTrace sonarTrace = new SonarTrace(state.timestamp, new Vector(targetPos.getX() + stdDev * random.nextGaussian(), targetPos.getY() + stdDev * random.nextGaussian()), stdDev);
                panzer.setLastSonarTrace(sonarTrace);
                state.simulationRun.addSonarTrace(sonarTrace.timestamp, sonarTrace);
            }
            int i = 0;
            while (i < state.panzers.size()) {
                Panzer panzer;
                panzer = state.panzers.get(i);
                ++i;
                if (pilotCommandProcessor == null) {
                    pilotCommandProcessor = new PilotCommandProcessor();
                    pilotCommandProcessor.start();
                }
                while (!pilotCommandProcessor.isAlive()) {
                    Thread.yield();
                }
                try {
                    long waitTime;
                    pilotCommandProcessor.newJob(panzer, state.timestamp, Thread.currentThread());
                    long nanoTime = System.nanoTime();
                    do {
                        if ((waitTime = 50000000L - (System.nanoTime() - nanoTime)) <= 0L) continue;
                        PilotCommandProcessor pilotCommandProcessor = Simulation.pilotCommandProcessor;
                        synchronized (pilotCommandProcessor) {
                            Simulation.pilotCommandProcessor.wait(waitTime / 1000000L, (int)(waitTime % 1000000L));
                        }
                    } while ((waitTime = System.nanoTime() - nanoTime) < 50000000L && !pilotCommandProcessor.isJobDone());
                    if (pilotCommandProcessor.isJobDone()) continue;
                    pilotCommandProcessor.interrupt();
                    pilotCommandProcessor = null;
                    AbstractPilot abstractPilot = panzer.getPilot();
                    if (abstractPilot != null) {
                        AbstractPilot abstractPilot2 = panzer.attachNewPilot((AbstractPilot)abstractPilot.getClass().newInstance(), 0.0);
                        panzer.init(state.timestamp);
                        SimulationRun.simulationRun.getGraveyard().put(state.timestamp, abstractPilot2);
                        System.out.println("Processing of " + abstractPilot2.getClass().getSimpleName() + " hangs, replacing Pilot (" + waitTime / 1000L + " microseconds).");
                        continue;
                    }
                    state.panzers.remove(i);
                    --i;
                    SimulationRun.simulationRun.getWasteDump().put(state.timestamp, panzer);
                    System.out.println("Empty panzer convicted of dilatoriness for " + waitTime / 1000L + " microseconds, is conveyed to the waste dump.");
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
                catch (InstantiationException instantiationException) {
                    instantiationException.printStackTrace();
                }
                catch (IllegalAccessException illegalAccessException) {
                    illegalAccessException.printStackTrace();
                }
            }
            for (Panzer panzer : state.panzers) {
                Droppable[] newDrop;
                Launchable[] newLaunch = panzer.launch(state.timestamp);
                if (newLaunch != null) {
                    int i2 = 0;
                    while (i2 < newLaunch.length) {
                        state.projectiles.add(newLaunch[i2]);
                        state.simulationRun.getTurret(panzer.turretIndex).put(state.timestamp, newLaunch[i2].getOrientation());
                        ++i2;
                    }
                }
                if ((newDrop = panzer.drop(state.timestamp)) != null) {
                    int i3 = 0;
                    while (i3 < newDrop.length) {
                        state.droppables.add(newDrop[i3]);
                        ++i3;
                    }
                }
                panzer.activateLinkToDirectables();
            }
            ArrayList<MotionTargetPanzer> panzerTargets = new ArrayList<MotionTargetPanzer>();
            for (Panzer panzer : state.panzers) {
                panzerTargets.add(panzer.calculateMotion(elapsedTime));
            }
            ArrayList<MotionTargetLaunchable> projectileTargets = new ArrayList<MotionTargetLaunchable>();
            for (Launchable projectile : state.projectiles) {
                projectileTargets.add(projectile.calculateMotion(state, elapsedTime));
            }
            for (Droppable mine : state.droppables) {
                mine.calculateMotion(state, elapsedTime);
                for (MotionTargetPanzer motionTargetPanzer : panzerTargets) {
                    mine.checkTrigger(state, motionTargetPanzer);
                }
            }
            TreeSet<Collision> collisions = new TreeSet<Collision>();
            collisions.addAll(Collision.discoverCollisions(panzerTargets, projectileTargets, state.droppables));
            while (!collisions.isEmpty()) {
                Collision collision = (Collision)collisions.first();
                collision.react(state, panzerTargets);
                collisions.remove(collision);
                collision.rediscoverCollisions(collisions, panzerTargets, projectileTargets);
            }
            for (MotionTargetPanzer motionTargetPanzer : panzerTargets) {
                motionTargetPanzer.commitToPanzer();
            }
            for (MotionTargetLaunchable motionTargetLaunchable : projectileTargets) {
                motionTargetLaunchable.commitToProjectile();
            }
            ListIterator<Launchable> it = state.projectiles.listIterator();
            while (it.hasNext()) {
                Launchable launchable = (Launchable)it.next();
                if (!(launchable.getAge() > launchable.LIFE_TIME())) continue;
                it.remove();
            }
            ListIterator<Panzer> it2 = state.panzers.listIterator();
            while (it2.hasNext()) {
                Panzer panzer = (Panzer)it2.next();
                if (!(panzer.getHealth() < 0.0)) continue;
                it2.remove();
                state.simulationRun.getWasteDump().put(state.timestamp, panzer);
            }
            ListIterator<Droppable> it3 = state.droppables.listIterator();
            while (it3.hasNext()) {
                Droppable mine = (Droppable)it3.next();
                if (!(mine.getAge() > mine.getMaxAge()) && !mine.isDetonating()) continue;
                it3.remove();
            }
            for (Panzer panzer : state.panzers) {
                panzer.resetPhysics();
            }
            state.timestamp += elapsedTime;
        }
    }

    private static SortedMap<Double, Panzer> performScan(SimulationState state, Panzer scanner, Angle leftAngle, Angle rightAngle) {
        TreeMap<Double, Panzer> resultMap = new TreeMap<Double, Panzer>();
        for (Panzer panzer : state.panzers) {
            if (panzer != scanner) {
                Vector distanceVector = panzer.getPos().sub(scanner.getPos());
                double targetAngleDEG = distanceVector.getAngle().normalize().getValueAsDegrees();
                if (leftAngle.getValueAsDegrees() > rightAngle.getValueAsDegrees() && (leftAngle.getValueAsDegrees() <= targetAngleDEG || rightAngle.getValueAsDegrees() >= targetAngleDEG) || leftAngle.getValueAsDegrees() <= targetAngleDEG && rightAngle.getValueAsDegrees() >= targetAngleDEG) {
                    resultMap.put(distanceVector.getLength(), panzer);
                }
            }
            ScanFan newScanFan = new ScanFan(scanner.getPos(), leftAngle, rightAngle, resultMap.size() > 0 ? (Double)resultMap.firstKey() : -1.0, state.timestamp);
            state.simulationRun.addScanFan(state.timestamp, newScanFan);
            assert (state.simulationRun.getScanFansAt(state.timestamp).size() > 0);
        }
        return resultMap;
    }

    private static ProximityScan performProximityScanLaunchable(SimulationState state, Panzer scanner) {
        double minDistance = Double.MAX_VALUE;
        ProximityScan proximityScan = null;
        for (Launchable launchable : state.projectiles) {
            double tmpDist;
            if (launchable.getOwnerID() == scanner.getID() || !((tmpDist = scanner.getPos().distanceTo(launchable.getPos())) <= 50.0) || !(tmpDist < minDistance)) continue;
            minDistance = tmpDist;
            proximityScan = new ProximityScan(launchable.getPos(), launchable.getVelocity(), state.timestamp);
        }
        return proximityScan;
    }

    private static Vector performProximityScanDroppable(SimulationState state, Panzer scanner) {
        double minDistance = Double.MAX_VALUE;
        Vector proximityPos = null;
        for (Droppable droppable : state.droppables) {
            double tmpDist;
            if (!droppable.isArmed() || !((tmpDist = scanner.getPos().distanceTo(droppable.getPos())) <= 18.0) || !(tmpDist < minDistance)) continue;
            minDistance = tmpDist;
            proximityPos = droppable.getPos();
        }
        return proximityPos;
    }
}

