/*
 * Decompiled with CFR 0.152.
 */
package jrobots.simulation;

import jrobots.graphics.GUI;
import jrobots.simulation.Simulation;
import jrobots.simulation.SimulationRun;
import jrobots.simulation.SimulationState;

public class SimulationController
extends Thread {
    private static boolean isRunning = false;
    public static SimulationController controller = null;
    public static double simulationIntervalDuration = 0.04;
    public static long simulationRecalculationInterval = (long)(simulationIntervalDuration * 1000.0 / 10.0);
    public SimulationState currentState = null;
    private static double timeLimit = Double.MAX_VALUE;

    protected SimulationController() {
        this.setDaemon(true);
        this.setPriority(1);
        this.setName(this.getClass().getSimpleName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            while (isRunning) {
                SimulationRun simulationRun = SimulationRun.simulationRun;
                synchronized (simulationRun) {
                    double elapsedTime;
                    SimulationRun sr = SimulationRun.simulationRun;
                    if (sr.getStateCount() <= 0) {
                        isRunning = false;
                        throw new RuntimeException("SimulationController: No simulation state available. Prepare simulation run before trying to simulate.");
                    }
                    SimulationState currentState = sr.getSimulationState(sr.getStateCount() - 1).deepCopy();
                    double absoluteTime = elapsedTime = simulationIntervalDuration;
                    if (currentState != null) {
                        absoluteTime += currentState.timestamp;
                    }
                    this.currentState = currentState;
                    Simulation.progress(currentState, elapsedTime);
                    this.currentState = null;
                    sr.appendState(currentState);
                    if (currentState.getPanzers().size() < 2 && sr.getSimulationState(sr.getStateCount() - 2).getPanzers().size() >= 2 || absoluteTime >= timeLimit) {
                        SimulationController.setRunning(false, timeLimit);
                    }
                }
                if (GUI.gui != null) {
                    GUI.gui.timelineSlider.repaint();
                    GUI.gui.arena.repaint();
                }
                SimulationController.sleep(simulationRecalculationInterval);
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public static synchronized SimulationController setRunning(boolean running, double timeLimit) {
        SimulationController.timeLimit = timeLimit;
        if (running != isRunning) {
            if (running) {
                isRunning = true;
                controller = new SimulationController();
                controller.start();
                return controller;
            }
            isRunning = false;
            if (GUI.gui != null) {
                GUI.gui.buttonSimulate.repaint();
            }
        }
        return null;
    }

    public static synchronized boolean isRunning() {
        return isRunning;
    }
}

