/*
 * Decompiled with CFR 0.152.
 */
package jrobots.simulation;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import jrobots.graphics.Particle;
import jrobots.simulation.SimulationState;
import jrobots.simulation.simulationObjects.AbstractPilot;
import jrobots.simulation.simulationObjects.Explosion;
import jrobots.simulation.simulationObjects.Panzer;
import jrobots.simulation.simulationObjects.PilotZombie;
import jrobots.simulation.simulationObjects.ScanFan;
import jrobots.utils.Angle;
import jrobots.utils.SonarTrace;
import jrobots.utils.Vector;

public class SimulationRun
implements Serializable {
    private static final long serialVersionUID = 3440426208985554858L;
    public static SimulationRun simulationRun = null;
    private ArrayList<SimulationState> states = new ArrayList();
    private TreeMap<Double, Explosion> explosions = new TreeMap();
    private TreeMap<Double, Panzer> wasteDump = new TreeMap();
    private TreeMap<Double, AbstractPilot> graveyard = new TreeMap();
    private ArrayList<TreeMap<Double, Angle>> turrets = new ArrayList();
    private TreeMap<Double, ScanFan> scanfans = new TreeMap();
    private TreeMap<Double, SonarTrace> sonarTraces = new TreeMap();
    private TreeMap<Double, Particle> smokeParticles = new TreeMap();
    private TreeMap<Double, Particle> explosionParticles = new TreeMap();

    static {
        simulationRun = new SimulationRun();
    }

    SimulationRun() {
        SimulationState state = new SimulationState(this, 0.0);
        this.states.add(state);
    }

    synchronized int createNewTurretIndex() {
        TreeMap turret = new TreeMap();
        this.turrets.add(turret);
        return this.turrets.size() - 1;
    }

    public synchronized TreeMap<Double, Angle> getTurret(int index) {
        return this.turrets.get(index);
    }

    synchronized SortedMap<Double, Explosion> getExplosionsAt(double timestamp) {
        return this.explosions.subMap(timestamp - 0.8, true, timestamp, true);
    }

    synchronized SortedMap<Double, Particle> getSmokeParticlesAt(double timestamp) {
        return this.smokeParticles.subMap(timestamp - 2.0, true, timestamp, true);
    }

    public synchronized void addSmokeParticle(Vector position, Vector speed, double creationTime) {
        if (this.smokeParticles.get(creationTime) != null) {
            this.addSmokeParticle(position, speed, creationTime + Math.random() * 1.0E-5);
            return;
        }
        Particle particle = new Particle(position, speed, creationTime);
        this.smokeParticles.put(creationTime, particle);
    }

    synchronized SortedMap<Double, Particle> getExplosionParticlesAt(double timestamp) {
        return this.explosionParticles.subMap(timestamp - 0.8, true, timestamp, true);
    }

    public synchronized void addExplosionParticle(Vector position, Vector speed, double creationTime) {
        if (this.explosionParticles.get(creationTime) != null) {
            this.addExplosionParticle(position, speed, creationTime + Math.random() * 1.0E-5);
            return;
        }
        Particle particle = new Particle(position, speed, creationTime);
        this.explosionParticles.put(creationTime, particle);
    }

    synchronized SortedMap<Double, ScanFan> getScanFansAt(double timestamp) {
        return this.scanfans.subMap(timestamp - 0.5, true, timestamp, true);
    }

    public synchronized void addScanFan(double key, ScanFan value) {
        if (this.scanfans.get(key) != null) {
            this.addScanFan(key + Math.random() * 1.0E-5, value);
            return;
        }
        this.scanfans.put(key, value);
    }

    synchronized SortedMap<Double, SonarTrace> getSonarTracesAt(double timestamp) {
        return this.sonarTraces.subMap(timestamp - 1.5, true, timestamp, true);
    }

    public synchronized void addSonarTrace(double key, SonarTrace value) {
        if (this.sonarTraces.get(key) != null) {
            this.addSonarTrace(key + Math.random() * 1.0E-5, value);
            return;
        }
        this.sonarTraces.put(key, value);
    }

    public synchronized SimulationState getSimulationState(int index) {
        return this.states.get(index);
    }

    public synchronized void cropAfter(int index) {
        double cropTime = this.states.get((int)index).timestamp;
        int i = this.states.size() - 1;
        while (i > index) {
            this.states.remove(i);
            --i;
        }
        while (!this.explosions.isEmpty() && this.explosions.lastKey() > cropTime) {
            this.explosions.remove(this.explosions.lastKey());
        }
        while (!this.scanfans.isEmpty() && this.scanfans.lastKey() > cropTime) {
            this.scanfans.remove(this.scanfans.lastKey());
        }
        while (!this.sonarTraces.isEmpty() && this.sonarTraces.lastKey() > cropTime) {
            this.sonarTraces.remove(this.sonarTraces.lastKey());
        }
        while (!this.smokeParticles.isEmpty() && this.smokeParticles.lastKey() > cropTime) {
            this.smokeParticles.remove(this.smokeParticles.lastKey());
        }
        while (!this.explosionParticles.isEmpty() && this.explosionParticles.lastKey() > cropTime) {
            this.explosionParticles.remove(this.explosionParticles.lastKey());
        }
        while (!this.graveyard.isEmpty() && this.graveyard.lastKey() > cropTime) {
            this.graveyard.remove(this.graveyard.lastKey());
        }
        while (!this.wasteDump.isEmpty() && this.wasteDump.lastKey() > cropTime) {
            this.wasteDump.remove(this.wasteDump.lastKey());
        }
        for (TreeMap<Double, Angle> turret : this.turrets) {
            while (!turret.isEmpty() && turret.lastKey() > cropTime) {
                turret.remove(turret.lastKey());
            }
        }
    }

    public synchronized void appendState(SimulationState state) {
        this.states.add(state);
    }

    public synchronized int getStateCount() {
        return this.states.size();
    }

    public synchronized int getLastStateBefore(double timestamp) {
        int upper = this.states.size() - 1;
        int lower = 0;
        do {
            int index = (upper + lower) / 2;
            if (timestamp <= this.states.get((int)index).timestamp) {
                upper = index;
                continue;
            }
            lower = index;
        } while (upper - lower > 1);
        return upper;
    }

    public TreeMap<Double, Panzer> getWasteDump() {
        return this.wasteDump;
    }

    public TreeMap<Double, AbstractPilot> getGraveyard() {
        return this.graveyard;
    }

    public SimulationRun anonymizedClone() throws IOException, ClassNotFoundException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(bos);
        oos.writeObject(this);
        SimulationRun cloneRun = (SimulationRun)new ObjectInputStream(new ByteArrayInputStream(bos.toByteArray())).readObject();
        for (SimulationState simulationState : cloneRun.states) {
            for (Panzer panzer : simulationState.panzers) {
                panzer.zombificatePilot();
            }
        }
        for (Map.Entry entry : cloneRun.graveyard.entrySet()) {
            cloneRun.graveyard.put((Double)entry.getKey(), new PilotZombie((AbstractPilot)entry.getValue()));
        }
        for (Map.Entry entry : cloneRun.wasteDump.entrySet()) {
            ((Panzer)entry.getValue()).attachNewPilot(new PilotZombie(((Panzer)entry.getValue()).getPilot()), 0.0);
        }
        return cloneRun;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        for (SimulationState state : this.states) {
            state.simulationRun = this;
        }
    }
}

