/*
 * Decompiled with CFR 0.152.
 */
package jrobots.simulation;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import jrobots.graphics.Particle;
import jrobots.simulation.SimulationRun;
import jrobots.simulation.simulationObjects.AbstractPilot;
import jrobots.simulation.simulationObjects.Explosion;
import jrobots.simulation.simulationObjects.Panzer;
import jrobots.simulation.simulationObjects.Pilot;
import jrobots.simulation.simulationObjects.ScanFan;
import jrobots.simulation.simulationObjects.droppables.Droppable;
import jrobots.simulation.simulationObjects.launchables.Launchable;
import jrobots.utils.Angle;
import jrobots.utils.SonarTrace;
import jrobots.utils.Vector;

public class SimulationState
implements Serializable {
    private static final long serialVersionUID = 8776331926803886654L;
    public double timestamp;
    transient SimulationRun simulationRun;
    List<Panzer> panzers = new ArrayList<Panzer>();
    List<Launchable> projectiles = new ArrayList<Launchable>();
    List<Droppable> droppables = new ArrayList<Droppable>();

    SimulationState(SimulationRun simulationRun, double timestamp) {
        this.simulationRun = simulationRun;
        this.timestamp = timestamp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createNewPanzer(Class<? extends Pilot> pilotClass) throws InstantiationException, IllegalAccessException {
        SimulationRun simulationRun = SimulationRun.simulationRun;
        synchronized (simulationRun) {
            Panzer panzer;
            Pilot pilot = pilotClass.newInstance();
            int turretIndex = this.simulationRun.createNewTurretIndex();
            TreeMap<Double, Angle> turret = this.simulationRun.getTurret(turretIndex);
            Vector pos = null;
            Angle ori = null;
            if (this.panzers.size() == 1) {
                panzer = this.panzers.get(0);
                pos = new Vector(Math.random() * 100.0 - 50.0, Math.random() * 100.0 - 50.0);
                Angle heading = panzer.getPos().sub(pos).getAngle();
                Angle offset12Clock = panzer.getOrientation().sub(heading);
                ori = heading.getOpposite().sub(offset12Clock);
            }
            panzer = new Panzer(pilot, turretIndex, pos, ori);
            turret.put(this.timestamp, panzer.getOrientation());
            this.panzers.add(panzer);
            panzer.init(this.timestamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createNewPanzer(Class<? extends Pilot> pilotClass, Vector pos, Angle orientation) throws InstantiationException, IllegalAccessException {
        SimulationRun simulationRun = SimulationRun.simulationRun;
        synchronized (simulationRun) {
            Pilot pilot = pilotClass.newInstance();
            int turretIndex = this.simulationRun.createNewTurretIndex();
            TreeMap<Double, Angle> turret = this.simulationRun.getTurret(turretIndex);
            Panzer panzer = new Panzer(pilot, turretIndex, pos, orientation);
            turret.put(this.timestamp, panzer.getOrientation());
            this.panzers.add(panzer);
        }
    }

    public List<Panzer> getPanzers() {
        return this.panzers;
    }

    public Panzer getPanzerByID(int ID) {
        for (Panzer panzer : this.panzers) {
            if (panzer.getID() != ID) continue;
            return panzer;
        }
        return null;
    }

    public SortedMap<Double, Panzer> getWastedump() {
        if (this.simulationRun == null) {
            return new TreeMap<Double, Panzer>();
        }
        return this.simulationRun.getWasteDump().subMap(0.0, true, this.timestamp, true);
    }

    public List<Launchable> getProjectiles() {
        return this.projectiles;
    }

    public List<Droppable> getMines() {
        return this.droppables;
    }

    public SortedMap<Double, Explosion> getExplosions() {
        return this.simulationRun.getExplosionsAt(this.timestamp);
    }

    public SortedMap<Double, Particle> getSmokeParticles() {
        return this.simulationRun.getSmokeParticlesAt(this.timestamp);
    }

    public SortedMap<Double, Particle> getExplosionParticles() {
        return this.simulationRun.getExplosionParticlesAt(this.timestamp);
    }

    public SortedMap<Double, ScanFan> getScanFans() {
        return this.simulationRun.getScanFansAt(this.timestamp);
    }

    public SortedMap<Double, SonarTrace> getSonarTraces() {
        return this.simulationRun.getSonarTracesAt(this.timestamp);
    }

    public SimulationState deepCopy() {
        SimulationState result = SimulationState.deepCopy(this);
        result.simulationRun = this.simulationRun;
        return result;
    }

    public void removePilots(Class<? extends AbstractPilot> pilotClass) {
        Iterator<Panzer> it = this.panzers.iterator();
        while (it.hasNext()) {
            if (!it.next().getPilot().getClass().equals(pilotClass)) continue;
            it.remove();
        }
    }

    public static <T extends Serializable> T deepCopy(T copyObject) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream(4096);
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(copyObject);
            ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
            ObjectInputStream ois = new ObjectInputStream(bais);
            Serializable deepCopy = (Serializable)ois.readObject();
            return (T)deepCopy;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        return null;
    }
}

