/*
 * Decompiled with CFR 0.152.
 */
package jrobots.simulation.simulationObjects;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import jrobots.simulation.SimulationState;
import jrobots.simulation.simulationObjects.CollisionPanzerArena;
import jrobots.simulation.simulationObjects.CollisionPanzerPanzer;
import jrobots.simulation.simulationObjects.MotionTargetLaunchable;
import jrobots.simulation.simulationObjects.MotionTargetPanzer;
import jrobots.simulation.simulationObjects.droppables.Droppable;

public abstract class Collision
implements Comparable<Collision> {
    protected double timeInFrame;
    private static int collisionNum = 0;
    private final int num = collisionNum++;

    public double getTimeInFrame() {
        return this.timeInFrame;
    }

    @Override
    public int compareTo(Collision o) {
        return this.num - o.num;
    }

    public static Collection<Collision> discoverCollisions(List<MotionTargetPanzer> panzerTargets, List<MotionTargetLaunchable> projectileTargets, List<Droppable> droppables) {
        Collision collision;
        LinkedList<Collision> collisions = new LinkedList<Collision>();
        for (MotionTargetLaunchable projTgt : projectileTargets) {
            for (Droppable droppable : droppables) {
                collision = droppable.discoverCollision(projTgt);
                if (collision == null) continue;
                while (!collisions.add(collision)) {
                    collision.timeInFrame += 1.0E-7;
                }
            }
        }
        for (MotionTargetPanzer panzerTgt : panzerTargets) {
            for (MotionTargetLaunchable projTgt : projectileTargets) {
                collision = projTgt.inceptor.discoverCollision(projTgt, panzerTgt);
                if (collision == null) continue;
                while (!collisions.add(collision)) {
                    collision.timeInFrame += 1.0E-7;
                }
            }
            for (Droppable droppable : droppables) {
                collision = droppable.discoverCollision(panzerTgt);
                if (collision == null) continue;
                while (!collisions.add(collision)) {
                    collision.timeInFrame += 1.0E-7;
                }
            }
            for (MotionTargetPanzer panzerTgt2 : panzerTargets) {
                collision = CollisionPanzerPanzer.discoverCollision(panzerTgt, panzerTgt2);
                if (collision == null) continue;
                while (!collisions.add(collision)) {
                    collision.timeInFrame += 1.0E-7;
                }
            }
            for (MotionTargetPanzer panzerTgt2 : panzerTargets) {
                collision = CollisionPanzerArena.discoverCollision(panzerTgt, panzerTgt2);
                if (collision == null) continue;
                while (!collisions.add(collision)) {
                    collision.timeInFrame += 1.0E-7;
                }
            }
        }
        return collisions;
    }

    public Collection<Collision> rediscoverCollisions(Collection<Collision> collisions, ArrayList<MotionTargetPanzer> panzerTargets, ArrayList<MotionTargetLaunchable> projectileTargets) {
        return collisions;
    }

    public abstract void react(SimulationState var1, ArrayList<MotionTargetPanzer> var2);
}

