/*
 * Decompiled with CFR 0.152.
 */
package jrobots.simulation.simulationObjects;

import java.util.ArrayList;
import jrobots.simulation.SimulationState;
import jrobots.simulation.simulationObjects.Collision;
import jrobots.simulation.simulationObjects.MotionTargetPanzer;
import jrobots.utils.Vector;

public class CollisionPanzerArena
extends Collision {
    MotionTargetPanzer colliderTgt;
    MotionTargetPanzer collPartner;

    public CollisionPanzerArena(MotionTargetPanzer colliderTgt, MotionTargetPanzer collPartner, double time) {
        this.colliderTgt = colliderTgt;
        this.collPartner = collPartner;
        this.timeInFrame = time;
    }

    @Override
    public void react(SimulationState state, ArrayList<MotionTargetPanzer> panzerTargets) {
        this.colliderTgt.inceptor.exertForce(new Vector(0.0, 0.0), new Vector(this.collPartner.endPos.sub(this.colliderTgt.endPos).getAngle(), 1000000.0));
        this.collPartner.inceptor.exertForce(new Vector(0.0, 0.0), new Vector(this.colliderTgt.endPos.sub(this.collPartner.endPos).getAngle(), 1000000.0));
        panzerTargets.remove(this.colliderTgt);
        panzerTargets.remove(this.collPartner);
        this.colliderTgt = MotionTargetPanzer.update(this.colliderTgt);
        this.collPartner = MotionTargetPanzer.update(this.collPartner);
        panzerTargets.add(this.colliderTgt);
        panzerTargets.add(this.collPartner);
        this.colliderTgt.collidedPanzers.add(this.collPartner.inceptor);
        this.collPartner.collidedPanzers.add(this.colliderTgt.inceptor);
    }

    static CollisionPanzerArena discoverCollision(MotionTargetPanzer colliderTgt, MotionTargetPanzer collPartner) {
        if (colliderTgt == collPartner) {
            return null;
        }
        if (colliderTgt.collidedPanzers.contains(collPartner)) {
            return null;
        }
        if (colliderTgt.endPos.distanceTo(collPartner.endPos) > 100.0) {
            return new CollisionPanzerArena(colliderTgt, collPartner, 0.0);
        }
        return null;
    }
}

