/*
 * Decompiled with CFR 0.152.
 */
package jrobots.simulation.simulationObjects;

import java.util.ArrayList;
import jrobots.simulation.SimulationState;
import jrobots.simulation.simulationObjects.Collision;
import jrobots.simulation.simulationObjects.MotionTargetPanzer;
import jrobots.utils.Vector;

public class CollisionPanzerExplosion
extends Collision {
    private MotionTargetPanzer panzerTgt;
    private Vector pos;
    private double outerRadius;
    private double innerRadius;
    private double maxDamage;
    private double maxForce;

    public CollisionPanzerExplosion(MotionTargetPanzer panzerTgt, Vector explosionPos, double outerRadius, double innerRadius, double maxDamage, double maxForce) {
        this.panzerTgt = panzerTgt;
        this.pos = explosionPos;
        this.outerRadius = outerRadius;
        this.innerRadius = innerRadius;
        this.maxDamage = maxDamage;
        this.maxForce = maxForce;
    }

    @Override
    public void react(SimulationState state, ArrayList<MotionTargetPanzer> panzerTargets) {
        double damagePct = 1.0 - (this.panzerTgt.calculateCenterDistance(this.pos) - this.innerRadius) / (this.outerRadius - this.innerRadius);
        if (damagePct <= 0.0) {
            return;
        }
        if (damagePct >= 1.0) {
            damagePct = 1.0;
        }
        this.panzerTgt.getInceptor().setHealth(this.panzerTgt.getInceptor().getHealth() - this.maxDamage * damagePct);
        this.panzerTgt.getInceptor().exertForce(new Vector(), this.panzerTgt.getInceptor().getPos().sub(this.pos).getNormal().mult(damagePct * this.maxForce));
        panzerTargets.remove(this.panzerTgt);
        this.panzerTgt = MotionTargetPanzer.update(this.panzerTgt);
        panzerTargets.add(this.panzerTgt);
    }
}

