/*
 * Decompiled with CFR 0.152.
 */
package jrobots.simulation.simulationObjects;

import java.util.ArrayList;
import jrobots.simulation.SimulationState;
import jrobots.simulation.simulationObjects.Collision;
import jrobots.simulation.simulationObjects.Explosion;
import jrobots.simulation.simulationObjects.MotionTargetLaunchable;
import jrobots.simulation.simulationObjects.MotionTargetPanzer;
import jrobots.simulation.simulationObjects.Panzer;
import jrobots.simulation.simulationObjects.launchables.Launchable;
import jrobots.utils.Vector;

public class CollisionPanzerLaunchable
extends Collision {
    private MotionTargetPanzer panzerTgt;
    private MotionTargetLaunchable projTgt;
    private MotionTargetPanzer.PanzerSide side;

    @Override
    public void react(SimulationState state, ArrayList<MotionTargetPanzer> panzerTargets) {
        switch (this.side) {
            case FRONT: {
                this.panzerTgt.inceptor.setHealth(this.panzerTgt.inceptor.getHealth() - this.projTgt.inceptor.DAMAGE_FRONT());
                state.getExplosions().put(state.timestamp, new Explosion(this.projTgt.inceptor.getPos(), this.panzerTgt.inceptor.getOrientation(), state.timestamp, this.projTgt.inceptor.EXPLOSION_SIZE()));
                this.panzerTgt.inceptor.exertForce(MotionTargetPanzer.PanzerSide.FRONT, new Vector(this.panzerTgt.inceptor.getOrientation().getOpposite(), this.projTgt.inceptor.FORCE_HIT()));
                break;
            }
            case RIGHT: {
                this.panzerTgt.inceptor.setHealth(this.panzerTgt.inceptor.getHealth() - this.projTgt.inceptor.DAMAGE_SIDE());
                state.getExplosions().put(state.timestamp, new Explosion(this.projTgt.inceptor.getPos(), this.panzerTgt.inceptor.getOrientation().getNextQuadrant(), state.timestamp, this.projTgt.inceptor.EXPLOSION_SIZE()));
                this.panzerTgt.inceptor.exertForce(MotionTargetPanzer.PanzerSide.RIGHT, new Vector(this.panzerTgt.inceptor.getOrientation().getPreviousQuadrant(), this.projTgt.inceptor.FORCE_HIT()));
                break;
            }
            case LEFT: {
                this.panzerTgt.inceptor.setHealth(this.panzerTgt.inceptor.getHealth() - this.projTgt.inceptor.DAMAGE_SIDE());
                state.getExplosions().put(state.timestamp, new Explosion(this.projTgt.inceptor.getPos(), this.panzerTgt.inceptor.getOrientation().getPreviousQuadrant(), state.timestamp, this.projTgt.inceptor.EXPLOSION_SIZE()));
                this.panzerTgt.inceptor.exertForce(MotionTargetPanzer.PanzerSide.LEFT, new Vector(this.panzerTgt.inceptor.getOrientation().getNextQuadrant(), this.projTgt.inceptor.FORCE_HIT()));
                break;
            }
            case REAR: {
                this.panzerTgt.inceptor.setHealth(this.panzerTgt.inceptor.getHealth() - this.projTgt.inceptor.DAMAGE_REAR());
                state.getExplosions().put(state.timestamp, new Explosion(this.projTgt.inceptor.getPos(), this.panzerTgt.inceptor.getOrientation().getOpposite(), state.timestamp, this.projTgt.inceptor.EXPLOSION_SIZE()));
                this.panzerTgt.inceptor.exertForce(MotionTargetPanzer.PanzerSide.REAR, new Vector(this.panzerTgt.inceptor.getOrientation(), this.projTgt.inceptor.FORCE_HIT()));
                break;
            }
            default: {
                this.panzerTgt.inceptor.setHealth(this.panzerTgt.inceptor.getHealth() + 1.0);
            }
        }
        panzerTargets.remove(this.panzerTgt);
        this.panzerTgt = MotionTargetPanzer.update(this.panzerTgt);
        panzerTargets.add(this.panzerTgt);
        state.getProjectiles().remove(this.projTgt.inceptor);
        this.projTgt.inceptor.detonate();
    }

    CollisionPanzerLaunchable(double time, MotionTargetPanzer panzerTgt, MotionTargetLaunchable projTgt, MotionTargetPanzer.PanzerSide side) {
        this.timeInFrame = time;
        this.panzerTgt = panzerTgt;
        this.projTgt = projTgt;
        this.side = side;
    }

    Panzer getPanzer() {
        return this.panzerTgt.inceptor;
    }

    Launchable getLaunchable() {
        return this.projTgt.inceptor;
    }

    public static CollisionPanzerLaunchable discoverCollision(MotionTargetPanzer panzerTgt, MotionTargetLaunchable projTgt) {
        double[] collisionTimes = new double[]{panzerTgt.calculateCollisionTime(projTgt, MotionTargetPanzer.PanzerSide.FRONT), panzerTgt.calculateCollisionTime(projTgt, MotionTargetPanzer.PanzerSide.RIGHT), panzerTgt.calculateCollisionTime(projTgt, MotionTargetPanzer.PanzerSide.REAR), panzerTgt.calculateCollisionTime(projTgt, MotionTargetPanzer.PanzerSide.LEFT)};
        assert (collisionTimes[0] >= -1.0E-7) : collisionTimes[0];
        assert (collisionTimes[1] >= -1.0E-7) : collisionTimes[1];
        assert (collisionTimes[2] >= -1.0E-7) : collisionTimes[2];
        assert (collisionTimes[3] >= -1.0E-7) : collisionTimes[3];
        double collisionTime = collisionTimes[0];
        MotionTargetPanzer.PanzerSide side = MotionTargetPanzer.PanzerSide.FRONT;
        if (collisionTimes[1] < collisionTime) {
            collisionTime = collisionTimes[1];
            side = MotionTargetPanzer.PanzerSide.RIGHT;
        }
        if (collisionTimes[2] < collisionTime) {
            collisionTime = collisionTimes[2];
            side = MotionTargetPanzer.PanzerSide.REAR;
        }
        if (collisionTimes[3] < collisionTime) {
            collisionTime = collisionTimes[3];
            side = MotionTargetPanzer.PanzerSide.LEFT;
        }
        if (collisionTime <= 1.0000001) {
            return new CollisionPanzerLaunchable(collisionTime, panzerTgt, projTgt, side);
        }
        return null;
    }
}

