/*
 * Decompiled with CFR 0.152.
 */
package jrobots.simulation.simulationObjects;

import java.util.ArrayList;
import jrobots.simulation.SimulationController;
import jrobots.simulation.SimulationState;
import jrobots.simulation.simulationObjects.Collision;
import jrobots.simulation.simulationObjects.MotionTargetPanzer;
import jrobots.utils.Vector;

class CollisionPanzerPanzer
extends Collision {
    MotionTargetPanzer colliderTgt;
    MotionTargetPanzer collPartner;
    private MotionTargetPanzer.PanzerVertex vertex;
    private MotionTargetPanzer.PanzerSide partnerSide;
    private double intrusionDistance;

    @Override
    public int compareTo(Collision o) {
        if (o instanceof CollisionPanzerPanzer) {
            CollisionPanzerPanzer coll = (CollisionPanzerPanzer)o;
            if (this.colliderTgt == coll.colliderTgt && this.collPartner == coll.collPartner || this.colliderTgt == coll.collPartner && this.collPartner == coll.colliderTgt) {
                return 0;
            }
        }
        return super.compareTo(o);
    }

    public CollisionPanzerPanzer(MotionTargetPanzer colliderTgt, MotionTargetPanzer collPartner, double time, MotionTargetPanzer.PanzerVertex vertex, MotionTargetPanzer.PanzerSide partnerSide, double intrusionDistance) {
        this.colliderTgt = colliderTgt;
        this.collPartner = collPartner;
        this.timeInFrame = time;
        this.vertex = vertex;
        this.partnerSide = partnerSide;
        this.intrusionDistance = intrusionDistance;
    }

    @Override
    public void react(SimulationState state, ArrayList<MotionTargetPanzer> panzerTargets) {
        double force = 40000.0 * this.intrusionDistance / (SimulationController.simulationIntervalDuration * SimulationController.simulationIntervalDuration);
        if (force > 3000000.0) {
            force = 3000000.0;
        }
        this.colliderTgt.inceptor.exertForce(this.vertex, new Vector(this.collPartner.startOrientation.add(this.partnerSide.orientationOffset()).normalize(), force));
        this.collPartner.inceptor.exertForce(this.partnerSide, new Vector(this.colliderTgt.startOrientation.add(this.vertex.orientationOffset()).normalize(), force));
        panzerTargets.remove(this.colliderTgt);
        panzerTargets.remove(this.collPartner);
        this.colliderTgt = MotionTargetPanzer.update(this.colliderTgt);
        this.collPartner = MotionTargetPanzer.update(this.collPartner);
        panzerTargets.add(this.colliderTgt);
        panzerTargets.add(this.collPartner);
        this.colliderTgt.collidedPanzers.add(this.collPartner.inceptor);
        this.collPartner.collidedPanzers.add(this.colliderTgt.inceptor);
    }

    static CollisionPanzerPanzer discoverCollision(MotionTargetPanzer colliderTgt, MotionTargetPanzer collPartner) {
        if (colliderTgt == collPartner) {
            return null;
        }
        if (colliderTgt.collidedPanzers.contains(collPartner)) {
            return null;
        }
        MotionTargetPanzer.IntrusionDistanceSide[] intrudedSides = new MotionTargetPanzer.IntrusionDistanceSide[]{colliderTgt.calculateIntrusionDistance(collPartner, MotionTargetPanzer.PanzerVertex.FRONTRIGHT), colliderTgt.calculateIntrusionDistance(collPartner, MotionTargetPanzer.PanzerVertex.REARRIGHT), colliderTgt.calculateIntrusionDistance(collPartner, MotionTargetPanzer.PanzerVertex.REARLEFT), colliderTgt.calculateIntrusionDistance(collPartner, MotionTargetPanzer.PanzerVertex.FRONTLEFT)};
        MotionTargetPanzer.IntrusionDistanceSide intrudedSide = intrudedSides[0];
        MotionTargetPanzer.PanzerVertex intrusionVertex = MotionTargetPanzer.PanzerVertex.FRONTRIGHT;
        if (intrudedSides[1].intrusionDistance > intrudedSide.intrusionDistance) {
            intrudedSide = intrudedSides[1];
            intrusionVertex = MotionTargetPanzer.PanzerVertex.REARRIGHT;
        }
        if (intrudedSides[2].intrusionDistance > intrudedSide.intrusionDistance) {
            intrudedSide = intrudedSides[2];
            intrusionVertex = MotionTargetPanzer.PanzerVertex.REARLEFT;
        }
        if (intrudedSides[3].intrusionDistance > intrudedSide.intrusionDistance) {
            intrudedSide = intrudedSides[3];
            intrusionVertex = MotionTargetPanzer.PanzerVertex.FRONTLEFT;
        }
        if (intrudedSide.intrusionDistance > 0.0) {
            return new CollisionPanzerPanzer(colliderTgt, collPartner, 0.0, intrusionVertex, intrudedSide.intrusionSide, intrudedSide.intrusionDistance);
        }
        return null;
    }
}

