/*
 * Decompiled with CFR 0.152.
 */
package jrobots.simulation.simulationObjects;

import java.io.Serializable;
import jrobots.simulation.SimulationRun;
import jrobots.utils.Angle;
import jrobots.utils.Vector;

public class Explosion
implements Serializable {
    private static final long serialVersionUID = -6405140786467679004L;
    private Vector pos;
    private Angle orientation;
    private double time;

    public Explosion(Vector pos, Angle orientation, double creationTime, int amount) {
        this.pos = pos;
        this.orientation = orientation;
        this.time = creationTime;
        int i = 1;
        while (i <= 20 * amount) {
            Vector speed = new Vector(orientation.add(new Angle(Math.random() * 3.0 - 1.5, "R")), Math.random() * 4.0 * Math.sqrt(amount));
            SimulationRun.simulationRun.addExplosionParticle(pos.add(speed.mult(Math.random() * 0.2)), speed, this.time + (double)i / 300.0);
            ++i;
        }
    }

    public Angle getOrientation() {
        return this.orientation;
    }

    public Vector getPos() {
        return this.pos;
    }
}

