/*
 * Decompiled with CFR 0.152.
 */
package jrobots.simulation.simulationObjects;

import java.awt.Color;
import jrobots.simulation.simulationObjects.Pilot;
import jrobots.utils.Angle;
import jrobots.utils.Scan;
import jrobots.utils.Vector;

public abstract class JRobot2009
extends Pilot {
    private static final long serialVersionUID = 4916662582869180089L;

    @Override
    protected final Scan getLastScan() {
        Scan tmp = super.getLastScan();
        return new Scan(tmp.scanDirection, tmp.scanAperture.mult(0.5), tmp.distanceToTarget, tmp.scannerPosition, tmp.timeOfScan);
    }

    @Override
    protected final double getTimeOfLauncherReloaded() {
        return super.getTimeOfLauncherReloaded();
    }

    @Override
    protected final double getTimeOfDropperReloaded() {
        return super.getTimeOfDropperReloaded();
    }

    protected static final double getMaxArenaDiameter() {
        return Pilot.getMaxArenaDiameter();
    }

    protected static final Angle getMaxScanAperture() {
        return Pilot.getMaxScanAperture();
    }

    protected static final double getScanInterval() {
        return Pilot.getScanInterval();
    }

    protected static final double getMineReloadTime() {
        return Pilot.getMineReloadTime();
    }

    protected static final double getTankTrapReloadTime() {
        return Pilot.getTrapReloadTime();
    }

    protected static final double getProjectileReloadTime() {
        return Pilot.getReloadTime();
    }

    protected static final double getMissileReloadTime() {
        return Pilot.getMissileReloadTime();
    }

    protected static final double getProjectileSpeed() {
        return Pilot.getProjectileSpeed();
    }

    protected static final double getMissileSpeedMax() {
        return Pilot.getMissileSpeedMax();
    }

    protected final boolean isScanFromNow() {
        if (super.getLastScan() == null) {
            return false;
        }
        return super.getTime() == super.getLastScan().timeOfScan;
    }

    @Override
    protected final Vector getPosition() {
        return super.getPosition();
    }

    @Override
    protected final Angle getOrientation() {
        return super.getOrientation();
    }

    @Override
    protected final Vector getVelocity() {
        return super.getVelocity();
    }

    protected static final double getMaxForwardVelocity() {
        return Pilot.getMaxForwardVelocity();
    }

    protected static final double getMaxBackwardVelocity() {
        return Pilot.getMaxBackwardVelocity();
    }

    @Override
    protected final void setScanAperture(Angle aperture) {
        super.setScanAperture(aperture);
    }

    @Override
    protected final void setScanDirection(Angle scanDirection) {
        super.setScanDirection(scanDirection);
    }

    @Override
    protected final void setAutopilot(Angle direction, double speed) {
        super.setAutopilot(direction, speed);
    }

    protected final void setLaunchProjectileCommand(Angle command) {
        super.setLauncherAmmunition(Pilot.LauncherAmmunition.PROJECTILE_AP);
        super.setLaunchCommand(command);
    }

    @Deprecated
    protected final void setLauncherCommand(Angle command) {
        this.setLaunchProjectileCommand(command);
    }

    protected final void setLaunchMissileCommand(Angle command) {
        super.setLauncherAmmunition(Pilot.LauncherAmmunition.MISSILE_HE);
        super.setLaunchCommand(command);
    }

    protected final void setDropMineCommand(boolean isToBeLayed) {
        if (isToBeLayed) {
            super.setDropMineCommand(Pilot.DropperCommand.MINE);
        } else {
            super.setDropMineCommand(Pilot.DropperCommand.NOTHING);
        }
    }

    protected final void setDropTankTrapCommand(boolean isToBeLayed) {
        if (isToBeLayed) {
            super.setDropMineCommand(Pilot.DropperCommand.TANK_TRAP);
        } else {
            super.setDropMineCommand(Pilot.DropperCommand.NOTHING);
        }
    }

    protected final void setMissileTarget(Vector targetPosition) {
        Vector[] dPos = super.getDirectablePositions();
        if (dPos.length == 0) {
            return;
        }
        super.setMissileTarget(dPos.length - 1, targetPosition);
    }

    @Override
    protected final void setDebugText(String text) {
        super.setDebugText(text);
    }

    @Override
    protected final void setDebugLines(Vector[] points) {
        super.setDebugLines(points);
    }

    @Override
    protected final void addDebugLine(Vector p1, Vector p2) {
        this.addDebugLine((float)p1.getX(), (float)p1.getY(), (float)p2.getX(), (float)p2.getY());
    }

    @Override
    protected final void addDebugCrosshair(Vector position) {
        super.addDebugCrosshair(position);
    }

    @Override
    protected final void addDebugArrow(Vector start, Vector end) {
        super.addDebugArrow(start, end);
    }

    @Override
    protected final void addDebugLine(float x1, float y1, float x2, float y2) {
        super.addDebugLine(x1, y1, x2, y2);
    }

    @Override
    protected final void setNameColor(Color newNameColor) {
        super.setNameColor(newNameColor);
    }

    @Override
    protected final void setTurretColor(Color newColor) {
        super.setTurretColor(newColor);
    }

    @Override
    protected final void setBodyColor(Color newColor) {
        super.setBodyColor(newColor);
    }

    @Override
    protected abstract void actions();
}

