/*
 * Decompiled with CFR 0.152.
 */
package jrobots.simulation.simulationObjects;

import java.awt.Color;
import jrobots.simulation.simulationObjects.Pilot;
import jrobots.utils.Angle;
import jrobots.utils.Scan;
import jrobots.utils.Vector;

public abstract class JRobot2011
extends Pilot {
    private static final long serialVersionUID = 7957436071810797678L;

    protected static final double getEnergyProduction() {
        return 0.012;
    }

    protected static final double getEnergyConsumptionEngine() {
        return 0.00216;
    }

    protected static final double getEnergyConsumptionBooster() {
        return 0.036;
    }

    protected static final double getEnergyConsumptionScanner() {
        return 0.00384;
    }

    protected static final double getEnergyConsumptionProjectile() {
        return 0.3;
    }

    protected static final double getEnergyConsumptionRocket() {
        return 0.3;
    }

    protected static final double getEnergyConsumptionMine() {
        return 0.18;
    }

    protected static final double getEnergyConsumptionTrap() {
        return 0.09;
    }

    protected static final double getEnergyConsumptionRocketRedirection() {
        return 0.054;
    }

    @Override
    protected final Scan getLastScan() {
        Scan tmp = super.getLastScan();
        return new Scan(tmp.scanDirection, tmp.scanAperture.mult(0.5), tmp.distanceToTarget, tmp.scannerPosition, tmp.timeOfScan);
    }

    protected final Vector getProximityScanLaunchable() {
        if (super.getProximityScanFromLaunchable() == null) {
            return null;
        }
        return super.getProximityScanFromLaunchable().pos;
    }

    @Override
    protected final Vector getProximityScanDroppable() {
        return super.getProximityScanDroppable();
    }

    protected static final double getMaxArenaDiameter() {
        return Pilot.getMaxArenaDiameter();
    }

    protected static final double getFramesPerSecond() {
        return 25.0;
    }

    protected static final Angle getMaxScanAperture() {
        return Pilot.getMaxScanAperture();
    }

    protected static final double getProjectileSpeed() {
        return Pilot.getProjectileSpeed();
    }

    protected static final double getMaxVelocityRocket() {
        return Pilot.getRocketSpeedMax();
    }

    protected static final double getMaxVelocityProjectile() {
        return Pilot.getProjectileSpeed();
    }

    protected final boolean isScanFromNow() {
        if (super.getLastScan() == null) {
            return false;
        }
        return super.getTime() == super.getLastScan().timeOfScan;
    }

    @Override
    protected final Vector getPosition() {
        return super.getPosition();
    }

    protected final Vector getRocketPosition() {
        Vector[] dPos = super.getDirectablePositions();
        if (dPos.length == 0) {
            return null;
        }
        return dPos[dPos.length - 1];
    }

    @Override
    protected final Angle getOrientation() {
        return super.getOrientation();
    }

    @Override
    protected final Vector getVelocity() {
        return super.getVelocity();
    }

    protected static final double getMaxForwardVelocity() {
        return Pilot.getMaxForwardVelocity();
    }

    protected static final double getMaxBackwardVelocity() {
        return Pilot.getMaxBackwardVelocity();
    }

    @Override
    protected final void setScanAperture(Angle aperture) {
        super.setScanAperture(aperture);
    }

    @Override
    protected final void setScanDirection(Angle scanDirection) {
        super.setScanDirection(scanDirection);
    }

    @Override
    protected final void setAutopilot(Angle direction, double speed) {
        super.setAutopilot(direction, speed);
    }

    @Override
    protected final void setBoost() {
        super.setBoost();
    }

    protected final void setLaunchProjectileCommand(Angle command) {
        super.setLauncherAmmunition(Pilot.LauncherAmmunition.PROJECTILE_AP);
        super.setLaunchCommand(command);
    }

    protected final void setLaunchRocketCommand(Angle command) {
        super.setLauncherAmmunition(Pilot.LauncherAmmunition.ROCKET_AP);
        super.setLaunchCommand(command);
    }

    protected final void setDropMineCommand(boolean isToBeLayed) {
        if (isToBeLayed) {
            super.setDropMineCommand(Pilot.DropperCommand.MINE);
        } else {
            super.setDropMineCommand(Pilot.DropperCommand.NOTHING);
        }
    }

    protected final void setDropTankTrapCommand(boolean isToBeLayed) {
        if (isToBeLayed) {
            super.setDropMineCommand(Pilot.DropperCommand.TANK_TRAP);
        } else {
            super.setDropMineCommand(Pilot.DropperCommand.NOTHING);
        }
    }

    protected final void setRocketHeading(Angle targetBearing) {
        Vector[] dPos = super.getDirectablePositions();
        if (dPos.length == 0) {
            return;
        }
        super.setRocketHeading(dPos.length - 1, targetBearing);
    }

    @Override
    protected final void setDebugText(String text) {
        super.setDebugText(text);
    }

    @Override
    protected final void setDebugLines(Vector[] points) {
        super.setDebugLines(points);
    }

    @Override
    protected final void addDebugLine(Vector p1, Vector p2) {
        this.addDebugLine((float)p1.getX(), (float)p1.getY(), (float)p2.getX(), (float)p2.getY());
    }

    @Override
    protected final void addDebugCrosshair(Vector position) {
        super.addDebugCrosshair(position);
    }

    @Override
    protected final void addDebugArrow(Vector start, Vector end) {
        super.addDebugArrow(start, end);
    }

    @Override
    protected final void addDebugLine(float x1, float y1, float x2, float y2) {
        super.addDebugLine(x1, y1, x2, y2);
    }

    @Override
    protected final void setNameColor(Color newNameColor) {
        super.setNameColor(newNameColor);
    }

    @Override
    protected final void setTurretColor(Color newColor) {
        super.setTurretColor(newColor);
    }

    @Override
    protected final void setBodyColor(Color newColor) {
        super.setBodyColor(newColor);
    }

    @Override
    protected abstract void actions();
}

