/*
 * Decompiled with CFR 0.152.
 */
package jrobots.simulation.simulationObjects;

import java.awt.Color;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import jrobots.simulation.simulationObjects.Constants;
import jrobots.simulation.simulationObjects.Pilot;
import jrobots.utils.Angle;
import jrobots.utils.Scan;
import jrobots.utils.Vector;

public abstract class JRobot2012
extends Pilot {
    protected static final String constants = JRobot2012.printConstants();

    private static final String printConstants() {
        Method[] methods;
        StringBuilder str = new StringBuilder();
        str.append("Konstanten f\u00fcr ");
        str.append(JRobot2012.class.getSimpleName());
        str.append("\n");
        Method[] methodArray = methods = JRobot2012.class.getDeclaredMethods();
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            if (Modifier.isStatic(method.getModifiers()) && method.getParameterTypes().length == 0 && !method.getName().contains("printConstants")) {
                str.append(method.getName());
                str.append("() == ");
                try {
                    boolean isAccessible = method.isAccessible();
                    try {
                        method.setAccessible(true);
                        str.append(method.invoke(null, new Object[0]));
                    }
                    finally {
                        method.setAccessible(isAccessible);
                    }
                }
                catch (IllegalArgumentException e) {
                    str.append("IllegalArgument");
                }
                catch (IllegalAccessException e) {
                    str.append("IllegalAccess");
                }
                catch (InvocationTargetException e) {
                    str.append("IllegalInvocationTarget");
                }
                str.append("\n");
            }
            ++n2;
        }
        str.append("\n");
        System.out.print(str);
        return str.toString();
    }

    protected static final double getEnergyProduction() {
        return 0.012;
    }

    protected static final double getEnergyConsumptionEngine() {
        return 0.00216;
    }

    protected static final double getEnergyConsumptionBooster() {
        return 0.036;
    }

    protected static final double getEnergyConsumptionScanner() {
        return 0.00384;
    }

    protected static final double getEnergyConsumptionRocket() {
        return 0.3;
    }

    protected static final double getEnergyConsumptionRocketRedirection() {
        return 0.054;
    }

    protected static final double getMaxArenaDiameter() {
        return Pilot.getMaxArenaDiameter();
    }

    protected static final int getFramesPerSecond() {
        return 25;
    }

    protected static final Angle getMaxScanAperture() {
        return Pilot.getMaxScanAperture();
    }

    protected static final double getProximityScannerProjectileRange() {
        return 50.0;
    }

    protected static final double getMaxVelocityRocket() {
        return Pilot.getRocketSpeedMax();
    }

    protected static final double getMaxForwardVelocity() {
        return Pilot.getMaxForwardVelocity();
    }

    protected static final double getMaxBackwardVelocity() {
        return Pilot.getMaxBackwardVelocity();
    }

    protected static final double getMaxForwardVelocityWithBooster() {
        return Constants.PANZER_MAX_SPEED_FORWARD_BOOSTING;
    }

    protected static final double getRocketDamageFront() {
        return 0.14;
    }

    protected static final double getRocketDamageSide() {
        return 0.19;
    }

    protected static final double getRocketDamageRear() {
        return 0.31;
    }

    protected final boolean isScanFromNow() {
        if (super.getLastScan() == null) {
            return false;
        }
        return super.getTime() == super.getLastScan().timeOfScan;
    }

    @Override
    protected final Scan getLastScan() {
        return super.getLastScan();
    }

    protected final Vector getProximityScanLaunchable() {
        if (super.getProximityScanFromLaunchable() == null) {
            return null;
        }
        return super.getProximityScanFromLaunchable().pos;
    }

    @Override
    protected final Vector[] getDirectablePositions() {
        return super.getDirectablePositions();
    }

    protected final Angle getRocketTargetBearing(int idx) {
        return super.getRocketBearingTarget(idx);
    }

    @Override
    protected final Vector getPosition() {
        return super.getPosition();
    }

    @Override
    protected final Angle getOrientation() {
        return super.getOrientation();
    }

    @Override
    protected final Vector getVelocity() {
        return super.getVelocity();
    }

    @Override
    protected final void setScanAperture(Angle aperture) {
        super.setScanAperture(aperture);
    }

    @Override
    protected final void setScanDirection(Angle scanDirection) {
        super.setScanDirection(scanDirection);
    }

    @Override
    protected final void setAutopilot(Angle direction, double speed) {
        super.setAutopilot(direction, speed);
    }

    @Override
    protected final void setBoost() {
        super.setBoost();
    }

    protected final void setLaunchRocket(Angle command) {
        super.setLauncherAmmunition(Pilot.LauncherAmmunition.ROCKET_AP);
        super.setLaunchCommand(command);
    }

    @Override
    protected final void setRocketHeading(int directableNumber, Angle targetBearing) {
        super.setRocketHeading(directableNumber, targetBearing);
    }

    @Override
    protected final void addDebugLine(Vector p1, Vector p2) {
        super.addDebugLine(p1, p2);
    }

    @Override
    protected final void addDebugCrosshair(Vector position) {
        super.addDebugCrosshair(position);
    }

    @Override
    protected final void addDebugArrow(Vector start, Vector end) {
        super.addDebugArrow(start, end);
    }

    @Override
    protected final void setNameColor(Color newNameColor) {
        super.setNameColor(newNameColor);
    }

    @Override
    protected final void setTurretColor(Color newColor) {
        super.setTurretColor(newColor);
    }

    @Override
    protected final void setBodyColor(Color newColor) {
        super.setBodyColor(newColor);
    }

    @Override
    protected abstract void actions();
}

