/*
 * Decompiled with CFR 0.152.
 */
package jrobots.simulation.simulationObjects;

import java.awt.Color;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import jrobots.simulation.simulationObjects.Pilot;
import jrobots.utils.Angle;
import jrobots.utils.Scan;
import jrobots.utils.Vector;

public abstract class JRobot2012_FH
extends Pilot {
    private static final long serialVersionUID = 4485514585092103453L;
    protected static final String constants = JRobot2012_FH.printConstants();

    private static final String printConstants() {
        Method[] methods;
        StringBuilder str = new StringBuilder();
        str.append("Konstanten f\u00c3\u00bcr ");
        str.append(JRobot2012_FH.class.getSimpleName());
        str.append("\n");
        Method[] methodArray = methods = JRobot2012_FH.class.getDeclaredMethods();
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            if (Modifier.isStatic(method.getModifiers()) && method.getParameterTypes().length == 0 && !method.getName().contains("printConstants")) {
                str.append(method.getName());
                str.append("() == ");
                try {
                    boolean isAccessible = method.isAccessible();
                    try {
                        method.setAccessible(true);
                        str.append(method.invoke(null, new Object[0]));
                    }
                    finally {
                        method.setAccessible(isAccessible);
                    }
                }
                catch (IllegalArgumentException e) {
                    str.append("IllegalArgument");
                }
                catch (IllegalAccessException e) {
                    str.append("IllegalAccess");
                }
                catch (InvocationTargetException e) {
                    str.append("IllegalInvocationTarget");
                }
                str.append("\n");
            }
            ++n2;
        }
        str.append("\n");
        System.out.print(str);
        return str.toString();
    }

    protected static final double getEnergyProductionPerFrame() {
        return 0.012;
    }

    protected static final double getEnergyConsumptionEngine() {
        return 0.00216;
    }

    protected static final double getEnergyConsumptionScanner() {
        return 0.00384;
    }

    protected static final double getEnergyConsumptionProjectile() {
        return 0.3;
    }

    protected static final double getMaxArenaDiameter() {
        return Pilot.getMaxArenaDiameter();
    }

    protected static final int getFramesPerSecond() {
        return 25;
    }

    protected static final double getProjectileSpeed() {
        return Pilot.getProjectileSpeed();
    }

    protected static final Angle getMaxScanAperture() {
        return Pilot.getMaxScanAperture();
    }

    protected static final double getMaxForwardVelocity() {
        return Pilot.getMaxForwardVelocity();
    }

    protected static final double getMaxBackwardVelocity() {
        return Pilot.getMaxBackwardVelocity();
    }

    protected final boolean isScanFromNow() {
        if (super.getLastScan() == null) {
            return false;
        }
        return super.getTime() == super.getLastScan().timeOfScan;
    }

    @Override
    protected final Scan getLastScan() {
        return super.getLastScan();
    }

    @Override
    protected final Vector getPosition() {
        return super.getPosition();
    }

    @Override
    protected final Angle getOrientation() {
        return super.getOrientation();
    }

    @Override
    protected final Vector getVelocity() {
        return super.getVelocity();
    }

    @Override
    protected final void setScanAperture(Angle aperture) {
        super.setScanAperture(aperture);
    }

    @Override
    protected final void setScanDirection(Angle scanDirection) {
        super.setScanDirection(scanDirection);
    }

    protected final void setLaunchProjectileCommand(Angle command) {
        super.setLauncherAmmunition(Pilot.LauncherAmmunition.PROJECTILE_AP);
        super.setLaunchCommand(command);
    }

    @Override
    protected final void setAutopilot(Angle direction, double speed) {
        super.setAutopilot(direction, speed);
    }

    @Override
    protected final void addDebugLine(Vector p1, Vector p2) {
        super.addDebugLine(p1, p2);
    }

    @Override
    protected final void setDebugText(String text) {
        super.setDebugText(text);
    }

    @Override
    protected final void addDebugCrosshair(Vector position) {
        super.addDebugCrosshair(position);
    }

    @Override
    protected final void addDebugArrow(Vector start, Vector end) {
        super.addDebugArrow(start, end);
    }

    @Override
    protected final void setNameColor(Color newNameColor) {
        super.setNameColor(newNameColor);
    }

    @Override
    protected final void setTurretColor(Color newColor) {
        super.setTurretColor(newColor);
    }

    @Override
    protected final void setBodyColor(Color newColor) {
        super.setBodyColor(newColor);
    }

    @Override
    protected abstract void actions();
}

