/*
 * Decompiled with CFR 0.152.
 */
package jrobots.simulation.simulationObjects;

import java.awt.Color;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import jrobots.simulation.simulationObjects.Pilot;
import jrobots.utils.Angle;
import jrobots.utils.Scan;
import jrobots.utils.Vector;

public abstract class JRobot2014Sprint2
extends Pilot {
    private static final long serialVersionUID = 4485514585092103453L;
    static final String constants = JRobot2014Sprint2.printConstants();
    private Scan latestSuccessfulScan = null;
    private Angle lastScanDir = Angle.EAST;
    private Angle scanAperture = new Angle(22.0, "d");
    private Angle scanSection = new Angle(20.0, "d");
    private Vector lastKnownEnemyPosition = new Vector();
    private Angle drivingOffset = new Angle(45.0, "d");

    private static final String printConstants() {
        Method[] methods;
        StringBuilder str = new StringBuilder();
        str.append("Konstanten f\u00fcr ");
        str.append(JRobot2014Sprint2.class.getSimpleName());
        str.append("\n");
        Method[] methodArray = methods = JRobot2014Sprint2.class.getDeclaredMethods();
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            if (Modifier.isStatic(method.getModifiers()) && method.getParameterTypes().length == 0 && !method.getName().contains("printConstants")) {
                str.append(method.getName());
                str.append("() == ");
                try {
                    boolean isAccessible = method.isAccessible();
                    try {
                        method.setAccessible(true);
                        str.append(method.invoke(null, new Object[0]));
                    }
                    finally {
                        method.setAccessible(isAccessible);
                    }
                }
                catch (IllegalArgumentException e) {
                    str.append("IllegalArgument");
                }
                catch (IllegalAccessException e) {
                    str.append("IllegalAccess");
                }
                catch (InvocationTargetException e) {
                    str.append("IllegalInvocationTarget");
                }
                str.append("\n");
            }
            ++n2;
        }
        str.append("\n");
        System.out.print(str);
        return str.toString();
    }

    protected static final double getEnergyProductionPerFrame() {
        return 0.012;
    }

    protected static final double getEnergyConsumptionEngine() {
        return 0.00216;
    }

    protected static final double getEnergyConsumptionScanner() {
        return 0.00384;
    }

    protected static final double getEnergyConsumptionBullet() {
        return 0.056999999999999995;
    }

    protected static final double getMaxArenaDiameter() {
        return Pilot.getMaxArenaDiameter();
    }

    protected static final int getFramesPerSecond() {
        return 25;
    }

    protected static final double getBulletSpeed() {
        return 90.0;
    }

    protected static final double getBulletDamageRear() {
        return 0.04;
    }

    protected static final double getBulletDamageSide() {
        return 0.01;
    }

    protected static final double getBulletDamageFront() {
        return 0.005;
    }

    protected static final double getJRobotLength() {
        return 8.0;
    }

    protected static final double getMaxForwardVelocity() {
        return Pilot.getMaxForwardVelocity();
    }

    protected static final double getMaxBackwardVelocity() {
        return Pilot.getMaxBackwardVelocity();
    }

    @Override
    protected final Vector getPosition() {
        return super.getPosition();
    }

    @Override
    protected final Vector getVelocity() {
        return super.getVelocity();
    }

    protected final void setLaunchProjectileCommand(Angle command) {
        super.setLauncherAmmunition(Pilot.LauncherAmmunition.BULLET_AP);
        super.setLaunchCommand(command);
    }

    @Override
    protected final void setAutopilot(Angle direction, double speed) {
        super.setAutopilot(direction, speed);
    }

    @Override
    protected final void addDebugLine(Vector p1, Vector p2) {
        super.addDebugLine(p1, p2);
    }

    @Override
    protected final void addDebugCrosshair(Vector position) {
        super.addDebugCrosshair(position);
    }

    @Override
    protected final void addDebugArrow(Vector start, Vector end) {
        super.addDebugArrow(start, end);
    }

    @Override
    protected final void setNameColor(Color newNameColor) {
        super.setNameColor(newNameColor);
    }

    @Override
    protected final void setTurretColor(Color newColor) {
        super.setTurretColor(newColor);
    }

    @Override
    protected final void setBodyColor(Color newColor) {
        super.setBodyColor(newColor);
    }

    @Override
    final void actions() {
        this.doScanning();
        this.doShooting();
        this.doDriving();
    }

    @Override
    protected void init() {
        super.init();
        this.lastScanDir = this.getOrientation();
    }

    final void doScanning() {
        Scan lastScan = this.getLastScan();
        if (lastScan != null && lastScan.isTargetLocated() && (this.latestSuccessfulScan == null || this.latestSuccessfulScan.timeOfScan < this.getTime() - 180.0 / this.scanAperture.getValueAsDegrees() * (1.0 / (double)JRobot2014Sprint2.getFramesPerSecond()))) {
            this.latestSuccessfulScan = lastScan;
            this.lastKnownEnemyPosition = lastScan.estimatedTargetPosition();
        }
        this.lastScanDir = this.lastScanDir.add(this.scanSection);
        this.setScanDirection(this.lastScanDir);
        this.setScanAperture(this.scanAperture);
    }

    protected void doDriving() {
        Vector targetDistance = this.lastKnownEnemyPosition.sub(this.getPosition());
        this.setAutopilot(targetDistance.getAngle().add(this.drivingOffset), 1.0);
    }

    protected final Scan getLastestRoundaboutScanHit() {
        return this.latestSuccessfulScan;
    }

    protected abstract void doShooting();
}

