/*
 * Decompiled with CFR 0.152.
 */
package jrobots.simulation.simulationObjects;

import java.util.HashSet;
import jrobots.simulation.simulationObjects.Constants;
import jrobots.simulation.simulationObjects.MotionTargetLaunchable;
import jrobots.simulation.simulationObjects.Panzer;
import jrobots.utils.Angle;
import jrobots.utils.Vector;

public class MotionTargetPanzer {
    Panzer inceptor;
    Vector startPos;
    Angle startOrientation;
    Vector endPos;
    Angle endOrientation;
    Vector velocity;
    Angle omega;
    double startTime;
    double targetTime;
    transient HashSet<Panzer> collidedPanzers;

    MotionTargetPanzer(Panzer inceptor, Vector startPos, Angle startOrientation, Vector endPos, Angle endOrientation, Vector velocity, Angle omega, double startTime, double targetTime) {
        this.inceptor = inceptor;
        this.startPos = startPos;
        this.startOrientation = startOrientation;
        this.endPos = endPos;
        this.endOrientation = endOrientation;
        this.velocity = velocity;
        this.omega = omega;
        this.startTime = startTime;
        this.targetTime = targetTime;
        this.collidedPanzers = new HashSet();
    }

    static MotionTargetPanzer update(MotionTargetPanzer tgt) {
        MotionTargetPanzer newTgt = tgt.inceptor.calculateMotion(tgt.targetTime - tgt.startTime);
        newTgt.collidedPanzers = tgt.collidedPanzers;
        return newTgt;
    }

    public void commitToPanzer() {
        this.inceptor.applyMotionTarget(this);
    }

    double calculateCollisionTime(MotionTargetLaunchable projTgt, PanzerSide side) {
        double startCollisionTime = this.calculateCollisionTime(projTgt, side, true);
        double endCollisionTime = this.calculateCollisionTime(projTgt, side, false);
        if (startCollisionTime <= -1.0E-7 || endCollisionTime <= -1.0E-7) {
            startCollisionTime = Math.max(startCollisionTime, endCollisionTime);
        } else if (startCollisionTime >= 1.0000001 || endCollisionTime >= 1.0000001) {
            startCollisionTime = Math.min(startCollisionTime, endCollisionTime);
        }
        if (startCollisionTime <= -1.0E-7 || startCollisionTime >= 1.0000001) {
            return Double.MAX_VALUE;
        }
        return startCollisionTime;
    }

    private double calculateCollisionTime(MotionTargetLaunchable projTgt, PanzerSide side, boolean isStartOfWindow) {
        double deltaDistance;
        double startDistance;
        switch (side) {
            case FRONT: {
                startDistance = this.calculateFrontDistance(projTgt.startPos, isStartOfWindow);
                deltaDistance = this.calculateFrontDistance(projTgt.endPos, isStartOfWindow) - startDistance;
                break;
            }
            case RIGHT: {
                startDistance = this.calculateRightDistance(projTgt.startPos, isStartOfWindow);
                deltaDistance = this.calculateRightDistance(projTgt.endPos, isStartOfWindow) - startDistance;
                break;
            }
            case REAR: {
                startDistance = this.calculateRearDistance(projTgt.startPos, isStartOfWindow);
                deltaDistance = this.calculateRearDistance(projTgt.endPos, isStartOfWindow) - startDistance;
                break;
            }
            default: {
                startDistance = this.calculateLeftDistance(projTgt.startPos, isStartOfWindow);
                deltaDistance = this.calculateLeftDistance(projTgt.endPos, isStartOfWindow) - startDistance;
            }
        }
        if (deltaDistance >= 0.0) {
            return Double.MAX_VALUE;
        }
        double collisionTime = startDistance / deltaDistance;
        switch (side) {
            case FRONT: 
            case REAR: {
                double orthoDistance = this.calculateLeftDistance(projTgt.startPos.add(projTgt.endPos.sub(projTgt.startPos).mult(collisionTime)), isStartOfWindow);
                if (!(orthoDistance > 1.0E-7) && !(orthoDistance < -6.0000001)) break;
                collisionTime = Double.MAX_VALUE;
                break;
            }
            default: {
                double orthoDistance = this.calculateFrontDistance(projTgt.startPos.add(projTgt.endPos.sub(projTgt.startPos).mult(collisionTime)), isStartOfWindow);
                if (!(orthoDistance > 1.0E-7) && !(orthoDistance < -8.0000001)) break;
                collisionTime = Double.MAX_VALUE;
            }
        }
        return collisionTime;
    }

    public IntrusionDistanceSide calculateIntrusionDistance(MotionTargetPanzer collPartner, PanzerVertex vertex) {
        Vector vertexPos;
        switch (vertex) {
            case FRONTRIGHT: {
                vertexPos = this.endPos.add(new Vector(this.startOrientation.add(new Angle(0.7853981633974483, "r")), Constants.PANZER_DIAGONAL / 2.0));
                break;
            }
            case REARRIGHT: {
                vertexPos = this.endPos.add(new Vector(this.startOrientation.getNextQuadrant().add(new Angle(0.7853981633974483, "r")), Constants.PANZER_DIAGONAL / 2.0));
                break;
            }
            case REARLEFT: {
                vertexPos = this.endPos.add(new Vector(this.startOrientation.getOpposite().add(new Angle(0.7853981633974483, "r")), Constants.PANZER_DIAGONAL / 2.0));
                break;
            }
            default: {
                vertexPos = this.endPos.add(new Vector(this.startOrientation.getPreviousQuadrant().add(new Angle(0.7853981633974483, "r")), Constants.PANZER_DIAGONAL / 2.0));
            }
        }
        double[] sideDistances = new double[]{collPartner.calculateFrontDistance(vertexPos, true), collPartner.calculateRightDistance(vertexPos, true), collPartner.calculateRearDistance(vertexPos, true), collPartner.calculateLeftDistance(vertexPos, true)};
        int i = 0;
        while (i < sideDistances.length) {
            if (sideDistances[i] > 1.0E-7) {
                return new IntrusionDistanceSide(-1.7976931348623157E308, PanzerSide.INVALID);
            }
            ++i;
        }
        PanzerSide intrusionSide = PanzerSide.FRONT;
        double maxSideDist = sideDistances[PanzerSide.FRONT.ordinal()];
        if (sideDistances[PanzerSide.RIGHT.ordinal()] > maxSideDist) {
            intrusionSide = PanzerSide.RIGHT;
            maxSideDist = sideDistances[PanzerSide.RIGHT.ordinal()];
        }
        if (sideDistances[PanzerSide.REAR.ordinal()] > maxSideDist) {
            intrusionSide = PanzerSide.REAR;
            maxSideDist = sideDistances[PanzerSide.REAR.ordinal()];
        }
        if (sideDistances[PanzerSide.LEFT.ordinal()] > maxSideDist) {
            intrusionSide = PanzerSide.LEFT;
            maxSideDist = sideDistances[PanzerSide.LEFT.ordinal()];
        }
        return new IntrusionDistanceSide(-maxSideDist, intrusionSide);
    }

    double calculateFrontDistance(Vector p, boolean isStartOfWindow) {
        if (isStartOfWindow) {
            return p.sub(this.startPos.add(new Vector(this.startOrientation, 4.0))).projection(this.startOrientation);
        }
        return p.sub(this.endPos.add(new Vector(this.endOrientation, 4.0))).projection(this.endOrientation);
    }

    double calculateRearDistance(Vector p, boolean isStartOfWindow) {
        if (isStartOfWindow) {
            return p.sub(this.startPos.add(new Vector(this.startOrientation.getOpposite(), 4.0))).projection(this.startOrientation.getOpposite());
        }
        return p.sub(this.endPos.add(new Vector(this.endOrientation.getOpposite(), 4.0))).projection(this.endOrientation.getOpposite());
    }

    double calculateLeftDistance(Vector p, boolean isStartOfWindow) {
        if (isStartOfWindow) {
            return p.sub(this.startPos.add(new Vector(this.startOrientation.getPreviousQuadrant(), 3.0))).projection(this.startOrientation.getPreviousQuadrant());
        }
        return p.sub(this.endPos.add(new Vector(this.endOrientation.getPreviousQuadrant(), 3.0))).projection(this.endOrientation.getPreviousQuadrant());
    }

    double calculateRightDistance(Vector p, boolean isStartOfWindow) {
        if (isStartOfWindow) {
            return p.sub(this.startPos.add(new Vector(this.startOrientation.getNextQuadrant(), 3.0))).projection(this.startOrientation.getNextQuadrant());
        }
        return p.sub(this.endPos.add(new Vector(this.endOrientation.getNextQuadrant(), 3.0))).projection(this.endOrientation.getNextQuadrant());
    }

    public double calculateCenterDistance(Vector point) {
        return point.sub(this.startPos).getLength();
    }

    public Panzer getInceptor() {
        return this.inceptor;
    }

    public Vector getEndPos() {
        return this.endPos;
    }

    class IntrusionDistanceSide {
        final double intrusionDistance;
        final PanzerSide intrusionSide;

        public IntrusionDistanceSide(double intrusionDistance, PanzerSide intrusionSide) {
            this.intrusionDistance = intrusionDistance;
            this.intrusionSide = intrusionSide;
        }
    }

    static enum PanzerSide {
        FRONT,
        RIGHT,
        REAR,
        LEFT,
        INVALID;


        Angle orientationOffset() {
            switch (this) {
                case FRONT: {
                    return new Angle();
                }
                case RIGHT: {
                    return new Angle().getNextQuadrant();
                }
                case REAR: {
                    return new Angle().getOpposite();
                }
                case LEFT: {
                    return new Angle().getPreviousQuadrant();
                }
            }
            return new Angle();
        }
    }

    static enum PanzerVertex {
        FRONTRIGHT,
        REARRIGHT,
        REARLEFT,
        FRONTLEFT;


        Angle orientationOffset() {
            switch (this) {
                case FRONTRIGHT: {
                    return new Angle(0.7853981633974483, "r");
                }
                case REARRIGHT: {
                    return new Angle(0.7853981633974483, "r").getNextQuadrant();
                }
                case REARLEFT: {
                    return new Angle(0.7853981633974483, "r").getOpposite();
                }
                case FRONTLEFT: {
                    return new Angle(0.7853981633974483, "r").getPreviousQuadrant();
                }
            }
            return new Angle();
        }
    }
}

