/*
 * Decompiled with CFR 0.152.
 */
package jrobots.simulation.simulationObjects;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import jrobots.simulation.simulationObjects.AbstractPilot;
import jrobots.simulation.simulationObjects.Constants;
import jrobots.simulation.simulationObjects.Directable;
import jrobots.simulation.simulationObjects.MotionTargetPanzer;
import jrobots.simulation.simulationObjects.Pilot;
import jrobots.simulation.simulationObjects.PilotZombie;
import jrobots.simulation.simulationObjects.droppables.Droppable;
import jrobots.simulation.simulationObjects.droppables.Mine;
import jrobots.simulation.simulationObjects.droppables.TankTrap;
import jrobots.simulation.simulationObjects.launchables.Bullet;
import jrobots.simulation.simulationObjects.launchables.Launchable;
import jrobots.simulation.simulationObjects.launchables.Minethrower;
import jrobots.simulation.simulationObjects.launchables.MiniMissile;
import jrobots.simulation.simulationObjects.launchables.Missile;
import jrobots.simulation.simulationObjects.launchables.Projectile;
import jrobots.simulation.simulationObjects.launchables.Rocket;
import jrobots.utils.Angle;
import jrobots.utils.ProximityScan;
import jrobots.utils.Scan;
import jrobots.utils.SonarTrace;
import jrobots.utils.Vector;

public class Panzer
implements Comparable<Panzer>,
Serializable {
    private static final long serialVersionUID = -7467190783725137022L;
    private int ID;
    private static int nextID;
    private Vector pos;
    private Angle orientation;
    private Vector velocityLinear;
    private Angle velocityAngular;
    private double health;
    private double energy;
    private int boostingFrames;
    private Scan lastScan;
    private SonarTrace lastSonarTrace;
    private ProximityScan proximityScanLaunchable;
    private Vector proximityScanDroppable;
    private double timeOfLauncherReloaded;
    private double timeOfDropperReloaded;
    public final int turretIndex;
    private AbstractPilot pilot;
    private transient double timeInFrame;
    private transient Vector linearAcceleration = new Vector();
    private transient Angle angularAcceleration = new Angle();
    private double mileageLeft = 0.0;
    private double mileageRight = 0.0;
    public ArrayList<Directable> missileLink = new ArrayList(1);

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.linearAcceleration = new Vector();
        this.angularAcceleration = new Angle();
    }

    public Panzer(AbstractPilot pilot, int turretIndex, Vector pos, Angle ori) {
        this.ID = nextID++;
        this.pilot = pilot;
        this.turretIndex = turretIndex;
        this.health = 1.0;
        this.pos = pos != null ? pos : new Vector(Math.random() * 100.0 - 50.0, Math.random() * 100.0 - 50.0);
        this.orientation = ori != null ? ori : new Angle(Math.random() * 360.0, "Degrees");
        this.velocityLinear = new Vector();
        this.velocityAngular = new Angle();
        this.timeInFrame = 0.0;
        this.lastScan = new Scan(new Angle(0.0, "D"), new Angle(20.0, "D"), 0.0, new Vector(), Double.NEGATIVE_INFINITY);
        this.lastSonarTrace = null;
        this.proximityScanLaunchable = null;
        this.proximityScanDroppable = null;
        this.timeOfLauncherReloaded = 0.0 + Constants.PROJECTILE_RELOADTIME;
        this.timeOfDropperReloaded = 0.0 + Constants.MINE_RELOADTIME;
    }

    public Vector getPos() {
        return this.pos;
    }

    public Angle getOrientation() {
        return this.orientation;
    }

    public boolean isBoosting() {
        if (this.pilot != null && this.pilot.getBoosterCommand()) {
            this.boostingFrames = 20;
        }
        if (this.boostingFrames > 0) {
            --this.boostingFrames;
            return true;
        }
        return false;
    }

    public boolean isScannerReloaded(double simulationTime) {
        return simulationTime >= this.pilot.getLastScan().timeOfScan + 0.1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Launchable[] launch(double simulationTime) {
        Angle shootDir = this.pilot.getCannonCommand();
        if (shootDir == null) return null;
        switch (this.pilot.getLauncherAmmunition()) {
            case PROJECTILE_AP: {
                if (!this.depleteEnergyBulky(0.3)) {
                    return null;
                }
                this.pilot.setLaunchCommand(null);
                this.setTimeOfLauncherReloaded(simulationTime + Constants.PROJECTILE_RELOADTIME);
                Launchable[] result = new Launchable[]{new Projectile(simulationTime, this.pos, shootDir, new Vector(shootDir, 50.0), this.ID)};
                return result;
            }
            case PROJECTILE_DOUBLE_BARREL_AP: {
                Launchable[] result;
                if (!this.depleteEnergyBulky(0.3)) {
                    return null;
                }
                this.pilot.setLaunchCommand(null);
                this.setTimeOfLauncherReloaded(simulationTime + Constants.PROJECTILE_RELOADTIME);
                if (this.depleteEnergyBulky(0.3)) {
                    result = new Launchable[2];
                    result[1] = new Projectile(simulationTime, this.pos.add(new Vector(shootDir.getNextQuadrant(), 0.5)), shootDir, new Vector(shootDir, 50.0), this.ID);
                    return result;
                } else {
                    result = new Launchable[]{new Projectile(simulationTime, this.pos.add(new Vector(shootDir.getPreviousQuadrant(), 0.5)), shootDir, new Vector(shootDir, 50.0), this.ID)};
                }
                return result;
            }
            case BULLET_AP: {
                if (!this.depleteEnergyBulky(0.056999999999999995)) {
                    return null;
                }
                this.pilot.setLaunchCommand(null);
                Bullet obj = new Bullet(simulationTime, this.pos, shootDir, this.ID);
                this.setTimeOfLauncherReloaded(simulationTime + obj.LAUNCHER_REFRACTORY_PERIOD());
                Launchable[] result = new Launchable[]{obj};
                return result;
            }
            case MISSILE_HE: {
                if (!this.depleteEnergyBulky(0.54)) {
                    return null;
                }
                this.pilot.setLaunchCommand(null);
                this.setTimeOfLauncherReloaded(simulationTime + Constants.MISSILE_RELOADTIME);
                Missile missile = new Missile(simulationTime, this.pos, shootDir, new Vector(shootDir, 12.8), null, this.ID);
                this.missileLink.add(missile);
                Launchable[] result = new Launchable[]{missile};
                return result;
            }
            case VARIABLE_MINIMISSILES_AP_HE: {
                int numMissiles = 0;
                if (!this.depleteEnergyBulky(0.33)) return null;
                numMissiles = 2;
                while (this.depleteEnergyBulky(0.165)) {
                    ++numMissiles;
                }
                return this.launchMiniMissiles(numMissiles, simulationTime);
            }
            case DUAL_MINIMISSILE_AP_HE: {
                if (this.depleteEnergyBulky(0.66)) {
                    return this.launchMiniMissiles(4, simulationTime);
                }
                if (!this.depleteEnergyBulky(0.33)) return null;
                return this.launchMiniMissiles(2, simulationTime);
            }
            case ROCKET_AP: {
                if (!this.depleteEnergyBulky(0.3)) {
                    return null;
                }
                this.pilot.setLaunchCommand(null);
                Rocket rocket = new Rocket(simulationTime, this.pos, shootDir, this.velocityLinear, null, this.ID);
                this.missileLink.add(rocket);
                Launchable[] result = new Launchable[]{rocket};
                return result;
            }
            case MINETHROWER_HE: {
                if (!this.depleteEnergyBulky(0.36)) {
                    return null;
                }
                this.pilot.setLaunchCommand(null);
                double range = this.pilot.getCannonRange();
                Minethrower grenade = new Minethrower(simulationTime, this.pos, shootDir, range, this.ID);
                Launchable[] result = new Launchable[]{grenade};
                return result;
            }
        }
        return null;
    }

    private Launchable[] launchMiniMissiles(int numMissiles, double simulationTime) {
        if (numMissiles == 0) {
            return null;
        }
        this.setTimeOfLauncherReloaded(simulationTime + Constants.MISSILE_RELOADTIME);
        Angle mDir = this.pilot.getCannonCommand();
        double mRange = this.pilot.getCannonRange();
        this.pilot.setLaunchCommand(null);
        Vector missileTarget = this.pos.add(new Vector(mDir, mRange));
        ArrayList<MiniMissile> result = new ArrayList<MiniMissile>();
        int i = 0;
        while (i < numMissiles) {
            Angle deviationFromFront = MiniMissile.EJECTION_ANGLE.mult(i / 2 + 1).mult(i % 2 == 0 ? 1 : -1);
            Angle mMissileDir = this.orientation.add(deviationFromFront);
            MiniMissile miniMissile = new MiniMissile(simulationTime, this.pos.add(new Vector(mMissileDir, 4.0)), mMissileDir, new Vector(mMissileDir, 16.0), missileTarget, this.ID);
            result.add(miniMissile);
            ++i;
        }
        return result.toArray(new Launchable[0]);
    }

    public Droppable[] drop(double simulationTime) {
        if (this.pilot.getMineCommand() != null) {
            switch (this.pilot.getMineCommand()) {
                case NOTHING: {
                    this.pilot.setDropMineCommand(Pilot.DropperCommand.NOTHING);
                    return null;
                }
                case MINE: {
                    if (!this.depleteEnergyBulky(0.18)) {
                        return null;
                    }
                    this.pilot.setDropMineCommand(Pilot.DropperCommand.NOTHING);
                    Mine mine = new Mine(this.pos, this.ID, this.pilot.getBodyColor());
                    this.setTimeOfDropperReloaded(simulationTime + ((Droppable)mine).DROPPER_REFRACTORY_PERIOD());
                    return new Droppable[]{mine};
                }
                case TANK_TRAP: 
                case DOUBLE_TRAP: 
                case TRIPLE_TRAP: {
                    int maxTraps;
                    switch (this.pilot.getMineCommand()) {
                        case TRIPLE_TRAP: {
                            maxTraps = 3;
                            break;
                        }
                        case DOUBLE_TRAP: {
                            maxTraps = 2;
                            break;
                        }
                        case TANK_TRAP: {
                            maxTraps = 1;
                            break;
                        }
                        default: {
                            return null;
                        }
                    }
                    int trapsToLay = 0;
                    while (maxTraps > 0 && this.depleteEnergyBulky(0.09)) {
                        --maxTraps;
                        ++trapsToLay;
                    }
                    if (trapsToLay == 0) {
                        return null;
                    }
                    this.pilot.setDropMineCommand(Pilot.DropperCommand.NOTHING);
                    ArrayList<Vector> trapPositions = new ArrayList<Vector>();
                    switch (trapsToLay) {
                        case 1: {
                            trapPositions.add(this.pos);
                            break;
                        }
                        case 2: {
                            trapPositions.add(this.pos.add(new Vector(this.orientation.getPreviousQuadrant(), 3.5)));
                            trapPositions.add(this.pos.add(new Vector(this.orientation.getNextQuadrant(), 3.5)));
                            break;
                        }
                        case 3: {
                            trapPositions.add(this.pos.add(new Vector(this.orientation.getPreviousQuadrant(), 3.5)));
                            trapPositions.add(this.pos);
                            trapPositions.add(this.pos.add(new Vector(this.orientation.getNextQuadrant(), 3.5)));
                            break;
                        }
                        default: {
                            return null;
                        }
                    }
                    ArrayList<TankTrap> traps = new ArrayList<TankTrap>();
                    for (Vector trapPos : trapPositions) {
                        TankTrap trap = new TankTrap(trapPos, this.ID, this.pilot.getBodyColor());
                        traps.add(trap);
                        this.setTimeOfDropperReloaded(simulationTime + ((Droppable)trap).DROPPER_REFRACTORY_PERIOD());
                    }
                    return traps.toArray(new Droppable[0]);
                }
            }
        }
        return null;
    }

    public void activateLinkToDirectables() {
        int idx = -1;
        Iterator<Directable> it = this.missileLink.iterator();
        while (it.hasNext()) {
            Angle targetBearing;
            Directable link = it.next();
            ++idx;
            if (link.isDetonating()) {
                it.remove();
                continue;
            }
            Vector destination = this.pilot.getMissileTarget(idx);
            if (destination != null && !destination.equals(link.getDestination())) {
                link.setDestination(destination);
            }
            if ((targetBearing = this.pilot.getRocketBearingTarget(idx)) == null || targetBearing.equals(link.getTargetBearing()) || !this.depleteEnergyBulky(0.054)) continue;
            link.setTargetBearing(targetBearing);
        }
    }

    public MotionTargetPanzer calculateMotion(double elapsedTime) {
        if (elapsedTime < 1.0E-7) {
            return new MotionTargetPanzer(this, this.pos, this.orientation, this.pos, this.orientation, this.velocityLinear, this.velocityAngular, 0.0, 0.0);
        }
        double trackspeedRight = this.pilot.getTrackspeedRight();
        double trackspeedLeft = this.pilot.getTrackspeedLeft();
        double engineEnergyConsumption = (Math.abs(trackspeedRight) + Math.abs(trackspeedLeft)) * 0.027 * elapsedTime;
        if (engineEnergyConsumption != 0.0) {
            double consumedEnergy = this.depleteEnergyFlexibly(engineEnergyConsumption);
            trackspeedRight *= consumedEnergy / engineEnergyConsumption;
            trackspeedLeft *= consumedEnergy / engineEnergyConsumption;
        }
        Vector accelerationLinear = this.linearAcceleration;
        Angle accelerationAngular = this.angularAcceleration;
        double tmpForce = trackspeedRight > 0.0 ? 360000.0 * trackspeedRight : (trackspeedRight < 0.0 ? 251999.99999999997 * trackspeedRight : 0.0);
        Vector gripRight = new Vector(-Math.sin(this.orientation.getValueAsRadians()), Math.cos(this.orientation.getValueAsRadians())).mult(2.0);
        accelerationLinear = accelerationLinear.add(new Vector(this.orientation, 1.0).mult(tmpForce / 40000.0));
        accelerationAngular = accelerationAngular.add(new Angle(tmpForce * gripRight.vectorProduct(new Vector(this.orientation, 1.0)) / 320000.0, "Radians"));
        tmpForce = trackspeedLeft > 0.0 ? 360000.0 * trackspeedLeft : (trackspeedLeft < 0.0 ? 251999.99999999997 * trackspeedLeft : 0.0);
        Vector gripLeft = gripRight.getNegative();
        accelerationLinear = accelerationLinear.add(new Vector(this.orientation, 1.0).mult(tmpForce / 40000.0));
        accelerationAngular = accelerationAngular.add(new Angle(tmpForce * gripLeft.vectorProduct(new Vector(this.orientation, 1.0)) / 320000.0, "Radians"));
        if (this.isBoosting() && this.depleteEnergyBulky(0.8999999999999999 * elapsedTime)) {
            accelerationLinear = accelerationLinear.add(new Vector(this.orientation, 1.0).mult(37.5));
        }
        Vector newVelocityLinear = this.velocityLinear.add(accelerationLinear.mult(elapsedTime));
        Angle newVelocityAngular = this.velocityAngular.add(accelerationAngular.mult(elapsedTime));
        double frictionForceFrontal = 39240.0;
        double frictionForceLateral = 274680.0;
        double frictionMomentAngular = 137340.0;
        double frictionDecelerationFrontal = frictionForceFrontal / 40000.0;
        double frictionDecelerationLateral = frictionForceLateral / 40000.0;
        double frictionDecelerationAngular = frictionMomentAngular / 320000.0;
        double frictionVelocityChangeFrontal = -frictionDecelerationFrontal * elapsedTime;
        double frictionVelocityChangeLateral = -frictionDecelerationLateral * elapsedTime;
        double frictionVelocitiyChangeAngular = -frictionDecelerationAngular * elapsedTime;
        double velocityFrontal = newVelocityLinear.projection(this.orientation);
        double velocityLateral = newVelocityLinear.projection(this.orientation.add(new Angle(90.0, "d")));
        velocityFrontal = velocityFrontal >= 0.0 ? Math.max(0.0, velocityFrontal + frictionVelocityChangeFrontal) : Math.min(0.0, velocityFrontal - frictionVelocityChangeFrontal);
        velocityLateral = velocityLateral >= 0.0 ? Math.max(0.0, velocityLateral + frictionVelocityChangeLateral) : Math.min(0.0, velocityLateral - frictionVelocityChangeLateral);
        newVelocityAngular = newVelocityAngular.isPositive() ? new Angle(Math.max(0.0, newVelocityAngular.getValueAsRadians() + frictionVelocitiyChangeAngular), "r") : new Angle(Math.min(0.0, newVelocityAngular.getValueAsRadians() - frictionVelocitiyChangeAngular), "r");
        newVelocityAngular = newVelocityAngular.mult(Math.exp(Constants.PANZER_VELOCITY_LOSS_FACTOR_PER_SECOND_ANGULAR * elapsedTime));
        newVelocityLinear = new Vector(velocityFrontal *= Math.exp(Constants.PANZER_VELOCITY_LOSS_FACTOR_PER_SECOND_FRONTAL * elapsedTime), velocityLateral *= Math.exp(Constants.PANZER_VELOCITY_LOSS_FACTOR_PER_SECOND_LATERAL * elapsedTime)).rotate(this.getOrientation());
        Vector newPos = this.pos.add(newVelocityLinear.add(this.velocityLinear).mult(0.5).mult(elapsedTime));
        Angle newOrientation = this.orientation.add(newVelocityAngular.add(this.velocityAngular).mult(0.5).mult(elapsedTime));
        return new MotionTargetPanzer(this, this.pos, this.orientation, newPos, newOrientation, newVelocityLinear, newVelocityAngular, 0.0, elapsedTime);
    }

    public void exertForce(MotionTargetPanzer.PanzerVertex grip, Vector force) {
        Vector gripVector;
        switch (grip) {
            case FRONTRIGHT: {
                gripVector = new Vector(this.orientation.add(new Angle(0.7853981633974483, "r")), Constants.PANZER_DIAGONAL / 2.0);
                break;
            }
            case REARRIGHT: {
                gripVector = new Vector(this.orientation.getNextQuadrant().add(new Angle(0.7853981633974483, "r")), Constants.PANZER_DIAGONAL / 2.0);
                break;
            }
            case REARLEFT: {
                gripVector = new Vector(this.orientation.getOpposite().add(new Angle(0.7853981633974483, "r")), Constants.PANZER_DIAGONAL / 2.0);
                break;
            }
            default: {
                gripVector = new Vector(this.orientation.getPreviousQuadrant().add(new Angle(0.7853981633974483, "r")), Constants.PANZER_DIAGONAL / 2.0);
            }
        }
        this.exertForce(gripVector, force);
    }

    public void exertForce(MotionTargetPanzer.PanzerSide grip, Vector force) {
        Vector gripVector;
        switch (grip) {
            case FRONT: {
                gripVector = new Vector(this.orientation.add(MotionTargetPanzer.PanzerSide.FRONT.orientationOffset()), 4.0);
                break;
            }
            case RIGHT: {
                gripVector = new Vector(this.orientation.add(MotionTargetPanzer.PanzerSide.RIGHT.orientationOffset()), 3.0);
                break;
            }
            case REAR: {
                gripVector = new Vector(this.orientation.add(MotionTargetPanzer.PanzerSide.REAR.orientationOffset()), 4.0);
                break;
            }
            default: {
                gripVector = new Vector(this.orientation.add(MotionTargetPanzer.PanzerSide.LEFT.orientationOffset()), 3.0);
            }
        }
        this.exertForce(gripVector, force);
    }

    public void exertForce(Vector gripVector, Vector force) {
        this.linearAcceleration = this.linearAcceleration.add(force.mult(2.5E-5));
        this.angularAcceleration = this.angularAcceleration.add(new Angle(force.vectorProduct(gripVector) / 320000.0, "Radians"));
    }

    public void processPilotCommands(double simulationTime) {
        if (this.pilot != null) {
            this.pilot.setTime(simulationTime);
            this.pilot.setHealth(this.health);
            this.pilot.setEnergy(this.energy);
            this.pilot.setPosition(this.pos);
            this.pilot.setOrientation(this.orientation);
            this.pilot.setVelocity(this.velocityLinear);
            this.pilot.setLastScan(this.lastScan);
            this.pilot.setLastSonarTrace(this.lastSonarTrace);
            this.pilot.setResetBoost();
            this.pilot.setProximityScanLaunchable(this.proximityScanLaunchable);
            this.pilot.setProximityScanDroppable(this.proximityScanDroppable);
            this.pilot.setTimeOfLauncherReloaded(this.timeOfLauncherReloaded);
            this.pilot.setTimeOfDropperReloaded(this.timeOfDropperReloaded);
            this.pilot.setTimeOfScannerReloaded(this.getTimeOfLastScan() + 0.1);
            if (this.pilot.getMineCommand() == null) {
                this.pilot.setDropMineCommand(Pilot.DropperCommand.NOTHING);
            }
            this.pilot.setDirectableInformation(this.missileLink);
            try {
                this.pilot.actions();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public AbstractPilot attachNewPilot(AbstractPilot pilot, double detriment) {
        if (pilot == null || detriment < 0.0) {
            throw new IllegalArgumentException();
        }
        AbstractPilot deported = this.pilot;
        this.pilot = pilot;
        this.health -= detriment;
        return deported;
    }

    public void resetPhysics() {
        this.timeInFrame = 0.0;
        this.linearAcceleration = new Vector();
        this.angularAcceleration = new Angle();
    }

    void applyMotionTarget(MotionTargetPanzer target) {
        assert (target.inceptor == this);
        this.mileageLeft += this.getTrackspeedLeft() >= 0.0 ? (target.targetTime - target.startTime) * this.getTrackspeedLeft() * Constants.PANZER_MAX_SPEED_FORWARD : (target.targetTime - target.startTime) * this.getTrackspeedLeft() * Constants.PANZER_MAX_SPEED_BACKWARD;
        this.mileageRight += this.getTrackspeedRight() >= 0.0 ? (target.targetTime - target.startTime) * this.getTrackspeedRight() * Constants.PANZER_MAX_SPEED_FORWARD : (target.targetTime - target.startTime) * this.getTrackspeedRight() * Constants.PANZER_MAX_SPEED_BACKWARD;
        this.pos = target.endPos;
        this.orientation = target.endOrientation;
        this.velocityLinear = target.velocity;
        this.velocityAngular = target.omega;
    }

    public void init(double simulationTime) {
        this.pilot.setTime(simulationTime);
        this.pilot.setHealth(this.health);
        this.pilot.setPosition(this.pos);
        this.pilot.setOrientation(this.orientation);
        this.pilot.setVelocity(this.velocityLinear);
        this.pilot.setLastScan(this.lastScan);
        this.pilot.setLastSonarTrace(this.lastSonarTrace);
        this.pilot.setResetBoost();
        this.pilot.setProximityScanLaunchable(this.proximityScanLaunchable);
        this.pilot.setProximityScanDroppable(this.proximityScanDroppable);
        this.pilot.setTimeOfLauncherReloaded(this.timeOfLauncherReloaded);
        this.pilot.setTimeOfDropperReloaded(this.timeOfDropperReloaded);
        this.pilot.setTimeOfScannerReloaded(this.getTimeOfLastScan() + 0.1);
        this.pilot.init();
    }

    public final void setLastScan(Scan scan) {
        this.lastScan = scan;
    }

    public final void setLastSonarTrace(SonarTrace sonarTrace) {
        this.lastSonarTrace = sonarTrace;
    }

    public final void setProximityScanLaunchable(ProximityScan proximityPos) {
        this.proximityScanLaunchable = proximityPos;
    }

    public final void setProximityScanDroppable(Vector proximityPos) {
        this.proximityScanDroppable = proximityPos;
    }

    @Deprecated
    public final double getTimeOfLastShot() {
        return this.timeOfLauncherReloaded - Constants.PROJECTILE_RELOADTIME;
    }

    public final void setTimeOfLauncherReloaded(double time) {
        this.timeOfLauncherReloaded = time;
    }

    public double getTimeOfLastScan() {
        if (this.lastScan == null) {
            return Double.NEGATIVE_INFINITY;
        }
        return this.lastScan.timeOfScan;
    }

    public final void setTimeOfDropperReloaded(double time) {
        this.timeOfDropperReloaded = time;
    }

    public final Angle getScanAperture() {
        Angle scanAperture = this.pilot.getScanAperture();
        if (scanAperture == null) {
            return Constants.PANZER_MAX_SCAN_APERTURE;
        }
        if (scanAperture.getValueAsRadians() > Constants.PANZER_MAX_SCAN_APERTURE.getValueAsRadians()) {
            return Constants.PANZER_MAX_SCAN_APERTURE;
        }
        if (scanAperture.getValueAsRadians() < Constants.PANZER_MIN_SCAN_APERTURE.getValueAsRadians()) {
            return Constants.PANZER_MIN_SCAN_APERTURE;
        }
        return scanAperture;
    }

    public final Angle getScanDirection() {
        Angle scanDir = this.pilot.getScanDirection();
        if (scanDir == null) {
            return null;
        }
        return scanDir.normalize();
    }

    public final double getSonarEnergy() {
        return this.pilot.getSonarEnergy();
    }

    public final double getTrackspeedLeft() {
        return this.pilot.getTrackspeedLeft();
    }

    public final double getTrackspeedRight() {
        return this.pilot.getTrackspeedRight();
    }

    public final float[] getDebugLines() {
        return this.pilot.getDebugLines();
    }

    public final String getDebugText() {
        return this.pilot.getDebugText();
    }

    public final AbstractPilot getPilot() {
        return this.pilot;
    }

    @Deprecated
    public Panzer clone() {
        Panzer clone = new Panzer(this.pilot.clone(), this.turretIndex, this.pos, this.orientation);
        clone.ID = this.ID;
        clone.velocityLinear = this.velocityLinear;
        clone.velocityAngular = this.velocityAngular;
        clone.health = this.health;
        clone.energy = this.energy;
        clone.boostingFrames = this.boostingFrames;
        clone.lastScan = this.lastScan;
        clone.lastSonarTrace = this.lastSonarTrace;
        clone.proximityScanLaunchable = this.proximityScanLaunchable;
        clone.proximityScanDroppable = this.proximityScanDroppable;
        clone.timeOfLauncherReloaded = this.timeOfLauncherReloaded;
        clone.timeOfDropperReloaded = this.timeOfDropperReloaded;
        clone.mileageLeft = this.mileageLeft;
        clone.mileageRight = this.mileageRight;
        clone.missileLink = this.missileLink;
        return clone;
    }

    public double getHealth() {
        return this.health;
    }

    public double getMileageLeft() {
        return this.mileageLeft;
    }

    public double getMileageRight() {
        return this.mileageRight;
    }

    void setHealth(double health) {
        this.health = health;
    }

    public double getEnergy() {
        return this.energy;
    }

    public boolean depleteEnergyBulky(double amount) {
        if (amount < 0.0) {
            return false;
        }
        if (amount > this.energy) {
            return false;
        }
        this.energy -= amount;
        return true;
    }

    public double depleteEnergyFlexibly(double amount) {
        if (amount < 0.0) {
            return 0.0;
        }
        if (amount > this.energy) {
            amount = this.energy;
        }
        this.energy -= amount;
        return amount;
    }

    public void chargeEnergy(double generatedEnergy) {
        if (generatedEnergy < 0.0) {
            return;
        }
        double storeFraction = Math.exp((this.energy + generatedEnergy) * -0.2);
        this.energy += generatedEnergy * storeFraction;
    }

    @Override
    public int compareTo(Panzer o) {
        return this.ID - o.ID;
    }

    public int getID() {
        return this.ID;
    }

    public void zombificatePilot() {
        this.pilot = new PilotZombie(this.pilot);
    }
}

