/*
 * Decompiled with CFR 0.152.
 */
package jrobots.simulation.simulationObjects;

import java.awt.Color;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Arrays;
import java.util.List;
import jrobots.simulation.simulationObjects.AbstractPilot;
import jrobots.simulation.simulationObjects.Constants;
import jrobots.simulation.simulationObjects.Directable;
import jrobots.utils.Angle;
import jrobots.utils.ProximityScan;
import jrobots.utils.Scan;
import jrobots.utils.SonarTrace;
import jrobots.utils.Vector;

public abstract class Pilot
extends AbstractPilot {
    private static final long serialVersionUID = 3574587611340469934L;
    protected static final Angle RIGHT = Angle.EAST;
    protected static final Angle DOWN = Angle.SOUTH;
    protected static final Angle LEFT = Angle.WEST;
    protected static final Angle UP = Angle.NORTH;
    private double time;
    private double health;
    private double energy;
    private Vector position;
    private Angle orientation;
    private Vector velocity;
    private Scan lastScan;
    private SonarTrace lastSonarTrace;
    private ProximityScan proximityScanLaunchable;
    private Vector proximityScanDroppable;
    private Vector[] directablePositions;
    private double timeOfLauncherReloaded;
    private double timeOfDropperReloaded;
    private double timeOfScannerReloaded;
    private Angle scanAperture = new Angle(20.0, "d");
    private Angle scanDirection;
    private double sonarEnergy;
    private Angle cannonCommand;
    private double cannonRange = 50.0;
    private LauncherAmmunition launcherAmmunition = LauncherAmmunition.PROJECTILE_AP;
    private Vector[] directableDestinations = new Vector[0];
    private Angle[] directableTargetBearings;
    private DropperCommand mineCommand;
    private boolean useAutopilot;
    private double trackspeedLeft;
    private double trackspeedRight;
    private Angle desiredDirection;
    private double desiredSpeed;
    private boolean boosting = false;
    private String debugText;
    private transient float[] debugLines;
    private Color nameColor = Color.WHITE;
    private Color turretColor = Color.WHITE;
    private Color bodyColor = Color.WHITE;

    @Override
    final Angle getScanAperture() {
        Angle result = this.scanAperture;
        return result;
    }

    @Override
    final Angle getScanDirection() {
        Angle result = this.scanDirection;
        this.scanDirection = null;
        return result;
    }

    @Override
    final double getSonarEnergy() {
        double result = this.sonarEnergy;
        this.sonarEnergy = 0.0;
        return result;
    }

    @Override
    final double getTrackspeedLeft() {
        if (this.useAutopilot) {
            this.calculateAutopilot();
        }
        return this.trackspeedLeft;
    }

    @Override
    final double getTrackspeedRight() {
        if (this.useAutopilot) {
            this.calculateAutopilot();
        }
        return this.trackspeedRight;
    }

    @Override
    final boolean getBoosterCommand() {
        return this.boosting;
    }

    @Override
    final Angle getCannonCommand() {
        return this.cannonCommand;
    }

    @Override
    final double getCannonRange() {
        return this.cannonRange;
    }

    @Override
    final LauncherAmmunition getLauncherAmmunition() {
        return this.launcherAmmunition;
    }

    @Override
    final DropperCommand getMineCommand() {
        return this.mineCommand;
    }

    @Override
    final Vector getMissileTarget(int idx) {
        if (this.directableDestinations.length <= idx) {
            return null;
        }
        return this.directableDestinations[idx];
    }

    @Override
    final Angle getRocketBearingTarget(int idx) {
        if (this.directableTargetBearings == null) {
            return null;
        }
        if (this.directableTargetBearings.length <= idx) {
            return null;
        }
        return this.directableTargetBearings[idx];
    }

    @Override
    final float[] getDebugLines() {
        if (this.debugLines == null) {
            return new float[0];
        }
        return this.debugLines;
    }

    @Override
    final String getDebugText() {
        return this.debugText;
    }

    static double getMaxArenaDiameter() {
        return 100.0;
    }

    static double getMineReloadTime() {
        return Constants.MINE_RELOADTIME;
    }

    static double getTrapReloadTime() {
        return Constants.TANK_TRAP_RELOADTIME;
    }

    static Angle getMaxScanAperture() {
        return Constants.PANZER_MAX_SCAN_APERTURE;
    }

    static double getScanInterval() {
        return 0.1;
    }

    static double getReloadTime() {
        return Constants.PROJECTILE_RELOADTIME;
    }

    static double getBulletReloadTime() {
        return Constants.BULLET_RELOADTIME;
    }

    static double getMissileReloadTime() {
        return Constants.MISSILE_RELOADTIME;
    }

    static double getProjectileSpeed() {
        return 50.0;
    }

    static double getBulletSpeed() {
        return 90.0;
    }

    static double getMissileSpeedMax() {
        return 64.0;
    }

    static double getRocketSpeedMax() {
        return 52.0;
    }

    protected final double getTime() {
        return this.time;
    }

    @Override
    public final double getHealth() {
        return this.health;
    }

    @Override
    public final double getEnergy() {
        return this.energy;
    }

    @Override
    Scan getLastScan() {
        return this.lastScan;
    }

    @Override
    SonarTrace getLastSonarTrace() {
        return this.lastSonarTrace;
    }

    ProximityScan getProximityScanFromLaunchable() {
        return this.proximityScanLaunchable;
    }

    Vector getProximityScanDroppable() {
        return this.proximityScanDroppable;
    }

    Vector[] getDirectablePositions() {
        return this.directablePositions;
    }

    Vector getPosition() {
        return this.position;
    }

    Angle getOrientation() {
        return this.orientation;
    }

    Vector getVelocity() {
        return this.velocity;
    }

    static double getMaxForwardVelocity() {
        return Constants.PANZER_MAX_SPEED_FORWARD;
    }

    static double getMaxBackwardVelocity() {
        return Constants.PANZER_MAX_SPEED_BACKWARD;
    }

    double getTimeOfLauncherReloaded() {
        return this.timeOfLauncherReloaded;
    }

    double getTimeOfDropperReloaded() {
        return this.timeOfDropperReloaded;
    }

    double getTimeOfScannerReloaded() {
        return this.timeOfScannerReloaded;
    }

    @Override
    public final String getName() {
        return this.getClass().getSimpleName();
    }

    @Override
    public final Color getNameColor() {
        return this.nameColor;
    }

    @Override
    public final Color getTurretColor() {
        return this.turretColor;
    }

    @Override
    public final Color getBodyColor() {
        return this.bodyColor;
    }

    @Override
    final void setTime(double time) {
        this.time = time;
    }

    @Override
    final void setHealth(double health) {
        this.health = health;
    }

    @Override
    final void setEnergy(double energy) {
        this.energy = energy;
    }

    @Override
    final void setPosition(Vector position) {
        this.position = position;
    }

    @Override
    final void setOrientation(Angle orientation) {
        this.orientation = orientation.normalize();
    }

    @Override
    final void setVelocity(Vector v) {
        this.velocity = v;
    }

    @Override
    final void setTimeOfLauncherReloaded(double time) {
        this.timeOfLauncherReloaded = time;
    }

    @Override
    final void setTimeOfDropperReloaded(double time) {
        this.timeOfDropperReloaded = time;
    }

    @Override
    final void setTimeOfScannerReloaded(double timeOfScannerReloaded) {
        this.timeOfScannerReloaded = timeOfScannerReloaded;
    }

    @Override
    final void setLastScan(Scan lastScan) {
        this.lastScan = lastScan;
    }

    @Override
    final void setLastSonarTrace(SonarTrace lastSonarTrace) {
        this.lastSonarTrace = lastSonarTrace;
    }

    @Override
    final void setProximityScanLaunchable(ProximityScan proximityScanLaunchable) {
        this.proximityScanLaunchable = proximityScanLaunchable;
    }

    @Override
    final void setProximityScanDroppable(Vector proximityScanDroppable) {
        this.proximityScanDroppable = proximityScanDroppable;
    }

    @Override
    final void setDirectableInformation(List<Directable> directables) {
        if (this.directablePositions == null || this.directablePositions.length != directables.size()) {
            this.directablePositions = new Vector[directables.size()];
        }
        if (this.directableDestinations == null || this.directableDestinations.length != directables.size()) {
            this.directableDestinations = new Vector[directables.size()];
        }
        if (this.directableTargetBearings == null || this.directableTargetBearings.length != directables.size()) {
            this.directableTargetBearings = new Angle[directables.size()];
        }
        int i = 0;
        while (i < directables.size()) {
            Directable link = directables.get(i);
            this.directablePositions[i] = link.getPosition();
            this.directableDestinations[i] = link.getDestination();
            this.directableTargetBearings[i] = link.getTargetBearing();
            ++i;
        }
    }

    void setScanAperture(Angle aperture) {
        this.scanAperture = aperture == null ? null : aperture.normalize();
    }

    void setScanDirection(Angle scanDirection) {
        this.scanDirection = scanDirection == null ? null : scanDirection.normalize();
    }

    void setSonarEnergy(double energy) {
        if (energy <= 0.0) {
            this.sonarEnergy = 0.0;
        }
        this.sonarEnergy = energy;
    }

    void setAutopilot(Angle direction, double speed) {
        this.desiredDirection = direction.normalize();
        this.desiredSpeed = speed;
        this.useAutopilot = true;
    }

    void setBoost() {
        this.boosting = true;
    }

    @Override
    final void setResetBoost() {
        this.boosting = false;
    }

    @Override
    final void setLaunchCommand(Angle command) {
        this.cannonCommand = command;
        switch (this.launcherAmmunition) {
            case BULLET_AP: {
                this.energy -= 0.056999999999999995;
                break;
            }
            case PROJECTILE_AP: {
                this.energy -= 0.3;
                break;
            }
            case PROJECTILE_DOUBLE_BARREL_AP: {
                this.energy -= 0.3;
                if (!(this.energy > 0.3)) break;
                this.energy -= 0.3;
                break;
            }
            case MISSILE_HE: {
                this.energy -= 0.54;
                break;
            }
            case VARIABLE_MINIMISSILES_AP_HE: {
                if (!(this.energy > 0.66)) break;
                while (this.energy > 0.33) {
                    this.energy -= 0.33;
                }
                break;
            }
            case DUAL_MINIMISSILE_AP_HE: {
                this.energy -= 0.33;
                if (!(this.energy > 0.33)) break;
                this.energy -= 0.33;
                break;
            }
            case ROCKET_AP: {
                this.energy -= 0.3;
                break;
            }
            case MINETHROWER_HE: {
                this.energy -= 0.36;
                break;
            }
            default: {
                System.err.println("unknown launcher ammunition - pilot's energy indication will be incorrect");
            }
        }
    }

    @Override
    void setLaunchProjectileCommand(Angle command, double range) {
        this.setLaunchCommand(command);
        this.cannonRange = range;
    }

    void setLauncherAmmunition(LauncherAmmunition ammoType) {
        if (ammoType != null) {
            this.launcherAmmunition = ammoType;
        }
        assert (ammoType != null);
    }

    @Override
    void setDropMineCommand(DropperCommand cmd) {
        switch (cmd) {
            case MINE: {
                this.energy -= 0.18;
                break;
            }
            case TANK_TRAP: {
                this.energy -= 0.09;
                break;
            }
            case DOUBLE_TRAP: {
                int i = 0;
                while (i < 2) {
                    if (this.energy >= 0.09) {
                        this.energy -= 0.09;
                    }
                    ++i;
                }
                break;
            }
            case TRIPLE_TRAP: {
                int i = 0;
                while (i < 3) {
                    if (this.energy >= 0.09) {
                        this.energy -= 0.09;
                    }
                    ++i;
                }
                break;
            }
            case NOTHING: {
                break;
            }
            default: {
                System.err.println("unknown dropper ammunition - pilot's energy indication will be incorrect");
            }
        }
        this.mineCommand = cmd;
    }

    void setMissileTarget(int directableNumber, Vector targetPosition) {
        if (directableNumber > 256 + this.directableDestinations.length) {
            throw new IllegalArgumentException("Too high a number: " + directableNumber + " - only " + this.directableDestinations.length + " directables known.");
        }
        if (directableNumber + 1 > this.directableDestinations.length) {
            this.directableDestinations = Arrays.copyOf(this.directableDestinations, directableNumber + 1);
        }
        this.directableDestinations[directableNumber] = targetPosition;
    }

    void setRocketHeading(int directableNumber, Angle targetBearing) {
        if (directableNumber > 256 + this.directableTargetBearings.length) {
            throw new IllegalArgumentException("Too high a number: " + directableNumber + " - only " + this.directableTargetBearings.length + " directables known.");
        }
        if (directableNumber + 1 > this.directableTargetBearings.length) {
            this.directableTargetBearings = Arrays.copyOf(this.directableTargetBearings, directableNumber + 1);
        }
        this.directableTargetBearings[directableNumber] = targetBearing;
    }

    void setDebugText(String text) {
        this.debugText = text == null ? "" : text;
    }

    void setDebugLines(Vector[] points) {
        if (points != null && points.length % 2 == 0) {
            int i = 0;
            while (i < points.length) {
                this.addDebugLine(points[i], points[i + 1]);
                i += 2;
            }
        }
    }

    void addDebugLine(Vector p1, Vector p2) {
        this.addDebugLine((float)p1.getX(), (float)p1.getY(), (float)p2.getX(), (float)p2.getY());
    }

    void addDebugCrosshair(Vector position) {
        Vector left = new Vector(2.0, 2.0);
        Vector right = new Vector(2.0, -2.0);
        this.addDebugLine(position.sub(left), position.add(left));
        this.addDebugLine(position.sub(right), position.add(right));
    }

    void addDebugArrow(Vector start, Vector end) {
        Vector v = start.sub(end);
        if (v.getLength() == 0.0) {
            return;
        }
        this.addDebugLine(start, end);
        v = v.getNormal().mult(2.0).rotate(new Angle(30.0, "D"));
        this.addDebugLine(end, end.add(v));
        v = v.rotate(new Angle(-60.0, "D"));
        this.addDebugLine(end, end.add(v));
    }

    void addDebugLine(float x1, float y1, float x2, float y2) {
        if (this.debugLines == null) {
            this.debugLines = new float[4];
        } else {
            float[] oldLines = this.debugLines;
            this.debugLines = new float[this.debugLines.length + 4];
            System.arraycopy(oldLines, 0, this.debugLines, 0, oldLines.length);
            oldLines = null;
        }
        this.debugLines[this.debugLines.length - 4] = x1;
        this.debugLines[this.debugLines.length - 3] = y1;
        this.debugLines[this.debugLines.length - 2] = x2;
        this.debugLines[this.debugLines.length - 1] = y2;
    }

    void setNameColor(Color newNameColor) {
        if (newNameColor != null) {
            this.nameColor = newNameColor;
        }
    }

    void setTurretColor(Color newColor) {
        if (newColor != null) {
            this.turretColor = new Color(newColor.getRed(), newColor.getGreen(), newColor.getBlue());
        }
    }

    void setBodyColor(Color newColor) {
        if (newColor != null) {
            this.bodyColor = new Color(newColor.getRed(), newColor.getGreen(), newColor.getBlue());
        }
    }

    @Override
    abstract void actions();

    @Override
    protected void init() {
        this.launcherAmmunition = LauncherAmmunition.PROJECTILE_AP;
        this.mineCommand = DropperCommand.NOTHING;
    }

    private final void calculateAutopilot() {
        double delta = this.desiredDirection.getValueAsRadians() - this.getOrientation().getValueAsRadians();
        if (delta > Math.PI) {
            delta -= Math.PI * 2;
        }
        if (delta < -Math.PI) {
            delta += Math.PI * 2;
        }
        delta /= 2.0;
        delta = Math.sin(delta);
        if (this.desiredSpeed < -1.0) {
            this.desiredSpeed = -1.0;
        }
        if (this.desiredSpeed > 1.0) {
            this.desiredSpeed = 1.0;
        }
        double toomuchSpeed = Math.max(Math.abs(this.desiredSpeed) + Math.abs(delta) - 1.0, 0.0);
        double basicSpeed = this.desiredSpeed >= 0.0 ? this.desiredSpeed - toomuchSpeed : this.desiredSpeed + toomuchSpeed;
        this.trackspeedLeft = basicSpeed + delta;
        this.trackspeedRight = basicSpeed - delta;
    }

    @Override
    @Deprecated
    public final Pilot clone() {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(this);
            this.memoryConsumption = baos.size();
            ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
            ObjectInputStream ois = new ObjectInputStream(bais);
            return (Pilot)ois.readObject();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(String.valueOf(this.getClass().getSimpleName()) + ".clone() is not working");
        }
    }

    protected static enum DropperCommand {
        NOTHING,
        MINE,
        TANK_TRAP,
        DOUBLE_TRAP,
        TRIPLE_TRAP;

    }

    protected static enum LauncherAmmunition {
        PROJECTILE_AP,
        PROJECTILE_DOUBLE_BARREL_AP,
        BULLET_AP,
        MISSILE_HE,
        VARIABLE_MINIMISSILES_AP_HE,
        DUAL_MINIMISSILE_AP_HE,
        ROCKET_AP,
        MINETHROWER_HE;

    }
}

