/*
 * Decompiled with CFR 0.152.
 */
package jrobots.simulation.simulationObjects;

import java.util.concurrent.locks.ReentrantLock;
import jrobots.simulation.SimulationRun;
import jrobots.simulation.simulationObjects.Panzer;

public class PilotCommandProcessor
extends Thread {
    private volatile Panzer panzer;
    private double simulationTime;
    private Thread controllerThread;
    public ReentrantLock lock = new ReentrantLock();

    public void newJob(Panzer panzer, double simulationTime, Thread controllerThread) {
        this.lock.lock();
        this.panzer = panzer;
        if (simulationTime < 0.0) {
            throw new IllegalArgumentException("simulationTime must be >= 0");
        }
        this.simulationTime = simulationTime;
        this.controllerThread = controllerThread;
        this.lock.unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            while (true) {
                this.lock.lock();
                if (this.panzer != null) {
                    long nanoTime = System.nanoTime();
                    this.panzer.processPilotCommands(this.simulationTime);
                    nanoTime = System.nanoTime() - nanoTime;
                    this.panzer = null;
                }
                this.lock.unlock();
                PilotCommandProcessor pilotCommandProcessor = this;
                synchronized (pilotCommandProcessor) {
                    this.notify();
                }
                Thread.yield();
            }
        }
        catch (Exception e) {
            System.err.print("Exception in frame " + SimulationRun.simulationRun.getStateCount());
            if (this.panzer != null && this.panzer.getPilot() != null) {
                System.err.print(" at " + this.panzer.getPilot().getClass().getSimpleName());
            }
            System.err.println(": " + e.getClass() + "\n" + e.getMessage());
            e.printStackTrace();
            return;
        }
    }

    public boolean isJobDone() {
        return this.panzer == null;
    }
}

