/*
 * Decompiled with CFR 0.152.
 */
package jrobots.simulation.simulationObjects.droppables;

import java.awt.Color;
import java.io.Serializable;
import javax.media.opengl.GL;
import jrobots.graphics.ArenaController;
import jrobots.simulation.SimulationState;
import jrobots.simulation.simulationObjects.Collision;
import jrobots.simulation.simulationObjects.MotionTargetLaunchable;
import jrobots.simulation.simulationObjects.MotionTargetPanzer;
import jrobots.simulation.simulationObjects.Panzer;
import jrobots.utils.Vector;

public abstract class Droppable
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected int ownerID;
    protected Color bodyColor;
    protected Vector pos;
    protected double age;
    protected double maxAge;
    protected boolean isArmed = false;
    protected transient boolean isDetonating = false;

    protected Droppable(Vector pos, int ownerID, Color color) {
        this.pos = pos;
        this.maxAge = 0.2 * this.LIFE_TIME_AVG() - 0.8 * this.LIFE_TIME_AVG() * Math.log(Math.random());
        this.ownerID = ownerID;
        this.bodyColor = color;
    }

    public final void calculateMotion(SimulationState state, double elapsedTime) {
        this.age += elapsedTime;
        if (!this.isArmed) {
            Panzer panzer = state.getPanzerByID(this.ownerID);
            if (panzer == null) {
                this.isArmed = true;
            } else if (this.pos.distanceTo(panzer.getPos()) > this.TRIGGER_RADIUS() + 4.0) {
                this.isArmed = true;
            }
        }
    }

    public final Vector getPos() {
        return this.pos;
    }

    public final double getAge() {
        return this.age;
    }

    public final boolean isArmed() {
        return this.isArmed;
    }

    public final boolean isDetonating() {
        return this.isDetonating;
    }

    public abstract void checkTrigger(SimulationState var1, MotionTargetPanzer var2);

    public final double getMaxAge() {
        return this.maxAge;
    }

    public abstract Droppable clone();

    public final int getOwnerID() {
        return this.ownerID;
    }

    public final Color getColor() {
        return this.bodyColor;
    }

    public abstract double LIFE_TIME_AVG();

    public abstract double TRIGGER_RADIUS();

    public abstract double LAUNCHABLE_TRIGGER_RADIUS();

    public abstract double DROPPER_REFRACTORY_PERIOD();

    public abstract Collision discoverCollision(MotionTargetPanzer var1);

    public abstract Collision discoverCollision(MotionTargetLaunchable var1);

    public abstract void draw(GL var1, ArenaController var2, double var3);
}

