/*
 * Decompiled with CFR 0.152.
 */
package jrobots.simulation.simulationObjects.droppables;

import java.awt.Color;
import javax.media.opengl.GL;
import jrobots.graphics.ArenaController;
import jrobots.simulation.SimulationState;
import jrobots.simulation.simulationObjects.Collision;
import jrobots.simulation.simulationObjects.CollisionPanzerExplosion;
import jrobots.simulation.simulationObjects.Explosion;
import jrobots.simulation.simulationObjects.MotionTargetLaunchable;
import jrobots.simulation.simulationObjects.MotionTargetPanzer;
import jrobots.simulation.simulationObjects.droppables.Droppable;
import jrobots.utils.Vector;

public class Mine
extends Droppable {
    private static final long serialVersionUID = 1L;
    public static final int EXPLOSION_SIZE = 20;
    public static final double TRIGGER_RADIUS = 5.0;
    public static final double DETONATION_INNER_RADIUS = 5.0;
    public static final double DETONATION_OUTER_RADIUS = 20.0;
    public static final double DETONATION_MAX_DAMAGE = 0.26;
    public static final double DETONATION_MAX_FORCE = 2.5E7;

    public Mine(Vector pos, int ownerID, Color color) {
        super(pos, ownerID, color);
    }

    @Override
    public void checkTrigger(SimulationState state, MotionTargetPanzer panzerTgt) {
        if (this.isArmed && panzerTgt.calculateCenterDistance(this.pos) <= this.TRIGGER_RADIUS()) {
            this.isDetonating = true;
            state.getExplosions().put(state.timestamp, new Explosion(this.pos, panzerTgt.getInceptor().getOrientation(), state.timestamp, 20));
        }
    }

    @Override
    public Mine clone() {
        Mine clone = new Mine(this.pos, this.ownerID, this.bodyColor);
        clone.age = this.age;
        clone.maxAge = this.maxAge;
        clone.isDetonating = this.isDetonating;
        clone.isArmed = this.isArmed;
        return clone;
    }

    @Override
    public double TRIGGER_RADIUS() {
        return 5.0;
    }

    @Override
    public double LAUNCHABLE_TRIGGER_RADIUS() {
        return -1.0;
    }

    public double LIFETIME_AVG() {
        return 25.0;
    }

    @Override
    public double DROPPER_REFRACTORY_PERIOD() {
        return 5.0;
    }

    @Override
    public double LIFE_TIME_AVG() {
        return 25.0;
    }

    @Override
    public Collision discoverCollision(MotionTargetPanzer panzerTgt) {
        if (this.isDetonating) {
            double distance = panzerTgt.calculateCenterDistance(this.getPos());
            if (distance <= 20.0) {
                return new CollisionPanzerExplosion(panzerTgt, this.pos, 20.0, 5.0, 0.26, 2.5E7);
            }
            return null;
        }
        return null;
    }

    @Override
    public Collision discoverCollision(MotionTargetLaunchable projTgt) {
        return null;
    }

    @Override
    public void draw(GL gl, ArenaController arenaController, double timestamp) {
        arenaController.drawMine(gl, this, timestamp, this.isArmed);
    }
}

