/*
 * Decompiled with CFR 0.152.
 */
package jrobots.simulation.simulationObjects.droppables;

import java.awt.Color;
import javax.media.opengl.GL;
import jrobots.graphics.ArenaController;
import jrobots.simulation.SimulationState;
import jrobots.simulation.simulationObjects.Collision;
import jrobots.simulation.simulationObjects.CollisionDroppableLaunchable;
import jrobots.simulation.simulationObjects.CollisionPanzerTankTrap;
import jrobots.simulation.simulationObjects.MotionTargetLaunchable;
import jrobots.simulation.simulationObjects.MotionTargetPanzer;
import jrobots.simulation.simulationObjects.droppables.Droppable;
import jrobots.utils.Vector;

public class TankTrap
extends Droppable {
    private static final long serialVersionUID = 1L;
    public static final double MAX_HINDRANCE_TIME = 5.0;

    public TankTrap(Vector pos, int ownerID, Color color) {
        super(pos, ownerID, color);
    }

    @Override
    public void checkTrigger(SimulationState state, MotionTargetPanzer panzerTgt) {
    }

    @Override
    public Droppable clone() {
        TankTrap clone = new TankTrap(this.pos, this.ownerID, this.bodyColor);
        clone.age = this.age;
        clone.maxAge = this.maxAge;
        clone.isDetonating = this.isDetonating;
        clone.isArmed = this.isArmed;
        return clone;
    }

    @Override
    public double TRIGGER_RADIUS() {
        return 7.0;
    }

    @Override
    public double LAUNCHABLE_TRIGGER_RADIUS() {
        return 4.0;
    }

    @Override
    public double LIFE_TIME_AVG() {
        return 30.0;
    }

    @Override
    public double DROPPER_REFRACTORY_PERIOD() {
        return 5.0;
    }

    @Override
    public Collision discoverCollision(MotionTargetPanzer panzerTgt) {
        if (this.isArmed) {
            double distance = panzerTgt.calculateCenterDistance(this.pos);
            if (distance <= this.TRIGGER_RADIUS()) {
                if (panzerTgt.getEndPos().distanceTo(this.pos) < distance) {
                    if (this.maxAge - this.getAge() > 5.0) {
                        this.maxAge = this.getAge() + 5.0 * Math.random();
                    }
                    return new CollisionPanzerTankTrap(panzerTgt, this, panzerTgt.calculateCenterDistance(this.pos));
                }
                return null;
            }
            return null;
        }
        return null;
    }

    @Override
    public Collision discoverCollision(MotionTargetLaunchable projTgt) {
        if (this.isArmed) {
            double distance = projTgt.calculateCenterDistance(this.pos);
            if (distance <= this.LAUNCHABLE_TRIGGER_RADIUS()) {
                if (projTgt.getEndPos().distanceTo(this.pos) < distance) {
                    if (this.maxAge - this.getAge() > 5.0) {
                        this.maxAge = this.getAge() + 1.5 * Math.random();
                    }
                    return new CollisionDroppableLaunchable(0.0, projTgt, this);
                }
                return null;
            }
            return null;
        }
        return null;
    }

    @Override
    public void draw(GL gl, ArenaController arenaController, double timestamp) {
        arenaController.drawTankTrap(gl, this, timestamp, this.isArmed);
    }
}

