/*
 * Decompiled with CFR 0.152.
 */
package jrobots.simulation.simulationObjects.launchables;

import javax.media.opengl.GL;
import jrobots.graphics.ArenaController;
import jrobots.graphics.SmokeGenerator;
import jrobots.simulation.SimulationState;
import jrobots.simulation.simulationObjects.Collision;
import jrobots.simulation.simulationObjects.CollisionPanzerLaunchable;
import jrobots.simulation.simulationObjects.MotionTargetLaunchable;
import jrobots.simulation.simulationObjects.MotionTargetPanzer;
import jrobots.simulation.simulationObjects.launchables.Launchable;
import jrobots.utils.Angle;
import jrobots.utils.Vector;

public class Bullet
extends Launchable {
    private static final long serialVersionUID = 6817064572275326694L;
    public static final double MUZZLE_VELOCITY = 90.0;
    public static final double RELOADTIME = 0.1;
    public static final double LIFE_TIME = 3.3333333333333335;
    public static final double DAMAGE_FRONT = 0.005;
    public static final double DAMAGE_SIDE = 0.01;
    public static final double DAMAGE_REAR = 0.04;
    public static final int EXPLOSION_SIZE = 1;
    public static final double FORCE_HIT = 1000000.0;
    protected final SmokeGenerator smokeGenerator = new SmokeGenerator(40.0, 0.0, 0.5);

    @Override
    public double MUZZLE_VELOCITY() {
        return 90.0;
    }

    @Override
    public double MAX_VELOCITY() {
        return 90.0;
    }

    @Override
    public double LAUNCHER_REFRACTORY_PERIOD() {
        return 0.1;
    }

    @Override
    public double DAMAGE_FRONT() {
        return 0.005;
    }

    @Override
    public double DAMAGE_SIDE() {
        return 0.01;
    }

    @Override
    public double DAMAGE_REAR() {
        return 0.04;
    }

    @Override
    public double LIFE_TIME() {
        return 3.3333333333333335;
    }

    @Override
    public int EXPLOSION_SIZE() {
        return 1;
    }

    @Override
    public double FORCE_HIT() {
        return 1000000.0;
    }

    public Bullet(double creationTime, Vector pos, Angle orientation, int ownerID) {
        super(creationTime, pos, orientation, new Vector(orientation, 90.0), ownerID);
        SmokeGenerator sG = new SmokeGenerator(150.0, 0.5, 1.0);
        sG.generateSmoke(pos, pos.add(new Vector(orientation, 2.0)), this.creationTime, this.creationTime + 0.1, new Vector(orientation, 2.0));
    }

    @Override
    public Bullet clone() {
        Bullet clone = new Bullet(this.creationTime, this.pos, this.orientation, this.ownerID);
        clone.age = this.age;
        return clone;
    }

    @Override
    public MotionTargetLaunchable calculateMotion(SimulationState state, double elapsedTime) {
        this.velocity = new Vector(this.velocity.getLength(), this.getOrientation());
        return super.calculateMotion(state, elapsedTime);
    }

    @Override
    public void applyMotionTarget(MotionTargetLaunchable target) {
        this.smokeGenerator.generateSmoke(target.startPos, target.endPos, this.creationTime + this.age, this.creationTime + this.age + target.targetTime, new Vector(target.orientation, 20.0));
        super.applyMotionTarget(target);
    }

    @Override
    public Collision discoverCollision(MotionTargetLaunchable ownTgt, MotionTargetPanzer panzerTgt) {
        if (this.age <= 1.0 && panzerTgt.getInceptor().getID() == this.ownerID) {
            return null;
        }
        return CollisionPanzerLaunchable.discoverCollision(panzerTgt, ownTgt);
    }

    @Override
    public void draw(GL gl, ArenaController arena) {
        arena.drawBullet(gl, this);
    }

    @Override
    public void detonate() {
    }
}

