/*
 * Decompiled with CFR 0.152.
 */
package jrobots.simulation.simulationObjects.launchables;

import java.io.Serializable;
import javax.media.opengl.GL;
import jrobots.graphics.ArenaController;
import jrobots.simulation.SimulationState;
import jrobots.simulation.simulationObjects.Collision;
import jrobots.simulation.simulationObjects.MotionTargetLaunchable;
import jrobots.simulation.simulationObjects.MotionTargetPanzer;
import jrobots.utils.Angle;
import jrobots.utils.Vector;

public abstract class Launchable
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected int ownerID;
    protected Vector pos;
    protected Angle orientation;
    protected Vector velocity;
    protected final double creationTime;
    protected double age;
    protected transient double timeInFrame;

    public Launchable(double creationTime, Vector pos, Angle orientation, Vector velocity, int ownerID) {
        this.creationTime = creationTime;
        this.pos = pos;
        this.orientation = orientation;
        this.velocity = velocity;
        this.timeInFrame = 0.0;
        this.age = 0.0;
        this.ownerID = ownerID;
    }

    public final double getAge() {
        return this.age;
    }

    public abstract Launchable clone();

    public final int getOwnerID() {
        return this.ownerID;
    }

    public abstract double MUZZLE_VELOCITY();

    public abstract double MAX_VELOCITY();

    public abstract double LAUNCHER_REFRACTORY_PERIOD();

    public abstract double LIFE_TIME();

    public abstract double DAMAGE_FRONT();

    public abstract double DAMAGE_SIDE();

    public abstract double DAMAGE_REAR();

    public abstract double FORCE_HIT();

    public abstract int EXPLOSION_SIZE();

    public abstract Collision discoverCollision(MotionTargetLaunchable var1, MotionTargetPanzer var2);

    public abstract void draw(GL var1, ArenaController var2);

    public MotionTargetLaunchable calculateMotion(SimulationState state, double elapsedTime) {
        if (elapsedTime < 1.0E-7) {
            return new MotionTargetLaunchable(this, this.pos, this.pos, this.orientation, this.velocity, elapsedTime);
        }
        Vector newPos = this.pos.add(this.velocity.mult(elapsedTime));
        return new MotionTargetLaunchable(this, this.pos, newPos, this.orientation, this.velocity, elapsedTime);
    }

    public abstract void detonate();

    public void applyMotionTarget(MotionTargetLaunchable target) {
        assert (target.inceptor == this);
        this.pos = target.endPos;
        this.orientation = target.orientation;
        this.velocity = target.velocity;
        this.timeInFrame = target.targetTime;
        this.age += target.targetTime;
    }

    public final Angle getOrientation() {
        return this.orientation;
    }

    public final Vector getPos() {
        return this.pos;
    }

    public final Vector getVelocity() {
        return this.velocity;
    }
}

