/*
 * Decompiled with CFR 0.152.
 */
package jrobots.simulation.simulationObjects.launchables;

import java.awt.Color;
import javax.media.opengl.GL;
import jrobots.graphics.ArenaController;
import jrobots.graphics.SmokeGenerator;
import jrobots.simulation.SimulationState;
import jrobots.simulation.simulationObjects.AbstractPilot;
import jrobots.simulation.simulationObjects.Collision;
import jrobots.simulation.simulationObjects.MotionTargetLaunchable;
import jrobots.simulation.simulationObjects.MotionTargetPanzer;
import jrobots.simulation.simulationObjects.Panzer;
import jrobots.simulation.simulationObjects.droppables.Mine;
import jrobots.simulation.simulationObjects.launchables.Launchable;
import jrobots.utils.Angle;
import jrobots.utils.Vector;

public class Minethrower
extends Launchable {
    private static final long serialVersionUID = 6817064572275326694L;
    public static final double MUZZLE_VELOCITY = 50.0;
    public static final double RELOADTIME = 0.9;
    public static final double LIFE_TIME = 6.0;
    public static final double DAMAGE_FRONT = -1.0;
    public static final double DAMAGE_SIDE = -1.0;
    public static final double DAMAGE_REAR = -1.0;
    public static final int EXPLOSION_SIZE = 4;
    public static final double FORCE_HIT = 1000000.0;
    protected final SmokeGenerator smokeGenerator;
    protected double lifeTime;

    @Override
    public double MUZZLE_VELOCITY() {
        return 50.0;
    }

    @Override
    public double MAX_VELOCITY() {
        return 50.0;
    }

    @Override
    public double LAUNCHER_REFRACTORY_PERIOD() {
        return 0.9;
    }

    @Override
    public double DAMAGE_FRONT() {
        return -1.0;
    }

    @Override
    public double DAMAGE_SIDE() {
        return -1.0;
    }

    @Override
    public double DAMAGE_REAR() {
        return -1.0;
    }

    @Override
    public double LIFE_TIME() {
        if (this.lifeTime > 0.0) {
            return 6.0;
        }
        return -1.0;
    }

    @Override
    public int EXPLOSION_SIZE() {
        return 4;
    }

    @Override
    public double FORCE_HIT() {
        return 1000000.0;
    }

    public Minethrower(double creationTime, Vector pos, Angle orientation, double range, int ownerID) {
        super(creationTime, pos, orientation, new Vector(orientation, 50.0), ownerID);
        this.lifeTime = range / this.MUZZLE_VELOCITY();
        this.smokeGenerator = new SmokeGenerator(250.0, 0.4, 2.0);
        this.smokeGenerator.generateSmoke(pos, pos.add(new Vector(orientation, 4.0)), this.creationTime, this.creationTime + 0.2, new Vector(orientation, 2.0));
    }

    @Override
    public Minethrower clone() {
        Minethrower clone = new Minethrower(this.creationTime, this.pos, this.orientation, this.lifeTime * this.MUZZLE_VELOCITY(), this.ownerID);
        clone.age = this.age;
        return clone;
    }

    @Override
    public MotionTargetLaunchable calculateMotion(SimulationState state, double elapsedTime) {
        this.lifeTime -= elapsedTime;
        if (this.lifeTime <= 0.0) {
            Panzer ownerPanzer = state.getPanzerByID(this.ownerID);
            AbstractPilot ownerPilot = ownerPanzer == null ? null : ownerPanzer.getPilot();
            Color mineColor = ownerPilot == null ? Color.WHITE : ownerPilot.getTurretColor();
            state.getMines().add(new Mine(this.pos, this.ownerID, mineColor));
            this.smokeGenerator.generateSmoke(this.pos, this.pos, this.creationTime + this.age, this.creationTime + this.age + 0.1, Vector.ZERO);
        }
        this.velocity = new Vector(this.velocity.getLength(), this.getOrientation());
        return super.calculateMotion(state, elapsedTime);
    }

    @Override
    public void applyMotionTarget(MotionTargetLaunchable target) {
        this.smokeGenerator.generateSmoke(target.startPos, target.endPos, this.creationTime + this.age, this.creationTime + this.age + target.targetTime * 0.1, new Vector(target.orientation, 20.0));
        super.applyMotionTarget(target);
    }

    @Override
    public Collision discoverCollision(MotionTargetLaunchable ownTgt, MotionTargetPanzer panzerTgt) {
        return null;
    }

    @Override
    public void draw(GL gl, ArenaController arena) {
        arena.drawGrenade(gl, this);
    }

    @Override
    public void detonate() {
    }
}

