/*
 * Decompiled with CFR 0.152.
 */
package jrobots.simulation.simulationObjects.launchables;

import javax.media.opengl.GL;
import jrobots.graphics.ArenaController;
import jrobots.graphics.SmokeGenerator;
import jrobots.simulation.SimulationState;
import jrobots.simulation.simulationObjects.Collision;
import jrobots.simulation.simulationObjects.CollisionPanzerExplosion;
import jrobots.simulation.simulationObjects.CollisionPanzerLaunchable;
import jrobots.simulation.simulationObjects.Directable;
import jrobots.simulation.simulationObjects.Explosion;
import jrobots.simulation.simulationObjects.MotionTargetLaunchable;
import jrobots.simulation.simulationObjects.MotionTargetPanzer;
import jrobots.simulation.simulationObjects.launchables.Launchable;
import jrobots.utils.Angle;
import jrobots.utils.Vector;

public class MiniMissile
extends Launchable
implements Directable {
    private static final long serialVersionUID = 6817064572275326694L;
    protected final SmokeGenerator smokeGenerator;
    protected boolean isDetonating = false;
    protected Vector lockOnPos;
    private static final Angle DELTA_ANGLE = new Angle(12.0, "d");
    public static final double DETONATION_DISTANCE = 4.0;
    public static final double DETONATION_OUTER_RADIUS = 10.0;
    public static final double DETONATION_INNER_RADIUS = 4.0;
    public static final double DETONATION_MAX_DAMAGE = 0.1;
    public static final double DETONATION_MAX_FORCE = 2500000.0;
    public static final double ACCELERATION = 48.0;
    public static final double FRICTION = 0.4;
    public static final double MUZZLE_VELOCITY = 70.0;
    public static final double RELOADTIME = 6.0;
    public static final double LIFE_TIME = 1.5625;
    public static final double DAMAGE_FRONT = 0.11;
    public static final double DAMAGE_SIDE = 0.14;
    public static final double DAMAGE_REAR = 0.17;
    public static final int EXPLOSION_SIZE = 3;
    public static final double FORCE_HIT = 1500000.0;
    public static final Angle EJECTION_ANGLE = new Angle(30.0, "d");

    @Override
    public double MUZZLE_VELOCITY() {
        return 70.0;
    }

    @Override
    public double MAX_VELOCITY() {
        return 70.0;
    }

    @Override
    public double LAUNCHER_REFRACTORY_PERIOD() {
        return 6.0;
    }

    @Override
    public double DAMAGE_FRONT() {
        return 0.11;
    }

    @Override
    public double DAMAGE_SIDE() {
        return 0.14;
    }

    @Override
    public double DAMAGE_REAR() {
        return 0.17;
    }

    @Override
    public double LIFE_TIME() {
        if (this.isDetonating) {
            return -1.0;
        }
        return Double.MAX_VALUE;
    }

    @Override
    public int EXPLOSION_SIZE() {
        return 3;
    }

    @Override
    public double FORCE_HIT() {
        return 1500000.0;
    }

    public static Angle getEjectionAngle() {
        return EJECTION_ANGLE;
    }

    public MiniMissile(double creationTime, Vector pos, Angle orientation, Vector velocity, Vector lockOnPos, int ownerID) {
        super(creationTime, pos, orientation, velocity, ownerID);
        this.lockOnPos = lockOnPos;
        this.smokeGenerator = new SmokeGenerator(120.0, 0.0, 0.8);
    }

    @Override
    public MiniMissile clone() {
        MiniMissile clone = new MiniMissile(this.creationTime, this.pos, this.orientation, this.velocity, this.lockOnPos, this.ownerID);
        clone.age = this.age;
        return clone;
    }

    @Override
    public MotionTargetLaunchable calculateMotion(SimulationState state, double elapsedTime) {
        if (this.lockOnPos != null || this.getAge() > 1.5625) {
            Angle distAngle;
            Double dir;
            Vector distance = this.lockOnPos.sub(this.pos);
            if (distance.getLength() <= 4.0 || distance.getLength() <= 12.0 && distance.projection(this.orientation) <= 0.0) {
                this.isDetonating = true;
                state.getExplosions().put(state.timestamp, new Explosion(this.pos, this.orientation, state.timestamp, this.EXPLOSION_SIZE()));
            }
            this.orientation = (dir = Double.valueOf(Angle.coneAngle(distAngle = distance.getAngle(), this.orientation))) >= 0.0 ? this.orientation.sub(DELTA_ANGLE) : this.orientation.add(DELTA_ANGLE);
        }
        this.velocity = this.velocity.add(new Vector(this.orientation, 48.0 * elapsedTime)).mult(Math.pow(0.4, elapsedTime));
        return super.calculateMotion(state, elapsedTime);
    }

    @Override
    public void applyMotionTarget(MotionTargetLaunchable target) {
        this.smokeGenerator.generateSmoke(target.startPos, target.endPos, this.creationTime + this.age, this.creationTime + this.age + target.targetTime, new Vector(target.orientation, -16.0));
        super.applyMotionTarget(target);
    }

    @Override
    public Collision discoverCollision(MotionTargetLaunchable ownTgt, MotionTargetPanzer panzerTgt) {
        if (this.isDetonating) {
            double distance = panzerTgt.calculateCenterDistance(this.getPos());
            if (distance <= 10.0) {
                return new CollisionPanzerExplosion(panzerTgt, this.pos, 10.0, 4.0, 0.1, 2500000.0);
            }
            return null;
        }
        return CollisionPanzerLaunchable.discoverCollision(panzerTgt, ownTgt);
    }

    @Override
    public void draw(GL gl, ArenaController arena) {
        arena.drawMiniMissile(gl, this);
    }

    @Override
    public void setDestination(Vector lockOnPos) {
        this.lockOnPos = lockOnPos;
    }

    @Override
    public void detonate() {
        this.isDetonating = true;
    }

    @Override
    public boolean isDetonating() {
        return this.isDetonating;
    }

    @Override
    public Vector getPosition() {
        return this.pos;
    }

    @Override
    public Vector getDestination() {
        return this.lockOnPos;
    }

    @Override
    public Angle getTargetBearing() {
        return null;
    }

    @Override
    public void setTargetBearing(Angle bearing) {
    }
}

