/*
 * Decompiled with CFR 0.152.
 */
package jrobots.simulation.simulationObjects.launchables;

import javax.media.opengl.GL;
import jrobots.graphics.ArenaController;
import jrobots.graphics.SmokeGenerator;
import jrobots.simulation.SimulationState;
import jrobots.simulation.simulationObjects.Collision;
import jrobots.simulation.simulationObjects.CollisionPanzerExplosion;
import jrobots.simulation.simulationObjects.CollisionPanzerLaunchable;
import jrobots.simulation.simulationObjects.Directable;
import jrobots.simulation.simulationObjects.MotionTargetLaunchable;
import jrobots.simulation.simulationObjects.MotionTargetPanzer;
import jrobots.simulation.simulationObjects.launchables.Launchable;
import jrobots.utils.Angle;
import jrobots.utils.Vector;

public class Rocket
extends Launchable
implements Directable {
    private static final long serialVersionUID = 6817064572275326694L;
    protected final SmokeGenerator smokeGenerator;
    protected boolean isDetonating = false;
    protected Angle targetBearing;
    private static final Angle DELTA_ANGLE = new Angle(4.0, "d");
    public static final double DETONATION_DISTANCE = 4.0;
    public static final double DETONATION_OUTER_RADIUS = 10.0;
    public static final double DETONATION_INNER_RADIUS = 2.0;
    public static final double DETONATION_MAX_DAMAGE = 0.1;
    public static final double DETONATION_MAX_FORCE = 5000000.0;
    public static final double ACCELERATION = 26.0;
    public static final double FRICTION = 0.5;
    public static final double MUZZLE_VELOCITY = 70.0;
    public static final double RELOADTIME = 6.0;
    public static final double LIFE_TIME = Double.MAX_VALUE;
    public static final double DAMAGE_FRONT = 0.14;
    public static final double DAMAGE_SIDE = 0.19;
    public static final double DAMAGE_REAR = 0.31;
    public static final int EXPLOSION_SIZE = 5;
    public static final double FORCE_HIT = 6000000.0;

    @Override
    public double MUZZLE_VELOCITY() {
        return 70.0;
    }

    @Override
    public double MAX_VELOCITY() {
        return 70.0;
    }

    @Override
    public double LAUNCHER_REFRACTORY_PERIOD() {
        return 6.0;
    }

    @Override
    public double DAMAGE_FRONT() {
        return 0.14;
    }

    @Override
    public double DAMAGE_SIDE() {
        return 0.19;
    }

    @Override
    public double DAMAGE_REAR() {
        return 0.31;
    }

    @Override
    public double LIFE_TIME() {
        if (this.isDetonating) {
            return -1.0;
        }
        return Double.MAX_VALUE;
    }

    @Override
    public int EXPLOSION_SIZE() {
        return 5;
    }

    @Override
    public double FORCE_HIT() {
        return 6000000.0;
    }

    public Rocket(double creationTime, Vector pos, Angle orientation, Vector velocity, Angle targetBearing, int ownerID) {
        super(creationTime, pos, orientation, velocity, ownerID);
        this.targetBearing = targetBearing;
        this.smokeGenerator = new SmokeGenerator(200.0, 0.0, 1.5);
    }

    @Override
    public Rocket clone() {
        Rocket clone = new Rocket(this.creationTime, this.pos, this.orientation, this.velocity, this.targetBearing, this.ownerID);
        clone.age = this.age;
        return clone;
    }

    @Override
    public MotionTargetLaunchable calculateMotion(SimulationState state, double elapsedTime) {
        if (this.targetBearing != null) {
            double dir = Angle.coneAngle(this.targetBearing, this.orientation);
            if (Math.abs(dir) < Rocket.DELTA_ANGLE.angle) {
                this.orientation = this.targetBearing;
                this.targetBearing = null;
            } else {
                this.orientation = dir >= 0.0 ? this.orientation.sub(DELTA_ANGLE) : this.orientation.add(DELTA_ANGLE);
            }
        }
        this.velocity = this.velocity.add(new Vector(this.orientation, 26.0 * elapsedTime)).mult(Math.pow(0.5, elapsedTime));
        return super.calculateMotion(state, elapsedTime);
    }

    @Override
    public void applyMotionTarget(MotionTargetLaunchable target) {
        this.smokeGenerator.generateSmoke(target.startPos, target.endPos, this.creationTime + this.age, this.creationTime + this.age + target.targetTime, new Vector(target.orientation, -13.0));
        super.applyMotionTarget(target);
    }

    @Override
    public Collision discoverCollision(MotionTargetLaunchable ownTgt, MotionTargetPanzer panzerTgt) {
        if (this.isDetonating) {
            double distance = panzerTgt.calculateCenterDistance(this.getPos());
            if (distance <= 10.0) {
                return new CollisionPanzerExplosion(panzerTgt, this.pos, 10.0, 2.0, 0.1, 5000000.0);
            }
            return null;
        }
        if (this.age <= 2.0 && panzerTgt.getInceptor().getID() == this.ownerID) {
            return null;
        }
        if (this.age > 20.0 && panzerTgt.calculateCenterDistance(this.getPos()) > 250.0) {
            this.detonate();
        }
        return CollisionPanzerLaunchable.discoverCollision(panzerTgt, ownTgt);
    }

    @Override
    public void draw(GL gl, ArenaController arena) {
        arena.drawRocket(gl, this);
    }

    @Override
    public void setDestination(Vector lockOnPos) {
        this.targetBearing = lockOnPos.sub(this.pos).getAngle();
    }

    @Override
    public void detonate() {
        this.isDetonating = true;
    }

    @Override
    public boolean isDetonating() {
        return this.isDetonating;
    }

    @Override
    public Vector getPosition() {
        return this.pos;
    }

    @Override
    public Vector getDestination() {
        return null;
    }

    @Override
    public Angle getTargetBearing() {
        return this.targetBearing;
    }

    @Override
    public void setTargetBearing(Angle bearing) {
        this.targetBearing = bearing.normalize();
    }
}

