/*
 * Decompiled with CFR 0.152.
 */
package jrobots.utils;

import java.io.Serializable;

public class Angle
implements Serializable,
Cloneable {
    private static final long serialVersionUID = -3177226067817741184L;
    public static final Angle EAST = new Angle();
    public static final Angle SOUTH = new Angle(90.0, "d");
    public static final Angle WEST = new Angle(180.0, "d");
    public static final Angle NORTH = new Angle(270.0, "d");
    public final double angle;

    public Angle() {
        this.angle = 0.0;
    }

    public Angle(double value, String units) {
        int c = 101;
        if (units.length() > 0) {
            c = units.toLowerCase().charAt(0);
        }
        switch (c) {
            case 114: {
                this.angle = value;
                break;
            }
            case 100: {
                this.angle = value / 180.0 * Math.PI;
                break;
            }
            default: {
                throw new IllegalArgumentException("Der zweite Parameter muss mit 'r' oder 'd' beginnen!");
            }
        }
        this.validityCheck();
    }

    private void validityCheck() {
        if (Double.isNaN(this.angle) || Double.isInfinite(this.angle)) {
            throw new IllegalArgumentException("Der Winkel darf nicht NaN oder Infinite sein!");
        }
    }

    public Angle normalize() {
        return new Angle((this.angle % (Math.PI * 2) + Math.PI * 2) % (Math.PI * 2), "Radians");
    }

    public double getValueAsDegrees() {
        return this.angle / Math.PI * 180.0;
    }

    public double getValueAsRadians() {
        return this.angle;
    }

    public Angle add(Angle a) {
        return new Angle(this.angle + a.angle, "Radians");
    }

    public Angle sub(Angle a) {
        return new Angle(this.angle - a.angle, "R");
    }

    public Angle mult(double factor) {
        return new Angle(this.angle * factor, "R");
    }

    public Angle getNegative() {
        return new Angle(-this.angle, "R");
    }

    public Angle getOpposite() {
        return new Angle(((this.angle + Math.PI) % (Math.PI * 2) + Math.PI * 2) % (Math.PI * 2), "R");
    }

    public Angle getNextQuadrant() {
        return new Angle(((this.angle + 1.5707963267948966) % (Math.PI * 2) + Math.PI * 2) % (Math.PI * 2), "R");
    }

    public Angle getPreviousQuadrant() {
        return new Angle(((this.angle - 1.5707963267948966) % (Math.PI * 2) + Math.PI * 2) % (Math.PI * 2), "R");
    }

    public boolean isPositive() {
        return this.angle > 0.0;
    }

    public Angle angularDistance(Angle a) {
        Angle result = a.normalize().sub(this.normalize());
        if (result.angle <= -Math.PI) {
            return result.add(new Angle(Math.PI, "r"));
        }
        if (result.angle > Math.PI) {
            return result.sub(new Angle(Math.PI, "r"));
        }
        return result;
    }

    public static final double coneAngle(Angle d1, Angle d2) {
        Angle n1 = d1.normalize();
        Angle n2 = d2.normalize();
        double dir = n2.sub((Angle)n1).angle;
        double result = dir <= Math.PI ? (dir >= -Math.PI ? dir : Math.PI * 2 + dir) : -(Math.PI * 2 - dir);
        assert (Math.abs(result) <= Math.PI) : "coneAngle calculation error: " + result + " for " + n2.angle + "-" + n1.angle;
        return result;
    }

    public String toString() {
        return "Angle:" + this.angle / Math.PI * 180.0 + '\u00b0';
    }

    public Angle clone() {
        return new Angle(this.angle, "r");
    }
}

