/*
 * Decompiled with CFR 0.152.
 */
package jrobots.utils;

import java.io.Serializable;
import jrobots.utils.Angle;
import jrobots.utils.Scan;
import jrobots.utils.SonarTrace;
import jrobots.utils.Vector;

public final class LinearPredictor
implements Serializable,
Cloneable {
    private static final long serialVersionUID = -6927416156239395949L;

    protected LinearPredictor() {
    }

    public static Vector predict(Scan scan1, Scan scan2, double time) {
        Vector pos1 = scan1.estimatedTargetPosition();
        Vector pos2 = scan2.estimatedTargetPosition();
        Vector deltaPos = pos2.sub(pos1);
        double deltaT = scan2.timeOfScan - scan1.timeOfScan;
        if (deltaT == 0.0) {
            return pos1;
        }
        double scale = (time - scan2.timeOfScan) / deltaT;
        return pos2.add(deltaPos.mult(scale));
    }

    public static Vector predict(SonarTrace trace1, SonarTrace trace2, double time) {
        Vector pos1 = trace1.location;
        Vector pos2 = trace2.location;
        Vector deltaPos = pos2.sub(pos1);
        double deltaT = trace2.timestamp - trace1.timestamp;
        if (deltaT == 0.0) {
            return pos1;
        }
        double scale = (time - trace2.timestamp) / deltaT;
        return pos2.add(deltaPos.mult(scale));
    }

    public static Scan constructScan(Vector targetPosition, double timeOfScan) {
        return new Scan(Angle.EAST, new Angle(360.0, "d"), 0.0, targetPosition, timeOfScan);
    }
}

