/*
 * Decompiled with CFR 0.152.
 */
package jrobots.utils;

import java.io.Serializable;
import jrobots.utils.Angle;
import jrobots.utils.Vector;

public class Scan
implements Serializable,
Cloneable {
    private static final long serialVersionUID = -5182428340952993253L;
    public final Angle scanDirection;
    public final Angle scanAperture;
    public final double distanceToTarget;
    public final Vector scannerPosition;
    public final double timeOfScan;

    public Scan(Angle scanDirection, Angle scanAperture, double distanceToTarget, Vector scannerPosition, double timeOfScan) {
        this.scanDirection = scanDirection;
        this.scanAperture = scanAperture;
        this.distanceToTarget = distanceToTarget;
        this.scannerPosition = scannerPosition;
        this.timeOfScan = timeOfScan;
    }

    public Vector estimatedTargetPosition() {
        return this.scannerPosition.add(new Vector(this.scanDirection, this.distanceToTarget));
    }

    public double getArcLength() {
        return this.scanAperture.getValueAsRadians() * this.distanceToTarget;
    }

    public boolean isTargetLocated() {
        return this.distanceToTarget > 0.0;
    }
}

