/*
 * Decompiled with CFR 0.152.
 */
package jrobots.utils;

import java.io.Serializable;
import jrobots.utils.Angle;

public class Vector
implements Serializable,
Cloneable {
    private static final long serialVersionUID = -1597769633640955671L;
    public static final Vector ZERO = new Vector(0.0, 0.0);
    private final double x;
    private final double y;

    public Vector() {
        this.x = 0.0;
        this.y = 0.0;
    }

    public Vector(double x, double y) {
        this.x = x;
        this.y = y;
        this.validityCheck();
    }

    public Vector(double length, Angle angle) {
        this.x = Math.cos(angle.getValueAsRadians()) * length;
        this.y = Math.sin(angle.getValueAsRadians()) * length;
        this.validityCheck();
    }

    public Vector(Angle angle, double length) {
        this.x = Math.cos(angle.getValueAsRadians()) * length;
        this.y = Math.sin(angle.getValueAsRadians()) * length;
        this.validityCheck();
    }

    private void validityCheck() {
        if (Double.isNaN(this.x) || Double.isInfinite(this.x) || Double.isNaN(this.y) || Double.isInfinite(this.y)) {
            throw new IllegalArgumentException("Die Parameter d&uuml;rfen nicht NaN oder Infinite sein!");
        }
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public Vector add(Vector v) {
        return new Vector(this.x + v.x, this.y + v.y);
    }

    public Vector sub(Vector v) {
        return new Vector(this.x - v.x, this.y - v.y);
    }

    public Vector mult(double factor) {
        return new Vector(this.x * factor, this.y * factor);
    }

    public Vector getNormal() {
        double length = this.getLength();
        if (length == 0.0) {
            return new Vector(1.0, 0.0);
        }
        return new Vector(this.x / length, this.y / length);
    }

    public Vector getNegative() {
        return new Vector(-this.x, -this.y);
    }

    public double getLength() {
        return Math.sqrt(this.x * this.x + this.y * this.y);
    }

    public Angle getAngle() {
        if (this.x == 0.0 && this.y == 0.0) {
            return new Angle();
        }
        if (this.x == 0.0) {
            if (this.y > 0.0) {
                return new Angle(90.0, "Degrees");
            }
            return new Angle(270.0, "Degrees");
        }
        if (this.y == 0.0) {
            if (this.x > 0.0) {
                return new Angle(0.0, "Degrees");
            }
            return new Angle(180.0, "Degrees");
        }
        if (this.x > 0.0) {
            return new Angle(Math.atan(this.y / this.x), "Radians");
        }
        return new Angle(Math.atan(this.y / this.x) + Math.PI, "Radians");
    }

    public double vectorProduct(Vector b) {
        return this.x * b.y - this.y * b.x;
    }

    public double projection(Angle angle) {
        return Math.cos(angle.getValueAsRadians()) * this.x + Math.sin(angle.getValueAsRadians()) * this.y;
    }

    public Vector rotate(Angle angle) {
        return new Vector(Math.cos(angle.getValueAsRadians()) * this.x - Math.sin(angle.getValueAsRadians()) * this.y, Math.sin(angle.getValueAsRadians()) * this.x + Math.cos(angle.getValueAsRadians()) * this.y);
    }

    public double distanceTo(Vector b) {
        return Math.sqrt((this.x - b.x) * (this.x - b.x) + (this.y - b.y) * (this.y - b.y));
    }

    public String toString() {
        return "Vector: x:" + this.x + " y:" + this.y + " length:" + this.getLength() + " " + this.getAngle();
    }

    public Vector clone() {
        return new Vector(this.x, this.y);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        long temp = Double.doubleToLongBits(this.x);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.y);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Vector)) {
            return false;
        }
        Vector other = (Vector)obj;
        if (Double.doubleToLongBits(this.x) != Double.doubleToLongBits(other.x)) {
            return false;
        }
        return Double.doubleToLongBits(this.y) == Double.doubleToLongBits(other.y);
    }
}

